/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.cdo.common.CDOQueryInfo;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.server.IQueryHandler;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.hibernate.IHibernateStoreAccessor;
import org.eclipse.emf.cdo.server.hibernate.id.CDOIDHibernate;
import org.eclipse.emf.cdo.server.hibernate.internal.id.CDOIDHibernateFactoryImpl;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateStore;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateStoreChunkReader;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateThreadContext;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateUtil;
import org.eclipse.emf.cdo.server.internal.hibernate.bundle.OM;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.PersistableListHolder;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.server.Store;
import org.eclipse.emf.cdo.spi.server.StoreAccessor;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.CloseableIterator;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.hibernate.Criteria;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateStoreAccessor
extends StoreAccessor
implements IHibernateStoreAccessor {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, HibernateStoreAccessor.class);
    private Session hibernateSession;
    private boolean errorOccured = false;

    public HibernateStoreAccessor(HibernateStore store, ISession session) {
        super((Store)store, session);
        HibernateThreadContext.setCurrentHibernateStoreAccessor(this);
        if (TRACER.isEnabled()) {
            TRACER.trace("Created " + this.getClass().getName() + " for repository " + store.getRepository().getName());
        }
    }

    public HibernateStoreAccessor(HibernateStore store, ITransaction transaction) {
        super((Store)store, transaction);
        HibernateThreadContext.setCurrentHibernateStoreAccessor(this);
        if (TRACER.isEnabled()) {
            TRACER.trace("Created " + this.getClass().getName() + " for repository " + store.getRepository().getName());
        }
    }

    public void resetHibernateSession() {
        this.endHibernateSession();
        this.beginHibernateSession();
    }

    @Override
    public HibernateStore getStore() {
        return (HibernateStore)super.getStore();
    }

    public void beginHibernateSession() {
        if (TRACER.isEnabled()) {
            TRACER.trace("Creating hibernate session and transaction");
        }
        assert (this.hibernateSession == null);
        SessionFactory sessionFactory = this.getStore().getHibernateSessionFactory();
        this.hibernateSession = sessionFactory.openSession();
        this.hibernateSession.beginTransaction();
    }

    public void commitRollbackHibernateSession() {
        if (TRACER.isEnabled()) {
            TRACER.trace("Commiting hibernate session");
        }
        if (this.isErrorOccured()) {
            if (TRACER.isEnabled()) {
                TRACER.trace("Rolling back hb transaction");
            }
            this.hibernateSession.getTransaction().rollback();
        } else {
            if (TRACER.isEnabled()) {
                TRACER.trace("Committing hb transaction");
            }
            this.hibernateSession.getTransaction().commit();
        }
    }

    public void endHibernateSession() {
        if (TRACER.isEnabled()) {
            TRACER.trace("Closing hibernate session");
        }
        if (this.hibernateSession != null && this.hibernateSession.isOpen()) {
            try {
                if (this.hibernateSession.getTransaction().isActive()) {
                    this.commitRollbackHibernateSession();
                }
            }
            finally {
                this.hibernateSession.close();
            }
        }
        this.hibernateSession = null;
    }

    @Override
    public Session getHibernateSession() {
        if (this.hibernateSession == null) {
            this.beginHibernateSession();
        }
        return this.hibernateSession;
    }

    public boolean isErrorOccured() {
        return this.errorOccured;
    }

    public void setErrorOccured(boolean errorOccured) {
        this.errorOccured = errorOccured;
    }

    @Override
    public HibernateStoreChunkReader createChunkReader(InternalCDORevision revision, EStructuralFeature feature) {
        return new HibernateStoreChunkReader(this, (CDORevision)revision, feature);
    }

    public CloseableIterator<Object> createQueryIterator(CDOQueryInfo queryInfo) {
        throw new UnsupportedOperationException();
    }

    public Collection<InternalCDOPackageUnit> readPackageUnits() {
        return this.getStore().getPackageHandler().getPackageUnits();
    }

    public EPackage[] loadPackageUnit(InternalCDOPackageUnit packageUnit) {
        return this.getStore().getPackageHandler().loadPackageUnit(packageUnit);
    }

    public InternalCDORevision readRevision(CDOID id, int listChunk, IStoreAccessor.AdditionalRevisionCache cache) {
        return HibernateUtil.getInstance().getCDORevision(id);
    }

    public InternalCDORevision readRevisionByTime(CDOID id, int listChunk, IStoreAccessor.AdditionalRevisionCache cache, long timeStamp) {
        throw new UnsupportedOperationException();
    }

    public InternalCDORevision readRevisionByVersion(CDOID id, int listChunk, IStoreAccessor.AdditionalRevisionCache cache, int version) {
        throw new UnsupportedOperationException();
    }

    public void refreshRevisions() {
    }

    public void queryResources(IStoreAccessor.QueryResourcesContext context) {
        CDOIDHibernate folderID = this.getHibernateID(context.getFolderID());
        String name = context.getName();
        boolean exactMatch = context.exactMatch();
        Session session = this.getHibernateSession();
        Criteria criteria = session.createCriteria(EresourcePackage.eINSTANCE.getCDOResourceNode().getName());
        if (folderID == null) {
            criteria.add(Expression.isNull((String)"containerID"));
        } else {
            criteria.add((Criterion)Expression.eq((String)"containerID", (Object)folderID));
        }
        List result = criteria.list();
        for (Object o : result) {
            boolean match;
            CDORevision revision = (CDORevision)o;
            EStructuralFeature feature = revision.getEClass().getEStructuralFeature("name");
            if (feature == null) continue;
            String revisionName = (String)revision.data().get(feature, 0);
            boolean bl = match = exactMatch || revisionName == null || name == null ? ObjectUtil.equals((Object)revisionName, (Object)name) : revisionName.startsWith(name);
            if (match && !context.addResource(revision.getID())) break;
        }
    }

    private CDOIDHibernate getHibernateID(CDOID id) {
        if (!CDOIDUtil.isNull((CDOID)id)) {
            if (id instanceof CDOIDHibernate) {
                return (CDOIDHibernate)id;
            }
            long longID = CDOIDUtil.getLong((CDOID)id);
            return CDOIDHibernateFactoryImpl.getInstance().createCDOID((Serializable)Long.valueOf(longID), EresourcePackage.eINSTANCE.getCDOResourceNode().getName());
        }
        return null;
    }

    public IQueryHandler getQueryHandler(CDOQueryInfo info) {
        return null;
    }

    public void commit(OMMonitor monitor) {
        this.commitRollbackHibernateSession();
        HibernateThreadContext.setCommitContext(null);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void write(IStoreAccessor.CommitContext context, OMMonitor monitor) {
        adjustRevisions = new ArrayList<InternalCDORevision>();
        HibernateThreadContext.setCommitContext(context);
        if (context.getNewPackageUnits().length > 0) {
            this.writePackageUnits(context.getNewPackageUnits(), monitor);
        }
        try {
            try {
                session = this.getHibernateSession();
                session.setFlushMode(FlushMode.MANUAL);
                var8_6 = context.getDirtyObjects();
                var7_9 = ((InternalCDORevision[])var8_6).length;
                var6_13 = 0;
                while (var6_13 < var7_9) {
                    cdoRevision = var8_6[var6_13];
                    if (cdoRevision instanceof InternalCDORevision) {
                        internalCDORevision = cdoRevision;
                        internalCDORevision.setVersion(cdoRevision.getVersion() - 1);
                        adjustRevisions.add(internalCDORevision);
                    }
                    ++var6_13;
                }
                var8_6 = context.getDetachedObjects();
                var7_9 = ((CDOID[])var8_6).length;
                var6_13 = 0;
                while (var6_13 < var7_9) {
                    cdoID = var8_6[var6_13];
                    revision = HibernateUtil.getInstance().getCDORevision((CDOID)cdoID);
                    session.delete((Object)revision);
                    ++var6_13;
                }
                cdoRevisions = Arrays.asList(context.getNewObjects());
                repairContainerIDs = new ArrayList<InternalCDORevision>();
                for (CDORevision cdoRevision : cdoRevisions) {
                    if (cdoRevision instanceof InternalCDORevision && (containerID = (CDOID)((InternalCDORevision)cdoRevision).getContainerID()) instanceof CDOIDTemp && !containerID.isNull()) {
                        repairContainerIDs.add((InternalCDORevision)cdoRevision);
                    }
                    session.merge(HibernateUtil.getInstance().getEntityName(cdoRevision), (Object)cdoRevision);
                    if (!HibernateStoreAccessor.TRACER.isEnabled()) continue;
                    HibernateStoreAccessor.TRACER.trace("Persisted new Object " + cdoRevision.getEClass().getName() + " id: " + cdoRevision.getID());
                }
                var10_19 = context.getDirtyObjects();
                containerID = var10_19.length;
                var8_7 = 0;
                while (var8_7 < containerID) {
                    cdoRevision = var10_19[var8_7];
                    session.merge(HibernateUtil.getInstance().getEntityName((CDORevision)cdoRevision), (Object)cdoRevision);
                    if (HibernateStoreAccessor.TRACER.isEnabled()) {
                        HibernateStoreAccessor.TRACER.trace("Updated Object " + cdoRevision.getEClass().getName() + " id: " + cdoRevision.getID());
                    }
                    ++var8_7;
                }
                session.flush();
                for (InternalCDORevision cdoRevision : repairContainerIDs) {
                    container = HibernateUtil.getInstance().getCDORevision((CDOID)cdoRevision.getContainerID());
                    entityName = HibernateUtil.getInstance().getEntityName((CDORevision)cdoRevision);
                    id = (CDOIDHibernate)cdoRevision.getID();
                    containerID = (CDOIDHibernate)container.getID();
                    hqlUpdate = "update " + entityName + " set contID_Entity = :contEntity, contID_ID=:contID, contID_class=:contClass where e_id = :id";
                    qry = session.createQuery(hqlUpdate);
                    qry.setParameter("contEntity", (Object)containerID.getEntityName());
                    qry.setParameter("contID", (Object)containerID.getId().toString());
                    qry.setParameter("contClass", (Object)containerID.getId().getClass().getName());
                    qry.setParameter("id", (Object)id.getId());
                    if (qry.executeUpdate() == 1) continue;
                    throw new IllegalStateException("Not able to update container columns of " + entityName + " with id " + id);
                }
                session.flush();
            }
            catch (Exception e) {
                OM.LOG.error((Throwable)e);
                throw WrappedException.wrap((Exception)e);
            }
        }
        finally {
            ** for (cdoRevision : adjustRevisions)
        }
lbl-1000:
        // 1 sources

        {
            cdoRevision.setVersion(cdoRevision.getVersion() + 1);
            continue;
        }
lbl79:
        // 1 sources

        context.applyIDMappings(monitor);
    }

    protected void detachObjects(CDOID[] detachedObjects, long revised, OMMonitor monitor) {
    }

    protected void rollback(IStoreAccessor.CommitContext context) {
        this.setErrorOccured(true);
        this.endHibernateSession();
        HibernateThreadContext.setCommitContext(null);
    }

    public void writePackageUnits(InternalCDOPackageUnit[] packageUnits, OMMonitor monitor) {
        if (packageUnits != null && packageUnits.length != 0) {
            this.getStore().getPackageHandler().writePackageUnits(packageUnits);
        }
        this.resetHibernateSession();
    }

    protected void writeRevisions(InternalCDORevision[] revisions, OMMonitor monitor) {
    }

    protected void addIDMappings(IStoreAccessor.CommitContext context, OMMonitor monitor) {
    }

    protected void writeRevisionDeltas(InternalCDORevisionDelta[] revisionDeltas, long created, OMMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    protected void doActivate() throws Exception {
    }

    protected void doDeactivate() throws Exception {
        if (TRACER.isEnabled()) {
            TRACER.trace("Committing/rollback and closing hibernate session");
        }
        try {
            this.endHibernateSession();
            PersistableListHolder.getInstance().clearListMapping();
        }
        finally {
            HibernateThreadContext.setCurrentHibernateStoreAccessor(this);
        }
    }

    protected void doPassivate() throws Exception {
    }

    protected void doUnpassivate() throws Exception {
    }
}

