/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping.property;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.hibernate.mapping.elist.HibernateFeatureMapEntry;
import org.eclipse.emf.teneo.util.StoreUtil;
import org.hibernate.HibernateException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.Setter;

public class FeatureMapEntryPropertyHandler
implements Getter,
Setter,
PropertyAccessor,
ExtensionPoint {
    private static final long serialVersionUID = -2659637883475733107L;
    private static Log log = LogFactory.getLog(FeatureMapEntryPropertyHandler.class);
    protected EStructuralFeature eFeature;

    public void initialize(EStructuralFeature eFeature) {
        this.eFeature = eFeature;
        log.debug((Object)("Created getter/setter for " + StoreUtil.toString((EStructuralFeature)eFeature)));
    }

    public Getter getGetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        return this;
    }

    public Setter getSetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        return this;
    }

    public Object get(Object owner) throws HibernateException {
        if (!(owner instanceof HibernateFeatureMapEntry)) {
            FeatureMap.Entry smf = (FeatureMap.Entry)owner;
            if (smf.getEStructuralFeature() == this.eFeature) {
                return smf.getValue();
            }
            return null;
        }
        HibernateFeatureMapEntry fme = (HibernateFeatureMapEntry)owner;
        Object value = fme.getValue(this.eFeature);
        return value;
    }

    public Object getForInsert(Object owner, Map mergeMap, SessionImplementor session) throws HibernateException {
        Object value = this.get(owner);
        return value;
    }

    public void set(Object target, Object value, SessionFactoryImplementor factory) throws HibernateException {
        if (!(target instanceof HibernateFeatureMapEntry)) {
            return;
        }
        HibernateFeatureMapEntry fme = (HibernateFeatureMapEntry)target;
        fme.addFeatureValue(this.eFeature, value);
    }

    public Method getMethod() {
        return null;
    }

    public String getMethodName() {
        return null;
    }

    public Class getReturnType() {
        return HibernateFeatureMapEntry.class;
    }
}

