/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.buddies.internal.common.protocol;

import java.io.IOException;
import org.eclipse.net4j.buddies.common.IBuddyProvider;
import org.eclipse.net4j.buddies.common.ICollaborationProvider;
import org.eclipse.net4j.buddies.internal.common.Buddy;
import org.eclipse.net4j.buddies.internal.common.Collaboration;
import org.eclipse.net4j.signal.Indication;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;

public class CollaborationLeftIndication
extends Indication {
    private IBuddyProvider buddyProvider;
    private ICollaborationProvider collaborationProvider;

    public CollaborationLeftIndication(IBuddyProvider buddyProvider, ICollaborationProvider collaborationProvider) {
        this.buddyProvider = buddyProvider;
        this.collaborationProvider = collaborationProvider;
    }

    protected short getSignalID() {
        return 8;
    }

    protected void indicating(ExtendedDataInputStream in) throws IOException {
        Buddy buddy;
        long collaborationID = in.readLong();
        String userID = in.readString();
        Collaboration collaboration = this.getCollaboration(collaborationID);
        if (collaboration != null && (buddy = this.getBuddy(userID)) != null) {
            this.collaborationLeft(buddy, collaboration);
        }
    }

    protected void collaborationLeft(Buddy buddy, Collaboration collaboration) {
        collaboration.removeMembership(buddy);
        buddy.removeMembership(collaboration);
    }

    protected Collaboration getCollaboration(long collaborationID) {
        return (Collaboration)this.collaborationProvider.getCollaboration(collaborationID);
    }

    protected Buddy getBuddy(String userID) {
        return (Buddy)this.buddyProvider.getBuddy(userID);
    }
}

