/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.views;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.net4j.util.internal.ui.bundle.OM;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.ViewPart;

public abstract class MultiViewersView
extends ViewPart
implements ISetSelectionTarget {
    private Shell shell;
    private StructuredViewer currentViewer;

    public Shell getShell() {
        return this.shell;
    }

    public StructuredViewer getCurrentViewer() {
        return this.currentViewer;
    }

    public void setCurrentViewer(StructuredViewer viewer) {
        this.currentViewer = viewer;
        this.getSite().setSelectionProvider((ISelectionProvider)this.currentViewer);
        this.hookContextMenu(this.currentViewer);
    }

    public void setFocus() {
        StructuredViewer viewer = this.getCurrentViewer();
        if (viewer != null) {
            viewer.getControl().setFocus();
        }
    }

    public void refreshViewer(boolean updateLabels) {
        this.refreshElement(null, updateLabels);
    }

    public void refreshElement(final Object element, final boolean updateLabels) {
        try {
            final StructuredViewer viewer = this.getCurrentViewer();
            if (viewer != null) {
                this.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            if (element != null) {
                                viewer.refresh(element, updateLabels);
                            } else {
                                viewer.refresh(updateLabels);
                            }
                        }
                        catch (RuntimeException runtimeException) {}
                    }
                });
            }
        }
        catch (RuntimeException runtimeException) {}
    }

    public void updateLabels(final Object element) {
        try {
            final StructuredViewer viewer = this.getCurrentViewer();
            if (viewer != null) {
                this.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            viewer.update(element, null);
                        }
                        catch (RuntimeException runtimeException) {}
                    }
                });
            }
        }
        catch (RuntimeException runtimeException) {}
    }

    public void revealElement(final Object element) {
        try {
            final StructuredViewer viewer = this.getCurrentViewer();
            if (viewer != null) {
                this.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            viewer.reveal(element);
                        }
                        catch (RuntimeException runtimeException) {}
                    }
                });
            }
        }
        catch (RuntimeException runtimeException) {}
    }

    public void selectReveal(ISelection selection) {
        StructuredViewer viewer = this.getCurrentViewer();
        if (viewer != null) {
            viewer.setSelection(selection, true);
        }
    }

    public void closeView() {
        try {
            this.getSite().getShell().getDisplay().syncExec(new Runnable(){

                public void run() {
                    try {
                        MultiViewersView.this.getSite().getPage().hideView((IViewPart)MultiViewersView.this);
                        MultiViewersView.this.dispose();
                    }
                    catch (Exception exception) {}
                }
            });
        }
        catch (Exception exception) {}
    }

    public final void createPartControl(Composite parent) {
        try {
            this.shell = parent.getShell();
            Composite composite = UIUtil.createGridComposite(parent, 1);
            Control control = this.createUI(composite);
            control.setLayoutData((Object)UIUtil.createGridData());
            this.hookDoubleClick();
            this.contributeToActionBars();
        }
        catch (Error ex) {
            OM.LOG.error((Throwable)ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            OM.LOG.error((Throwable)ex);
            throw ex;
        }
    }

    protected abstract Control createUI(Composite var1);

    protected void doubleClicked(Object object) {
    }

    protected void fillContextMenu(IMenuManager manager, StructuredViewer viewer, IStructuredSelection selection) {
    }

    protected void fillLocalPullDown(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    protected final void showMessage(String message) {
        this.showMessage(MessageType.INFORMATION, message);
    }

    protected final boolean showMessage(MessageType type, String message) {
        switch (type) {
            case INFORMATION: {
                MessageDialog.openInformation((Shell)this.getShell(), (String)this.getTitle(), (String)message);
                return true;
            }
            case ERROR: {
                MessageDialog.openError((Shell)this.getShell(), (String)this.getTitle(), (String)message);
                return true;
            }
            case WARNING: {
                MessageDialog.openWarning((Shell)this.getShell(), (String)this.getTitle(), (String)message);
                return true;
            }
            case CONFIRM: {
                return MessageDialog.openConfirm((Shell)this.getShell(), (String)this.getTitle(), (String)message);
            }
            case QUESTION: {
                return MessageDialog.openQuestion((Shell)this.getShell(), (String)this.getTitle(), (String)message);
            }
        }
        return true;
    }

    protected final Display getDisplay() {
        Display display = null;
        StructuredViewer viewer = this.getCurrentViewer();
        if (viewer != null) {
            display = viewer.getControl().getDisplay();
        }
        if (display == null) {
            display = UIUtil.getDisplay();
        }
        return display;
    }

    private void hookDoubleClick() {
        final StructuredViewer viewer = this.getCurrentViewer();
        if (viewer != null) {
            viewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                    Object object = selection.getFirstElement();
                    MultiViewersView.this.doubleClicked(object);
                }
            });
        }
    }

    private void hookContextMenu(StructuredViewer viewer) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                StructuredViewer viewer = MultiViewersView.this.getCurrentViewer();
                if (viewer != null) {
                    IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                    MultiViewersView.this.fillContextMenu(manager, viewer, selection);
                }
            }
        });
        Control control = viewer.getControl();
        Menu menu = menuMgr.createContextMenu(control);
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum MessageType {
        INFORMATION,
        ERROR,
        WARNING,
        CONFIRM,
        QUESTION;

    }
}

