/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.command.InitializeCopyCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDRedefine;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.provider.XSDComponentItemProvider;
import org.eclipse.xsd.provider.XSDEditPlugin;
import org.eclipse.xsd.provider.XSDItemProviderAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDSchemaItemProvider
extends XSDComponentItemProvider {
    public XSDSchemaItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.createSchemaLocationPropertyDescriptor(object);
            this.createTargetNamespacePropertyDescriptor(object);
            this.createFinalDefaultPropertyDescriptor(object);
            this.createBlockDefaultPropertyDescriptor(object);
            this.createAttributeFormDefaultPropertyDescriptor(object);
            this.createElementFormDefaultPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void createSchemaLocationPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), XSDEditPlugin.INSTANCE.getString("_UI_SchemaLocation_label"), XSDEditPlugin.INSTANCE.getString("_UI_SchemaLocationOfSchema_description"), (EStructuralFeature)xsdPackage.getXSDSchema_SchemaLocation(), false, ItemPropertyDescriptor.TEXT_VALUE_IMAGE));
    }

    protected void createTargetNamespacePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), XSDEditPlugin.INSTANCE.getString("_UI_TargetNamespace_label"), XSDEditPlugin.INSTANCE.getString("_UI_TargetNamespaceOfSchema_description"), (EStructuralFeature)xsdPackage.getXSDSchema_TargetNamespace(), true, ItemPropertyDescriptor.TEXT_VALUE_IMAGE){

            public void setPropertyValue(Object o, Object value) {
                if ("".equals(value)) {
                    super.setPropertyValue(o, null);
                } else {
                    super.setPropertyValue(o, value);
                }
            }
        });
    }

    protected void createFinalDefaultPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), XSDEditPlugin.INSTANCE.getString("_UI_FinalDefault_label"), XSDEditPlugin.INSTANCE.getString("_UI_FinalDefault_description"), (EStructuralFeature)xsdPackage.getXSDSchema_FinalDefault(), true, ItemPropertyDescriptor.TEXT_VALUE_IMAGE){

            public Object getPropertyValue(Object o) {
                return ((XSDSchema)o).getStringFinalDefault();
            }

            public void setPropertyValue(Object o, Object value) {
                ((XSDSchema)o).setStringFinalDefault((String)value);
            }

            public Collection<?> getChoiceOfValues(Object o) {
                ArrayList<String> result = new ArrayList<String>();
                result.add("");
                result.add("#all");
                result.add("extension");
                result.add("restriction");
                result.add("restriction extension");
                return result;
            }
        });
    }

    protected void createBlockDefaultPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), XSDEditPlugin.INSTANCE.getString("_UI_BlockDefault_label"), XSDEditPlugin.INSTANCE.getString("_UI_BlockDefault_description"), (EStructuralFeature)xsdPackage.getXSDSchema_BlockDefault(), true, ItemPropertyDescriptor.TEXT_VALUE_IMAGE){

            public Object getPropertyValue(Object o) {
                return ((XSDSchema)o).getStringBlockDefault();
            }

            public void setPropertyValue(Object o, Object value) {
                ((XSDSchema)o).setStringBlockDefault((String)value);
            }

            public Collection<?> getChoiceOfValues(Object o) {
                ArrayList<String> result = new ArrayList<String>();
                result.add("");
                result.add("#all");
                result.add("extension");
                result.add("restriction");
                result.add("substitution");
                result.add("extension restriction");
                result.add("extension restriction substitution");
                result.add("extension substitution");
                result.add("restriction substitution");
                return result;
            }
        });
    }

    protected void createElementFormDefaultPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new XSDItemProviderAdapter.ItemPropertyDescriptorWithDefault((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), XSDEditPlugin.INSTANCE.getString("_UI_ElementFormDefault_label"), XSDEditPlugin.INSTANCE.getString("_UI_ElementFormDefault_description"), (EStructuralFeature)xsdPackage.getXSDSchema_ElementFormDefault(), true, ItemPropertyDescriptor.TEXT_VALUE_IMAGE));
    }

    protected void createAttributeFormDefaultPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new XSDItemProviderAdapter.ItemPropertyDescriptorWithDefault((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), XSDEditPlugin.INSTANCE.getString("_UI_AttributeFormDefault_label"), XSDEditPlugin.INSTANCE.getString("_UI_AttributeFormDefault_description"), (EStructuralFeature)xsdPackage.getXSDSchema_AttributeFormDefault(), true, ItemPropertyDescriptor.TEXT_VALUE_IMAGE));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(xsdPackage.getXSDSchema_Contents());
        }
        return this.childrenFeatures;
    }

    public Object getImage(Object object) {
        return XSDEditPlugin.INSTANCE.getImage("full/obj16/XSDSchema");
    }

    public String getText(Object object) {
        XSDSchema xsdSchema = (XSDSchema)object;
        String result = xsdSchema.getSchemaLocation();
        if (result == null) {
            return "";
        }
        return URI.createURI((String)result).lastSegment();
    }

    @Override
    public void notifyChanged(Notification msg) {
        if (msg.getFeature() == xsdPackage.getXSDSchema_SchemaLocation() || msg.getFeature() == xsdPackage.getXSDSchema_TypeDefinitions() || msg.getFeature() == xsdPackage.getXSDSchema_ElementDeclarations() || msg.getFeature() == xsdPackage.getXSDSchema_AttributeGroupDefinitions() || msg.getFeature() == xsdPackage.getXSDSchema_NotationDeclarations() || msg.getFeature() == xsdPackage.getXSDSchema_Contents() || msg.getFeature() == xsdPackage.getXSDSchema_ModelGroupDefinitions() || msg.getFeature() == xsdPackage.getXSDSchema_AttributeDeclarations() || msg.getFeature() == xsdPackage.getXSDSchema_AttributeFormDefault() || msg.getFeature() == xsdPackage.getXSDSchema_ElementFormDefault() || msg.getFeature() == xsdPackage.getXSDSchema_BlockDefault() || msg.getFeature() == xsdPackage.getXSDSchema_FinalDefault() || msg.getFeature() == xsdPackage.getXSDSchema_Annotations()) {
            this.fireNotifyChanged(msg);
            return;
        }
        super.notifyChanged(msg);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        XSDSchema xsdSchema = (XSDSchema)object;
        if (xsdSchema.getSchemaForSchema() != null) {
            EReference schemaContents = xsdPackage.getXSDSchema_Contents();
            newChildDescriptors.add(this.createChildParameter(schemaContents, (XSDConcreteComponent)xsdFactory.createXSDAnnotation()));
            newChildDescriptors.add(this.createChildParameter(schemaContents, (XSDConcreteComponent)xsdFactory.createXSDImport()));
            XSDInclude i = xsdFactory.createXSDInclude();
            i.setSchemaLocation("");
            newChildDescriptors.add(this.createChildParameter(schemaContents, (XSDConcreteComponent)i));
            XSDRedefine r = xsdFactory.createXSDRedefine();
            r.setSchemaLocation("");
            newChildDescriptors.add(this.createChildParameter(schemaContents, (XSDConcreteComponent)r));
            newChildDescriptors.add(this.createChildParameter(schemaContents, (XSDConcreteComponent)this.createElementDeclaration((XSDConcreteComponent)xsdSchema)));
            newChildDescriptors.add(this.createChildParameter(schemaContents, (XSDConcreteComponent)this.createAttributeDeclaration((XSDConcreteComponent)xsdSchema)));
            newChildDescriptors.add(this.createChildParameter(schemaContents, (XSDConcreteComponent)this.createModelGroupDefinition((XSDConcreteComponent)xsdSchema)));
            newChildDescriptors.add(this.createChildParameter(schemaContents, (XSDConcreteComponent)this.createAttributeGroupDefinition((XSDConcreteComponent)xsdSchema)));
            this.addSimpleTypeDefinitionChildParameters(newChildDescriptors, (XSDConcreteComponent)xsdSchema, schemaContents, true, true, true);
            newChildDescriptors.add(this.createChildParameter(schemaContents, (XSDConcreteComponent)this.createComplexTypeDefinition((XSDConcreteComponent)xsdSchema)));
            newChildDescriptors.add(this.createChildParameter(schemaContents, (XSDConcreteComponent)this.createNotationDeclaration((XSDConcreteComponent)xsdSchema)));
        }
    }

    @Override
    protected Command createInitializeCopyCommand(EditingDomain domain, EObject owner, CopyCommand.Helper helper) {
        return new InitializeCopyCommand(domain, owner, helper){

            protected Collection<? extends EAttribute> getAttributesToCopy() {
                ArrayList result = new ArrayList(this.owner.eClass().getEAllAttributes());
                result.remove(xsdPackage.getXSDConcreteComponent_Element());
                result.remove(xsdPackage.getXSDSchema_Document());
                return result;
            }

            protected void copyAttributes() {
                XSDSchema ownerSchema = (XSDSchema)this.owner;
                XSDSchema copySchema = (XSDSchema)this.copy;
                copySchema.getQNamePrefixToNamespaceMap().putAll(ownerSchema.getQNamePrefixToNamespaceMap());
                copySchema.setSchemaForSchemaQNamePrefix(ownerSchema.getSchemaForSchemaQNamePrefix());
                super.copyAttributes();
            }
        };
    }
}

