/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.model.tests;

import java.util.Collection;
import java.util.SortedSet;
import junit.framework.TestCase;
import org.eclipse.emf.validation.internal.util.Trace;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.model.CategoryManager;

public class CategoryTest
extends TestCase {
    private static CategoryManager mgr = CategoryManager.getInstance();

    public void test_getCategory() {
        Trace.trace((String)">>> Testing getCategory");
        Category top = mgr.getCategory("$test");
        CategoryTest.assertNotNull((Object)top);
        Category child = mgr.getCategory(top, "///$child");
        CategoryTest.assertNotNull((Object)child);
        CategoryTest.assertSame((Object)top, (Object)child.getParent());
        Category childAgain = mgr.getCategory("$test/$child");
        CategoryTest.assertSame((Object)child, (Object)childAgain);
        Category grandChild = mgr.getCategory("$test/$child/$grand");
        CategoryTest.assertNotNull((Object)grandChild);
        CategoryTest.assertSame((Object)grandChild, (Object)mgr.getCategory(top, "$child/$grand"));
    }

    public void test_findCategory() {
        Trace.trace((String)">>> Testing findCategory");
        Category top = mgr.findCategory("junit");
        CategoryTest.assertNotNull((Object)top);
        Category child = mgr.findCategory(top, "///validation");
        CategoryTest.assertNotNull((Object)child);
        Category sameChild = mgr.findCategory("junit/validation");
        CategoryTest.assertNotNull((Object)sameChild);
        CategoryTest.assertSame((Object)child, (Object)sameChild);
        Category notThere = mgr.findCategory("$boo");
        CategoryTest.assertNull((Object)notThere);
        notThere = mgr.findCategory("junit/$boo");
        CategoryTest.assertNull((Object)notThere);
        notThere = mgr.findCategory(top, "$boo");
        CategoryTest.assertNull((Object)notThere);
    }

    public void test_getTopLevelCategories() {
        SortedSet topLevel = mgr.getTopLevelCategories();
        for (Category next : topLevel) {
            CategoryTest.assertNull((Object)next.getParent());
        }
    }

    public void test_getMandatoryCategories() {
        Collection topLevel = mgr.getMandatoryCategories();
        for (Category next : topLevel) {
            CategoryTest.assertTrue((boolean)next.isMandatory());
        }
    }

    public void test_getDefaultCategory() {
        Category dflt = mgr.getDefaultCategory();
        CategoryTest.assertEquals((String)"", (String)dflt.getId());
        CategoryTest.assertEquals((String)"(default)", (String)dflt.getName());
        CategoryTest.assertNull((Object)dflt.getParent());
    }

    public void test_dumpCategories() {
        Trace.trace((String)">>> Testing dumpCategories");
        for (Category next : mgr.getTopLevelCategories()) {
            this.dumpCategory(next);
        }
    }

    private void dumpCategory(Category category) {
        Trace.trace((String)category.toString());
        for (Object next : category.getConstraints()) {
            Trace.trace((String)("    " + next));
        }
        for (Category child : category.getChildren()) {
            this.dumpCategory(child);
        }
    }
}

