/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.ui.editors.pages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.eef.runtime.ui.editors.pages.EEFEditorPage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public abstract class AbstractEEFEditorPage
extends FormPage
implements EEFEditorPage {
    protected ScrolledForm form;
    protected EditingDomain editingDomain;
    protected AdapterFactory adapterFactory;
    protected Object input;
    private String pageTitle;
    private Image pageImage;
    protected List<ViewerFilter> filters = new ArrayList<ViewerFilter>();
    protected List<Action> actions = new ArrayList<Action>();

    public AbstractEEFEditorPage(FormEditor editor, String id, String name) {
        super(editor, id, name);
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setEditingDomain(EditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void setAdapterFactory(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    public void setPageTitle(String title) {
        if (title != null) {
            this.pageTitle = title;
            if (this.formInitialized()) {
                this.refreshFormTitle();
            }
        }
    }

    public void setImage(Image image) {
        if (image != null) {
            this.pageImage = image;
            if (this.formInitialized()) {
                this.refreshFormImage();
            }
        }
    }

    protected boolean formInitialized() {
        return this.form != null;
    }

    public void setInput(Object newEObject) {
        if (newEObject != this.input) {
            this.input = newEObject;
            this.refresh();
        }
    }

    public void refresh() {
        if (this.formInitialized()) {
            this.refreshFilters();
            this.refreshFormContents();
            this.refreshFormTitle();
            this.refreshFormImage();
            this.refreshToolbar();
        }
    }

    protected void refreshToolbar() {
        if (this.getManagedForm().getForm() != null && !this.actions.isEmpty()) {
            IToolBarManager toolBarManager = this.getManagedForm().getForm().getToolBarManager();
            for (Action action : this.actions) {
                toolBarManager.add((IAction)action);
            }
            toolBarManager.update(true);
        }
    }

    protected void refreshFormTitle() {
        if (this.pageTitle != null) {
            this.form.setText(this.pageTitle);
        } else {
            Object titleProvider = null;
            titleProvider = this.input instanceof ResourceSet ? ((ResourceSet)this.input).getResources().get(0) : this.input;
            if (this.adapterFactory != null) {
                this.form.setText(new AdapterFactoryLabelProvider(this.adapterFactory).getText(titleProvider));
            }
        }
    }

    protected void refreshFormImage() {
        if (this.pageImage != null) {
            this.form.setImage(this.pageImage);
        } else {
            Object imageProvider = null;
            imageProvider = this.input instanceof ResourceSet ? ((ResourceSet)this.input).getResources().get(0) : this.input;
            if (this.adapterFactory != null) {
                this.form.setImage(new AdapterFactoryLabelProvider(this.adapterFactory).getImage(imageProvider));
            }
        }
    }

    protected abstract void refreshFormContents();

    public void addFilter(ViewerFilter filter) {
        this.filters.add(filter);
        if (this.getModelViewer() != null) {
            this.getModelViewer().addFilter(filter);
        }
    }

    public void addAction(Action action) {
        this.actions.add(action);
        if (this.getManagedForm() != null && this.getManagedForm().getForm() != null) {
            this.getManagedForm().getForm().getToolBarManager().add((IAction)action);
        }
    }

    protected void refreshFilters() {
        if (this.getModelViewer() != null) {
            for (ViewerFilter filter : this.filters) {
                this.getModelViewer().addFilter(filter);
            }
        }
    }
}

