/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.ui.widgets;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.eef.runtime.ui.utils.EditingUtils;
import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class EMFComboViewer
extends AbstractListViewer {
    private Combo combo;
    private boolean updating = false;

    public EMFComboViewer(Composite parent) {
        this(parent, 2056);
    }

    public EMFComboViewer(Composite parent, int style) {
        this(new Combo(parent, style));
    }

    public EMFComboViewer(Combo list) {
        this.combo = list;
        this.hookControl((Control)list);
        EditingUtils.setEEFtype((Control)this.combo, "eef::EMFComboViewer");
    }

    protected void listAdd(String string, int index) {
        this.combo.add(string, index);
    }

    protected void listSetItem(int index, String string) {
        this.combo.setItem(index, string);
    }

    protected int[] listGetSelectionIndices() {
        return new int[]{this.combo.getSelectionIndex()};
    }

    protected int listGetItemCount() {
        return this.combo.getItemCount();
    }

    protected void listSetItems(String[] labels) {
        this.combo.setItems(labels);
    }

    protected void listRemoveAll() {
        this.combo.removeAll();
    }

    protected void listRemove(int index) {
        this.combo.remove(index);
    }

    public Control getControl() {
        return this.combo;
    }

    public Combo getCombo() {
        return this.combo;
    }

    public void reveal(Object element) {
    }

    public void setID(Object id) {
        EditingUtils.setID((Control)this.combo, id);
    }

    public Object getID() {
        return EditingUtils.getID((Control)this.combo);
    }

    protected void listSetSelection(int[] ixs) {
        int idx = 0;
        while (idx < ixs.length) {
            this.combo.select(ixs[idx]);
            ++idx;
        }
    }

    protected void listDeselectAll() {
        this.combo.deselectAll();
        this.combo.clearSelection();
    }

    protected void listShowSelection() {
    }

    protected void setSelectionToWidget(List in, boolean reveal) {
        if (in == null || in.size() == 0) {
            this.listDeselectAll();
        } else {
            Object elem = in.get(0);
            int[] ixs = new int[]{-1};
            String[] literals = this.getCombo().getItems();
            String literalToSelect = "";
            literalToSelect = elem instanceof EObject && this.getLabelProvider() instanceof ILabelProvider ? ((ILabelProvider)this.getLabelProvider()).getText(elem) : elem.toString();
            int i = 0;
            while (i < literals.length) {
                String literal = literals[i];
                if (literal.equals(literalToSelect)) {
                    ixs[0] = i;
                    break;
                }
                ++i;
            }
            this.listSetSelection(ixs);
            if (reveal) {
                this.listShowSelection();
            }
        }
    }

    protected void updateSelection(ISelection selection) {
        if (!this.updating) {
            super.updateSelection(selection);
        }
    }

    public void modelUpdating(ISelection selection) {
        this.updating = true;
        this.setSelection(selection);
        this.updating = false;
    }

    public void setEnabled(boolean enabled) {
        this.combo.setEnabled(enabled);
    }

    public void setToolTipText(String tooltip) {
        this.combo.setToolTipText(tooltip);
    }
}

