/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.internal.widgets;

import com.google.common.base.Objects;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.eef.EEFCheckboxDescription;
import org.eclipse.eef.EEFCheckboxStyle;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.EEFWidgetStyle;
import org.eclipse.eef.common.ui.api.EEFWidgetFactory;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.EEFControllersFactory;
import org.eclipse.eef.core.api.controllers.IConsumer;
import org.eclipse.eef.core.api.controllers.IEEFCheckboxController;
import org.eclipse.eef.core.api.controllers.IEEFWidgetController;
import org.eclipse.eef.ide.internal.EEFIdePlugin;
import org.eclipse.eef.ide.ui.api.widgets.AbstractEEFWidgetLifecycleManager;
import org.eclipse.eef.ide.ui.api.widgets.EEFStyleHelper;
import org.eclipse.eef.ide.ui.internal.widgets.EEFCheckboxStyleCallback;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class EEFCheckboxLifecycleManager
extends AbstractEEFWidgetLifecycleManager {
    private EEFCheckboxDescription description;
    private Button checkbox;
    private IEEFCheckboxController controller;
    private SelectionListener selectionListener;

    public EEFCheckboxLifecycleManager(EEFCheckboxDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter contextAdapter) {
        super(variableManager, interpreter, contextAdapter);
        this.description = description;
    }

    @Override
    protected void createMainControl(Composite parent, IEEFFormContainer formContainer) {
        EEFWidgetFactory widgetFactory = formContainer.getWidgetFactory();
        this.checkbox = widgetFactory.createButton(parent, "", 32);
        GridData gridData = new GridData();
        gridData.horizontalIndent = 5;
        this.checkbox.setLayoutData((Object)gridData);
        this.controller = new EEFControllersFactory().createCheckboxController(this.description, this.variableManager, this.interpreter, this.contextAdapter);
    }

    @Override
    protected boolean needSeparatedLabel() {
        return false;
    }

    @Override
    protected IEEFWidgetController getController() {
        return this.controller;
    }

    @Override
    protected Control getValidationControl() {
        return this.checkbox;
    }

    @Override
    protected EEFWidgetDescription getWidgetDescription() {
        return this.description;
    }

    @Override
    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.getController().onNewLabel((IConsumer)new IConsumer<String>(){

            public void apply(String value) {
                if (!(EEFCheckboxLifecycleManager.this.checkbox.isDisposed() || EEFCheckboxLifecycleManager.this.checkbox.getText() != null && EEFCheckboxLifecycleManager.this.checkbox.getText().equals(value))) {
                    EEFCheckboxLifecycleManager.this.checkbox.setText((String)Objects.firstNonNull((Object)value, (Object)""));
                }
            }
        });
        this.selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                IStatus result = EEFCheckboxLifecycleManager.this.controller.updateValue(EEFCheckboxLifecycleManager.this.checkbox.getSelection());
                if (result != null && result.getSeverity() == 4) {
                    EEFIdePlugin.INSTANCE.log((Object)result);
                    boolean referenceValue = !EEFCheckboxLifecycleManager.this.checkbox.getSelection();
                    EEFCheckboxLifecycleManager.this.checkbox.setSelection(referenceValue);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.checkbox.addSelectionListener(this.selectionListener);
        this.controller.onNewValue((IConsumer)new IConsumer<Boolean>(){

            public void apply(Boolean value) {
                if (!EEFCheckboxLifecycleManager.this.checkbox.isDisposed() && value != null && EEFCheckboxLifecycleManager.this.checkbox.getSelection() != value.booleanValue()) {
                    EEFCheckboxLifecycleManager.this.checkbox.setSelection(value.booleanValue());
                }
            }
        });
    }

    @Override
    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        if (!this.checkbox.isDisposed()) {
            this.checkbox.removeSelectionListener(this.selectionListener);
        }
        this.controller.removeNewValueConsumer();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.checkbox.setEnabled(this.isEnabled());
        EEFStyleHelper styleHelper = new EEFStyleHelper(this.interpreter, this.variableManager);
        EEFWidgetStyle widgetStyle = styleHelper.getWidgetStyle((EEFWidgetDescription)this.description);
        if (widgetStyle instanceof EEFCheckboxStyle) {
            EEFCheckboxStyle style = (EEFCheckboxStyle)widgetStyle;
            EEFCheckboxStyleCallback callback = new EEFCheckboxStyleCallback(this.checkbox);
            styleHelper.applyTextStyle(style.getLabelFontNameExpression(), style.getLabelFontSizeExpression(), style.getLabelFontStyleExpression(), this.checkbox.getFont(), style.getLabelBackgroundColorExpression(), style.getLabelForegroundColorExpression(), callback);
        }
    }
}

