/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.team.subversive;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ui.team.AbstractTeamHandler;
import org.eclipse.emf.compare.util.EclipseModelUtils;
import org.eclipse.emf.compare.util.ModelUtils;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.connector.SVNEntryReference;
import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.SVNNullProgressMonitor;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.compare.ResourceCompareInput;

public class SubversiveTeamHandler
extends AbstractTeamHandler {
    private boolean leftIsRemote;

    public boolean isLeftRemote() {
        return this.leftIsRemote;
    }

    public boolean loadResources(ICompareInput input) throws IOException, CoreException {
        ITypedElement left = input.getLeft();
        ITypedElement right = input.getRight();
        ITypedElement ancestor = input.getAncestor();
        if (left instanceof ResourceCompareInput.ResourceElement && right instanceof ResourceCompareInput.ResourceElement) {
            ResourceSetImpl leftResourceSet = new ResourceSetImpl();
            ResourceSetImpl rightResourceSet = new ResourceSetImpl();
            if (((ResourceCompareInput.ResourceElement)left).getRepositoryResource().getSelectedRevision() == SVNRevision.WORKING) {
                this.leftResource = EclipseModelUtils.load((IPath)((ResourceCompareInput.ResourceElement)left).getLocalResource().getResource().getFullPath(), (ResourceSet)leftResourceSet).eResource();
            } else {
                this.leftResource = ModelUtils.load((InputStream)((ResourceCompareInput.ResourceElement)left).getContents(), (String)((ResourceCompareInput.ResourceElement)left).getName(), (ResourceSet)leftResourceSet).eResource();
                this.leftIsRemote = true;
            }
            try {
                this.rightResource = ModelUtils.load((InputStream)((ResourceCompareInput.ResourceElement)right).getContents(), (String)right.getName(), (ResourceSet)rightResourceSet).eResource();
                IRepositoryResource resource = ((ResourceCompareInput.ResourceElement)right).getRepositoryResource();
                ILocalResource local = ((ResourceCompareInput.ResourceElement)ancestor).getLocalResource();
                rightResourceSet.setURIConverter((URIConverter)new RevisionedURIConverter(resource, local));
            }
            catch (IOException iOException) {
                this.rightResource = ModelUtils.createResource((URI)URI.createURI((String)right.getName()));
                this.leftIsRemote = true;
            }
            if (ancestor != null) {
                ResourceSetImpl ancestorResourceSet = new ResourceSetImpl();
                try {
                    this.ancestorResource = ModelUtils.load((InputStream)((IStreamContentAccessor)ancestor).getContents(), (String)ancestor.getName(), (ResourceSet)ancestorResourceSet).eResource();
                    IRepositoryResource resource = ((ResourceCompareInput.ResourceElement)ancestor).getRepositoryResource();
                    ILocalResource local = ((ResourceCompareInput.ResourceElement)ancestor).getLocalResource();
                    ancestorResourceSet.setURIConverter((URIConverter)new RevisionedURIConverter(resource, local));
                }
                catch (IOException iOException) {
                    this.ancestorResource = ModelUtils.createResource((URI)URI.createURI((String)ancestor.getName()));
                }
            }
            return true;
        }
        return false;
    }

    private class RevisionedURIConverter
    extends URIConverterImpl {
        private final IRepositoryResource baseRevision;
        private final ILocalResource localResource;

        public RevisionedURIConverter(IRepositoryResource revision, ILocalResource local) {
            this.baseRevision = revision;
            this.localResource = local;
        }

        public InputStream createInputStream(URI uri) {
            try {
                URI deresolvedURI = uri;
                if (uri.isRelative()) {
                    deresolvedURI = uri.resolve(URI.createURI((String)this.baseRevision.getUrl()));
                }
                IRepositoryLocation location = this.baseRevision.getRepositoryLocation();
                ISVNConnector proxy = location.acquireSVNProxy();
                IRepositoryFile target = location.asRepositoryFile(deresolvedURI.toString(), false);
                String[] revProps = ISVNConnector.DEFAULT_LOG_ENTRY_PROPS;
                SVNNullProgressMonitor monitor = new SVNNullProgressMonitor();
                SVNLogEntry[] entries = SVNUtility.logEntries((ISVNConnector)proxy, (SVNEntryReference)SVNUtility.asEntryReference((String)deresolvedURI.toString()), (SVNRevision)SVNRevision.HEAD, (SVNRevision)SVNRevision.fromNumber((long)0L), (long)0L, (String[])revProps, (long)0L, (ISVNProgressMonitor)monitor);
                StringOutputStream stream = null;
                if (this.baseRevision.getSelectedRevision() != SVNRevision.BASE) {
                    long baseTimestamp = this.baseRevision.getInfo().lastChangedDate;
                    SVNLogEntry[] sVNLogEntryArray = entries;
                    int n = entries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SVNLogEntry entry = sVNLogEntryArray[n2];
                        if (entry.date <= baseTimestamp) {
                            target.setPegRevision((SVNRevision)SVNRevision.fromNumber((long)entry.revision));
                            target.setSelectedRevision((SVNRevision)SVNRevision.fromNumber((long)entry.revision));
                            stream = new StringOutputStream();
                            proxy.streamFileContent(SVNUtility.getEntryRevisionReference((IRepositoryResource)target), 2048, (OutputStream)stream, (ISVNProgressMonitor)monitor);
                            break;
                        }
                        ++n2;
                    }
                } else {
                    this.localResource.getBaseRevision();
                    stream = new StringOutputStream();
                    proxy.streamFileContent(SVNUtility.getEntryRevisionReference((IRepositoryResource)target), 2048, (OutputStream)stream, (ISVNProgressMonitor)monitor);
                }
                if (stream != null) {
                    return new StringInputStream(stream.getWriter().getBuffer().toString());
                }
            }
            catch (SVNConnectorException sVNConnectorException) {}
            return null;
        }
    }

    private class StringInputStream
    extends InputStream {
        private final Reader reader;

        public StringInputStream(String content) {
            this.reader = new StringReader(content);
        }

        public int read() throws IOException {
            return this.reader.read();
        }
    }

    private class StringOutputStream
    extends OutputStream {
        private final StringWriter writer = new StringWriter();

        public StringWriter getWriter() {
            return this.writer;
        }

        public void write(int b) throws IOException {
            this.writer.write(b);
        }
    }
}

