/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.codegen.engine;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.jet.JETEmitter;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.JMerger;
import org.eclipse.emf.codegen.merge.java.facade.FacadeHelper;
import org.eclipse.emf.codegen.merge.java.facade.jdom.JDOMFacadeHelper;
import org.eclipse.emf.codegen.merge.properties.PropertyMerger;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.search.codegen.Activator;
import org.eclipse.emf.search.codegen.l10n.Messages;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.ui.actions.OrganizeImportsAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IWorkbenchSite;
import org.osgi.framework.Bundle;

public abstract class AbstractModelSearchCodeGenerator {
    public static final String JCONTROL_MODEL_NAME = "templates/JMerge/emf-merge.xml";
    public static final String PDE_NATURE = "org.eclipse.pde.PluginNature";
    public static final String JAVA_BUILDER = "org.eclipse.jdt.core.javabuilder";
    public static final String MANIFEST_BUILDER = "org.eclipse.pde.ManifestBuilder";
    public static final String SCHEMA_BUILDER = "org.eclipse.pde.SchemaBuilder";
    public static final String SOURCE_DIRECTORY = "src";
    protected static final String PROPERTIES_ENCODING = "ISO-8859-1";
    private JControlModel jControlModel = null;

    public abstract Diagnostic generate(Monitor var1) throws CoreException, JETException;

    protected static String[] addDefaultNatures(IProjectDescription projectDescription) {
        String[] natureIds = projectDescription.getNatureIds();
        if (natureIds == null) {
            natureIds = new String[]{"org.eclipse.jdt.core.javanature"};
        } else {
            boolean hasJavaNature = false;
            boolean hasPDENature = false;
            int i = 0;
            while (i < natureIds.length) {
                if ("org.eclipse.jdt.core.javanature".equals(natureIds[i])) {
                    hasJavaNature = true;
                }
                if (PDE_NATURE.equals(natureIds[i])) {
                    hasPDENature = true;
                }
                ++i;
            }
            if (!hasJavaNature) {
                String[] oldNatureIds = natureIds;
                natureIds = new String[oldNatureIds.length + 1];
                System.arraycopy(oldNatureIds, 0, natureIds, 0, oldNatureIds.length);
                natureIds[oldNatureIds.length] = "org.eclipse.jdt.core.javanature";
            }
            if (!hasPDENature) {
                String[] oldNatureIds = natureIds;
                natureIds = new String[oldNatureIds.length + 1];
                System.arraycopy(oldNatureIds, 0, natureIds, 0, oldNatureIds.length);
                natureIds[oldNatureIds.length] = PDE_NATURE;
            }
        }
        return natureIds;
    }

    protected static ICommand[] addDefaultBuilders(IProjectDescription projectDescription) {
        ICommand[] builders = projectDescription.getBuildSpec();
        if (builders == null) {
            builders = new ICommand[]{};
        }
        boolean hasJavaBuilder = false;
        boolean hasManifestBuilder = false;
        boolean hasSchemaBuilder = false;
        int i = 0;
        while (i < builders.length) {
            if (JAVA_BUILDER.equals(builders[i].getBuilderName())) {
                hasJavaBuilder = true;
            }
            if (MANIFEST_BUILDER.equals(builders[i].getBuilderName())) {
                hasManifestBuilder = true;
            }
            if (SCHEMA_BUILDER.equals(builders[i].getBuilderName())) {
                hasSchemaBuilder = true;
            }
            ++i;
        }
        if (!hasJavaBuilder) {
            ICommand[] oldBuilders = builders;
            builders = new ICommand[oldBuilders.length + 1];
            System.arraycopy(oldBuilders, 0, builders, 0, oldBuilders.length);
            builders[oldBuilders.length] = projectDescription.newCommand();
            builders[oldBuilders.length].setBuilderName(JAVA_BUILDER);
        }
        if (!hasManifestBuilder) {
            ICommand[] oldBuilders = builders;
            builders = new ICommand[oldBuilders.length + 1];
            System.arraycopy(oldBuilders, 0, builders, 0, oldBuilders.length);
            builders[oldBuilders.length] = projectDescription.newCommand();
            builders[oldBuilders.length].setBuilderName(MANIFEST_BUILDER);
        }
        if (!hasSchemaBuilder) {
            ICommand[] oldBuilders = builders;
            builders = new ICommand[oldBuilders.length + 1];
            System.arraycopy(oldBuilders, 0, builders, 0, oldBuilders.length);
            builders[oldBuilders.length] = projectDescription.newCommand();
            builders[oldBuilders.length].setBuilderName(SCHEMA_BUILDER);
        }
        return builders;
    }

    protected static IProject createEMFProject(String projectName) {
        Path javaSource = new Path(String.valueOf('/') + projectName + '/' + SOURCE_DIRECTORY);
        IPath projectLocationPath = null;
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        IProject project = null;
        try {
            try {
                UniqueEList classpathEntries = new UniqueEList();
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IProjectDescription projectDescription = null;
                if (!project.exists()) {
                    projectDescription = project.getWorkspace().newProjectDescription(projectName);
                    projectDescription.setLocation(projectLocationPath);
                    project.create(projectDescription, (IProgressMonitor)new NullProgressMonitor());
                } else {
                    projectDescription = project.getDescription();
                    classpathEntries.addAll((Collection)Arrays.asList(javaProject.getRawClasspath()));
                }
                boolean isInitiallyEmpty = classpathEntries.isEmpty();
                String[] natureIds = AbstractModelSearchCodeGenerator.addDefaultNatures(projectDescription);
                projectDescription.setNatureIds(natureIds);
                ICommand[] builders = AbstractModelSearchCodeGenerator.addDefaultBuilders(projectDescription);
                projectDescription.setBuildSpec(builders);
                project.open((IProgressMonitor)new NullProgressMonitor());
                project.setDescription(projectDescription, (IProgressMonitor)new NullProgressMonitor());
                IProject sourceContainer = project;
                if (javaSource.segmentCount() > 1 && !(sourceContainer = project.getFolder(javaSource.removeFirstSegments(1).makeAbsolute())).exists()) {
                    ((IFolder)sourceContainer).create(false, true, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)progressMonitor, 1));
                }
                if (isInitiallyEmpty) {
                    IClasspathEntry sourceClasspathEntry = JavaCore.newSourceEntry((IPath)javaSource);
                    Iterator i = classpathEntries.iterator();
                    while (i.hasNext()) {
                        IClasspathEntry classpathEntry = (IClasspathEntry)i.next();
                        if (!classpathEntry.getPath().isPrefixOf((IPath)javaSource)) continue;
                        i.remove();
                    }
                    classpathEntries.add(0, sourceClasspathEntry);
                    IClasspathEntry jreClasspathEntry = JavaCore.newVariableEntry((IPath)new Path("JRE_LIB"), (IPath)new Path("JRE_SRC"), (IPath)new Path("JRE_SRCROOT"));
                    Iterator i2 = classpathEntries.iterator();
                    while (i2.hasNext()) {
                        IClasspathEntry classpathEntry = (IClasspathEntry)i2.next();
                        if (!classpathEntry.getPath().isPrefixOf(jreClasspathEntry.getPath())) continue;
                        i2.remove();
                    }
                    classpathEntries.add(jreClasspathEntry);
                    classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.pde.core.requiredPlugins")));
                }
                javaProject.setRawClasspath(classpathEntries.toArray(new IClasspathEntry[classpathEntries.size()]), (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)progressMonitor, 1));
            }
            catch (CoreException e) {
                Status s = new Status(4, "org.eclipse.emf.search.codegen", Messages.getString("AbstractEMFCodeGenerator.PluginCreationError"), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)s);
                progressMonitor.done();
            }
        }
        finally {
            progressMonitor.done();
        }
        return project;
    }

    public static void organizeImports(IProject project) {
        final IJavaProject jProject = JavaCore.create((IProject)project);
        Runnable runnable = new Runnable(){

            public void run() {
                OrganizeImportsAction action = new OrganizeImportsAction((IWorkbenchSite)Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite());
                action.run((IStructuredSelection)new StructuredSelection((Object)jProject));
            }
        };
        Display.getDefault().syncExec(runnable);
    }

    private void saveGenerated(String generated, IFile file, IProgressMonitor monitor, boolean isOverwrite) throws CoreException {
        ByteArrayInputStream contents = new ByteArrayInputStream(generated.getBytes());
        if (!file.exists()) {
            File systemFile = file.getLocation().toFile();
            if (systemFile.exists()) {
                file.getParent().refreshLocal(1, monitor);
                file.setContents((InputStream)contents, true, false, monitor);
            } else {
                file.create((InputStream)contents, false, monitor);
            }
        } else if (isOverwrite) {
            file.setContents((InputStream)contents, true, false, monitor);
        }
    }

    private JControlModel getJControlModel() {
        if (this.jControlModel == null) {
            URL jControlUrl = Activator.getDefault().getBundle().getEntry(JCONTROL_MODEL_NAME);
            this.jControlModel = new JControlModel();
            this.jControlModel.initialize((FacadeHelper)new JDOMFacadeHelper(), jControlUrl.toString());
        }
        return this.jControlModel;
    }

    private String formatCode(String contents, String filename) throws JETException {
        CodeFormatter codeFormatter = ToolFactory.createCodeFormatter(null);
        Document doc = new Document(contents);
        TextEdit edit = codeFormatter.format(8, doc.get(), 0, doc.get().length(), 0, null);
        try {
            if (edit != null) {
                edit.apply((IDocument)doc);
                contents = doc.get();
            } else {
                Status s = new Status(4, "org.eclipse.emf.search.codegen", String.valueOf(Messages.getString("AbstractEMFCodeGenerator.DocFormattingError1")) + filename + Messages.getString("AbstractEMFCodeGenerator.DocFormattingError2"));
                Activator.getDefault().getLog().log((IStatus)s);
            }
        }
        catch (MalformedTreeException e) {
            throw new JETException((Throwable)e);
        }
        catch (BadLocationException e) {
            throw new JETException((Throwable)e);
        }
        return contents;
    }

    private String mergeJava(String generatedString, IFile targetFile) throws CoreException {
        JMerger jMerger = new JMerger(this.getJControlModel());
        jMerger.setSourceCompilationUnit(jMerger.createCompilationUnitForContents(generatedString));
        String newContents = null;
        if (targetFile.exists()) {
            jMerger.setTargetCompilationUnit(jMerger.createCompilationUnitForInputStream(targetFile.getContents(true)));
        }
        jMerger.merge();
        newContents = jMerger.getTargetCompilationUnitContents();
        return newContents;
    }

    private String mergeProperties(String generatedString, IFile targetFile, IProgressMonitor monitor) throws CoreException {
        String newContents = generatedString;
        if (targetFile.exists()) {
            PropertyMerger propertyMerger = new PropertyMerger();
            propertyMerger.setSourceProperties(generatedString);
            monitor.subTask(Messages.getString("AbstractEMFCodeGenerator.MessagesParsingError1"));
            String oldProperties = propertyMerger.createPropertiesForInputStream(targetFile.getContents());
            propertyMerger.setTargetProperties(oldProperties);
            monitor.subTask(Messages.getString("AbstractEMFCodeGenerator.MessagesParsingError2"));
            propertyMerger.merge();
            String mergedResult = propertyMerger.getTargetProperties();
            if (!mergedResult.equals(oldProperties) && targetFile.isReadOnly() && AbstractModelSearchCodeGenerator.validateEdit(targetFile)) {
                propertyMerger.setTargetProperties(propertyMerger.createPropertiesForInputStream(targetFile.getContents()));
                propertyMerger.merge();
                mergedResult = propertyMerger.getTargetProperties();
            }
        }
        return newContents;
    }

    protected static boolean validateEdit(IFile file) {
        return file.getWorkspace().validateEdit(new IFile[]{file}, null).isOK();
    }

    private void generate(JETEmitter emitter, Object[] arguments, IFile file, boolean isOverwrite, Monitor monitor) throws JETException, CoreException {
        String generated = emitter.generate(monitor, arguments);
        boolean overwriteWithGenerated = isOverwrite;
        if ("java".equals(file.getFileExtension())) {
            generated = this.mergeJava(generated, file);
            generated = this.formatCode(generated, file.getName());
            overwriteWithGenerated = true;
        }
        if ("properties".equals(file.getFileExtension())) {
            generated = this.mergeProperties(generated, file, BasicMonitor.toIProgressMonitor((Monitor)monitor));
            overwriteWithGenerated = true;
        }
        this.saveGenerated(generated, file, BasicMonitor.toIProgressMonitor((Monitor)monitor), overwriteWithGenerated);
    }

    protected void applyTemplate(Object input, String templateURI, IPath outputFile, boolean isOverwrite, Monitor monitor) throws JETException, CoreException {
        JETEmitter emitter = this.createJETEmitter(templateURI);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(outputFile);
        if (file != null && file.isAccessible()) {
            file.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            file.refreshLocal(2, BasicMonitor.toIProgressMonitor((Monitor)monitor));
        }
        Object[] arguments = new Object[]{input};
        this.generate(emitter, arguments, file, isOverwrite, monitor);
        monitor.worked(1);
    }

    protected abstract JETEmitter createJETEmitter(String var1);

    protected String getTemplateURI(Bundle bundle, String relativePath) {
        return bundle.getEntry(relativePath).toString();
    }

    protected void createFolder(IPath projectPath, String folderName) throws CoreException {
        IPath dirPath = projectPath.append(String.valueOf('/') + folderName);
        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(dirPath);
        if (!folder.exists()) {
            folder.create(true, false, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected void createPackage(String packageName, IProject project) throws CoreException {
        IPath pathProject = project.getFullPath();
        Path packagePath = new Path(packageName.replace('.', '/'));
        int i = 1;
        while (i < packagePath.segmentCount() + 1) {
            IPath pathPackage = pathProject.append("/src/" + packagePath.removeLastSegments(packagePath.segmentCount() - i));
            IFolder packagefolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(pathPackage);
            if (!packagefolder.exists()) {
                packagefolder.create(true, false, (IProgressMonitor)new NullProgressMonitor());
            }
            ++i;
        }
    }
}

