/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ecore.ocl.ui.areas;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.search.core.engine.DelegatingPackageRegistry;
import org.eclipse.emf.search.core.engine.TargetMetaElementSelectionEvent;
import org.eclipse.emf.search.core.engine.TargetSelectionEnum;
import org.eclipse.emf.search.ecore.common.utils.EcoreCommonUtils;
import org.eclipse.emf.search.ecore.ocl.ui.Activator;
import org.eclipse.emf.search.ecore.ocl.ui.l10n.Messages;
import org.eclipse.emf.search.ocl.engine.ModelingLevel;
import org.eclipse.emf.search.ocl.engine.OCLModelSearchQueryEnum;
import org.eclipse.emf.search.ocl.engine.TargetMetamodel;
import org.eclipse.emf.search.ocl.services.TargetMetaModelDescriptor;
import org.eclipse.emf.search.ocl.services.TargetMetaModelExtensionManager;
import org.eclipse.emf.search.ocl.ui.widget.OCLExpressionWidget;
import org.eclipse.emf.search.ui.areas.AbstractModelSearchQueryArea;
import org.eclipse.emf.search.ui.pages.AbstractModelSearchPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.ocl.AbstractEnvironmentFactory;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.uml.UMLEnvironmentFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EcoreOCLModelSearchQueryArea
extends AbstractModelSearchQueryArea {
    private static final String OCL_MODEL_SEARCH_AREA_DIALOG_SECTION_ID = "EcoreOCLModelSearchQueryArea";
    private static final String OCL_TARGET_META_MODEL_NS_URI_DIALOG_SETTINGS_ID = "targetMetaModelNsURI";
    private static final String ECORE_CONTEXT_SELECTION_INDEX_DIALOG_SETTINGS_ID = "ecoreCtxSelectionsIndex";
    private static final String ECORE_QUERY_EXPRESSION_LIST_DIALOG_SETTINGS_ID = "ecoreQueryExpressionsList";
    private static final String UML2_CONTEXT_SELECTION_INDEX_DIALOG_SETTINGS_ID = "uml2CtxSelectionsIndex";
    private static final String UML2_QUERY_EXPRESSION_LIST_DIALOG_SETTINGS_ID = "uml2QueryExpressionsList";
    private static String SETTINGS_EXT = ".settings";
    private String[] lastEcoreOCLExpressions;
    private String[] lastUML2OCLExpressions;
    private Composite container;
    private Label contextLabel;
    private final TargetMetaModelExtensionManager targetMetaModelExtensionManager = TargetMetaModelExtensionManager.getInstance();
    private ComboViewer metaElementsClassifiersComboViewer;
    private OCLExpressionWidget oclExpressionWidget;
    private String currentTargetMetaModelID;
    private int lastIndex = 0;

    public EcoreOCLModelSearchQueryArea(Composite parent, AbstractModelSearchPage page, int style) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout());
        this.container.setLayoutData((Object)new GridData(1808));
        this.createContextLabel(this.container);
        this.createComboViewer(this.container);
        this.createOCLExpressionWidget(this.container);
    }

    protected void createContextLabel(Composite parent) {
        GridData gridData = new GridData(32);
        this.contextLabel = new Label(parent, 0);
        this.contextLabel.setText(Messages.getString("EcoreOCLModelSearchQueryArea.ContextLabel"));
        this.contextLabel.setLayoutData((Object)gridData);
    }

    protected void createComboViewer(Composite parent) {
        AdapterFactoryLabelProvider metaElementsClassifiersLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)new ComposedAdapterFactory((Collection)EcoreCommonUtils.getMetaElementComposeableAdapterFactories())){

            public String getText(Object object) {
                if (object instanceof ENamedElement) {
                    return ((ENamedElement)object).getName();
                }
                return super.getText(object);
            }
        };
        this.metaElementsClassifiersComboViewer = new ComboViewer(new Combo(parent, 8));
        this.metaElementsClassifiersComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.metaElementsClassifiersComboViewer.setLabelProvider((IBaseLabelProvider)metaElementsClassifiersLabelProvider);
        this.metaElementsClassifiersComboViewer.setInput((Object)new Object[0]);
        this.metaElementsClassifiersComboViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof ENamedElement && e2 instanceof ENamedElement) {
                    String txt1 = ((ENamedElement)e1).getName();
                    String txt2 = ((ENamedElement)e2).getName();
                    return txt1.compareTo(txt2);
                }
                return super.compare(viewer, e1, e2);
            }
        });
        GridData gridData = new GridData(768);
        this.metaElementsClassifiersComboViewer.getControl().setLayoutData((Object)gridData);
    }

    protected void createOCLExpressionWidget(Composite parent) {
        this.oclExpressionWidget = new OCLExpressionWidget(parent);
        this.oclExpressionWidget.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.oclExpressionWidget.getViewer().getControl().setLayoutData((Object)gridData);
    }

    public Control getControl() {
        return this.container;
    }

    public String getQueryExpression() {
        return this.oclExpressionWidget.getExpression();
    }

    public void loadDialogSettings() {
        String targetMetaModelNsURI;
        IDialogSettings oclQuerySectionDialogSettings;
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        String settingsPath = Activator.getDefault().getStateLocation().append(this.getDataMap().get("SETTINGS_PREFIX") + "_" + ((Object)((Object)this)).getClass().getSimpleName() + SETTINGS_EXT).toOSString();
        File settingsFile = new File(settingsPath);
        if (settingsFile.exists()) {
            try {
                settings.load(settingsPath);
            }
            catch (IOException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.emf.search.ecore.ocl.ui", 0, Messages.getString("EcoreTextModelSearchQueryArea.dialogSettingsLoadErrorMessage"), (Throwable)e));
            }
        }
        if ((oclQuerySectionDialogSettings = settings.getSection(OCL_MODEL_SEARCH_AREA_DIALOG_SECTION_ID)) == null) {
            oclQuerySectionDialogSettings = settings.addNewSection(OCL_MODEL_SEARCH_AREA_DIALOG_SECTION_ID);
        }
        targetMetaModelNsURI = (targetMetaModelNsURI = oclQuerySectionDialogSettings.get(OCL_TARGET_META_MODEL_NS_URI_DIALOG_SETTINGS_ID)) == null ? (this.currentTargetMetaModelID == null ? EcorePackage.eINSTANCE.getNsURI() : this.currentTargetMetaModelID) : targetMetaModelNsURI;
        TargetMetamodel target = this.getTargetMetamodelFromNsURI(targetMetaModelNsURI);
        this.oclExpressionWidget.setTargetMetamodel(target);
        this.metaElementsClassifiersComboViewer.setInput(this.getContextClassifierListFromNsURI(targetMetaModelNsURI));
        this.lastEcoreOCLExpressions = oclQuerySectionDialogSettings.getArray(ECORE_QUERY_EXPRESSION_LIST_DIALOG_SETTINGS_ID);
        this.lastEcoreOCLExpressions = this.lastEcoreOCLExpressions == null ? new String[5000] : this.lastEcoreOCLExpressions;
        this.lastUML2OCLExpressions = oclQuerySectionDialogSettings.getArray(UML2_QUERY_EXPRESSION_LIST_DIALOG_SETTINGS_ID);
        String[] stringArray = this.lastUML2OCLExpressions = this.lastUML2OCLExpressions == null ? new String[5000] : this.lastUML2OCLExpressions;
        if (target.equals((Object)TargetMetamodel.Ecore)) {
            String lastEcoreOCLCtxIndex = oclQuerySectionDialogSettings.get(ECORE_CONTEXT_SELECTION_INDEX_DIALOG_SETTINGS_ID);
            lastEcoreOCLCtxIndex = lastEcoreOCLCtxIndex == null ? "0" : lastEcoreOCLCtxIndex;
            this.lastIndex = Integer.parseInt(lastEcoreOCLCtxIndex);
            int n = this.lastIndex = this.lastIndex >= 0 ? this.lastIndex : 0;
            if (this.lastEcoreOCLExpressions.length >= this.lastIndex) {
                this.oclExpressionWidget.setExpression(this.lastEcoreOCLExpressions[this.lastIndex]);
            }
        } else if (target.equals((Object)TargetMetamodel.UML)) {
            String lastUML2OCLCtxIndex = oclQuerySectionDialogSettings.get(UML2_CONTEXT_SELECTION_INDEX_DIALOG_SETTINGS_ID);
            lastUML2OCLCtxIndex = lastUML2OCLCtxIndex == null ? "0" : lastUML2OCLCtxIndex;
            this.lastIndex = Integer.parseInt(lastUML2OCLCtxIndex);
            int n = this.lastIndex = this.lastIndex >= 0 ? this.lastIndex : 0;
            if (this.lastUML2OCLExpressions.length >= this.lastIndex) {
                this.oclExpressionWidget.setExpression(this.lastUML2OCLExpressions[this.lastIndex]);
            }
        }
        this.metaElementsClassifiersComboViewer.addSelectionChangedListener((ISelectionChangedListener)new MetaElementsClassifiersComboViewerSelectionChangedListener());
        if (this.metaElementsClassifiersComboViewer.getCombo().getItems().length >= this.lastIndex) {
            Object object = this.metaElementsClassifiersComboViewer.getElementAt(this.lastIndex);
            this.metaElementsClassifiersComboViewer.setSelection((ISelection)new StructuredSelection(object));
        } else {
            int itemCount = this.metaElementsClassifiersComboViewer.getCombo().getItemCount();
            if (itemCount > 0) {
                Object[] element = this.metaElementsClassifiersComboViewer.getElementAt(this.lastIndex);
                this.metaElementsClassifiersComboViewer.setSelection((ISelection)new StructuredSelection((Object)(element == null ? new Object[]{} : element)));
            }
        }
    }

    public void storeDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings oclQuerySectionDialogSettings = settings.getSection(OCL_MODEL_SEARCH_AREA_DIALOG_SECTION_ID);
        int comboSelectionIndex = this.metaElementsClassifiersComboViewer.getCombo().getSelectionIndex();
        String oclExpression = this.oclExpressionWidget.getExpression();
        if (this.oclExpressionWidget.getTargetMetamodel().equals((Object)TargetMetamodel.Ecore)) {
            String[] stringArray = this.lastEcoreOCLExpressions = this.lastEcoreOCLExpressions == null ? new String[this.metaElementsClassifiersComboViewer.getCombo().getItemCount()] : this.lastEcoreOCLExpressions;
            if (comboSelectionIndex >= 0 && this.lastEcoreOCLExpressions.length >= comboSelectionIndex) {
                this.lastEcoreOCLExpressions[comboSelectionIndex] = oclExpression;
            }
            oclQuerySectionDialogSettings.put(ECORE_CONTEXT_SELECTION_INDEX_DIALOG_SETTINGS_ID, "" + comboSelectionIndex);
            oclQuerySectionDialogSettings.put(ECORE_QUERY_EXPRESSION_LIST_DIALOG_SETTINGS_ID, this.lastEcoreOCLExpressions);
        } else if (this.oclExpressionWidget.getTargetMetamodel().equals((Object)TargetMetamodel.UML)) {
            String[] stringArray = this.lastUML2OCLExpressions = this.lastUML2OCLExpressions == null ? new String[this.metaElementsClassifiersComboViewer.getCombo().getItemCount()] : this.lastUML2OCLExpressions;
            if (comboSelectionIndex >= 0 && this.lastUML2OCLExpressions.length >= comboSelectionIndex) {
                this.lastUML2OCLExpressions[comboSelectionIndex] = oclExpression;
            }
            oclQuerySectionDialogSettings.put(UML2_CONTEXT_SELECTION_INDEX_DIALOG_SETTINGS_ID, "" + comboSelectionIndex);
            oclQuerySectionDialogSettings.put(UML2_QUERY_EXPRESSION_LIST_DIALOG_SETTINGS_ID, this.lastUML2OCLExpressions);
        }
        this.currentTargetMetaModelID = this.currentTargetMetaModelID == null ? EcorePackage.eINSTANCE.getNsURI() : this.currentTargetMetaModelID;
        oclQuerySectionDialogSettings.put(OCL_TARGET_META_MODEL_NS_URI_DIALOG_SETTINGS_ID, this.currentTargetMetaModelID);
        String settingsPath = Activator.getDefault().getStateLocation().append(this.getDataMap().get("SETTINGS_PREFIX") + "_" + ((Object)((Object)this)).getClass().getSimpleName() + SETTINGS_EXT).toOSString();
        File settingsFile = new File(settingsPath);
        if (!settingsFile.exists() || settingsFile.canWrite()) {
            try {
                settings.save(settingsPath);
            }
            catch (IOException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.search.ecore.ocl.ui", 0, Messages.getString("EcoreTextModelSearchQueryArea.dialogSettingsSaveErrorMessage"), (Throwable)e));
            }
        }
    }

    public void prepare() {
        ISelection selection = this.metaElementsClassifiersComboViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.getDataMap().put(OCLModelSearchQueryEnum.OCL_MODEL_SEARCH_CONTEXT.name(), ((StructuredSelection)selection).getFirstElement());
        }
    }

    public boolean validateStatus() {
        boolean status = true;
        try {
            status = this.oclExpressionWidget.evaluate();
        }
        catch (Throwable throwable) {}
        return status;
    }

    public void handleTargetMetaModel(String targetMetaModelID) {
        this.handleTargetMetaModelFromContributions(targetMetaModelID);
    }

    private TargetMetamodel getTargetMetamodelFromNsURI(String getTargetMetamodelNsURI) {
        TargetMetaModelDescriptor targetMetaModelDescriptor = this.targetMetaModelExtensionManager.find(getTargetMetamodelNsURI);
        if (TargetMetamodel.Ecore.name().equals(targetMetaModelDescriptor.getTarget())) {
            return TargetMetamodel.Ecore;
        }
        if (TargetMetamodel.UML.name().equals(targetMetaModelDescriptor.getTarget())) {
            return TargetMetamodel.UML;
        }
        return TargetMetamodel.Ecore;
    }

    private TargetMetamodel getTargetMetamodel(String targetMetamodelLabel) {
        if (TargetMetamodel.Ecore.name().equals(targetMetamodelLabel)) {
            return TargetMetamodel.Ecore;
        }
        if (TargetMetamodel.UML.name().equals(targetMetamodelLabel)) {
            return TargetMetamodel.UML;
        }
        return TargetMetamodel.Ecore;
    }

    private ModelingLevel getModelingLevel(String modelingLevelLabel) {
        if (ModelingLevel.M1.name().equals(modelingLevelLabel)) {
            return ModelingLevel.M1;
        }
        if (ModelingLevel.M2.name().equals(modelingLevelLabel)) {
            return ModelingLevel.M2;
        }
        return ModelingLevel.M2;
    }

    private void setTargetMetaModelFromDescriptor(TargetMetaModelDescriptor targetMetaModelDescriptor) {
        switch (this.getTargetMetamodel(targetMetaModelDescriptor.getTarget())) {
            default: {
                this.oclExpressionWidget.setTargetMetamodel(TargetMetamodel.Ecore);
                this.oclExpressionWidget.setEnvironmentFactory((AbstractEnvironmentFactory)new EcoreEnvironmentFactory());
                break;
            }
            case UML: {
                this.oclExpressionWidget.setTargetMetamodel(TargetMetamodel.UML);
                this.oclExpressionWidget.setEnvironmentFactory((AbstractEnvironmentFactory)new UMLEnvironmentFactory());
            }
        }
    }

    private void setModelingLevelFromDescriptor(TargetMetaModelDescriptor targetMetaModelDescriptor) {
        switch (this.getModelingLevel(targetMetaModelDescriptor.getLevel())) {
            case M1: {
                this.oclExpressionWidget.setModelingLevel(ModelingLevel.M1);
                break;
            }
            default: {
                this.oclExpressionWidget.setModelingLevel(ModelingLevel.M2);
            }
        }
    }

    public EObject getTargetMetaElement() {
        ISelection sel;
        if (this.metaElementsClassifiersComboViewer != null && (sel = this.metaElementsClassifiersComboViewer.getSelection()) instanceof IStructuredSelection) {
            return (EObject)((IStructuredSelection)sel).getFirstElement();
        }
        return null;
    }

    public Collection<EObject> getTargetMetaElements() {
        return Arrays.asList(this.getTargetMetaElement());
    }

    private void setContextFromDescriptor(TargetMetaModelDescriptor targetMetaModelDescriptor) {
        EPackage delegatedPackage = DelegatingPackageRegistry.INSTANCE.getEPackage(targetMetaModelDescriptor.getNsURI());
        this.metaElementsClassifiersComboViewer.setInput((Object)delegatedPackage.getEClassifiers());
        this.notifyListeners(new TargetMetaElementSelectionEvent((ISelectionProvider)this.metaElementsClassifiersComboViewer, (ISelection)new StructuredSelection(new Object[0]), targetMetaModelDescriptor.getNsURI(), TargetSelectionEnum.BLOCKING));
    }

    private List<EClassifier> getContextClassifierListFromNsURI(String targetMetaModelID) {
        TargetMetaModelDescriptor targetMetaModelDescriptor = this.targetMetaModelExtensionManager.find(targetMetaModelID);
        EPackage delegatedPackage = DelegatingPackageRegistry.INSTANCE.getEPackage(targetMetaModelDescriptor.getNsURI());
        return delegatedPackage.getEClassifiers();
    }

    private void handleTargetMetaModelFromContributions(String targetMetaModelID) {
        TargetMetaModelDescriptor targetMetaModelDescriptor = this.targetMetaModelExtensionManager.find(targetMetaModelID);
        this.setTargetMetaModelFromDescriptor(targetMetaModelDescriptor);
        this.setModelingLevelFromDescriptor(targetMetaModelDescriptor);
        this.setContextFromDescriptor(targetMetaModelDescriptor);
        this.currentTargetMetaModelID = targetMetaModelID;
    }

    private class MetaElementsClassifiersComboViewerSelectionChangedListener
    implements ISelectionChangedListener {
        private MetaElementsClassifiersComboViewerSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSource().equals(EcoreOCLModelSearchQueryArea.this.metaElementsClassifiersComboViewer)) {
                int index = EcoreOCLModelSearchQueryArea.this.metaElementsClassifiersComboViewer.getCombo().getSelectionIndex();
                String lastExpression = "";
                ModelingLevel level = ModelingLevel.M2;
                TargetMetamodel target = EcoreOCLModelSearchQueryArea.this.getTargetMetamodelFromNsURI(EcoreOCLModelSearchQueryArea.this.currentTargetMetaModelID == null ? EcorePackage.eINSTANCE.getNsURI() : EcoreOCLModelSearchQueryArea.this.currentTargetMetaModelID);
                if (target.equals((Object)TargetMetamodel.Ecore)) {
                    lastExpression = EcoreOCLModelSearchQueryArea.this.lastEcoreOCLExpressions[index];
                    EcoreOCLModelSearchQueryArea.this.currentTargetMetaModelID = EcorePackage.eINSTANCE.getNsURI();
                    level = ModelingLevel.M2;
                } else if (target.equals((Object)TargetMetamodel.UML)) {
                    lastExpression = EcoreOCLModelSearchQueryArea.this.lastUML2OCLExpressions[index];
                    EcoreOCLModelSearchQueryArea.this.currentTargetMetaModelID = UMLPackage.eINSTANCE.getNsURI();
                    level = ModelingLevel.M1;
                }
                Object element = ((IStructuredSelection)EcoreOCLModelSearchQueryArea.this.metaElementsClassifiersComboViewer.getSelection()).getFirstElement();
                EcoreOCLModelSearchQueryArea.this.oclExpressionWidget.setExpression(lastExpression);
                EcoreOCLModelSearchQueryArea.this.oclExpressionWidget.setContext((EObject)element);
                EcoreOCLModelSearchQueryArea.this.oclExpressionWidget.setModelingLevel(level);
                EcoreOCLModelSearchQueryArea.this.oclExpressionWidget.getViewer().getControl().setFocus();
                EcoreOCLModelSearchQueryArea.this.notifyListeners(new TargetMetaElementSelectionEvent((ISelectionProvider)EcoreOCLModelSearchQueryArea.this.metaElementsClassifiersComboViewer, EcoreOCLModelSearchQueryArea.this.metaElementsClassifiersComboViewer.getSelection(), EcoreOCLModelSearchQueryArea.this.currentTargetMetaModelID, TargetSelectionEnum.BLOCKING));
            }
        }
    }
}

