/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.editor.edit.parts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.tools.AbstractTool;
import org.eclipse.gmf.gmfgraph.Alignment;
import org.eclipse.gmf.gmfgraph.BasicFont;
import org.eclipse.gmf.gmfgraph.BorderLayoutData;
import org.eclipse.gmf.gmfgraph.ConstantColor;
import org.eclipse.gmf.gmfgraph.FlowLayout;
import org.eclipse.gmf.gmfgraph.Font;
import org.eclipse.gmf.gmfgraph.GridLayout;
import org.eclipse.gmf.gmfgraph.GridLayoutData;
import org.eclipse.gmf.gmfgraph.Layout;
import org.eclipse.gmf.gmfgraph.LayoutData;
import org.eclipse.gmf.gmfgraph.LineKind;
import org.eclipse.gmf.gmfgraph.Point;
import org.eclipse.gmf.gmfgraph.RGBColor;
import org.eclipse.gmf.gmfgraph.RealFigure;
import org.eclipse.gmf.gmfgraph.Shape;
import org.eclipse.gmf.gmfgraph.XYLayoutData;
import org.eclipse.gmf.graphdef.editor.edit.parts.AbstractPointEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ConnectionHandleEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.handles.ConnectionHandle;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFigureEditPart
extends ShapeNodeEditPart {
    public static final String EMPTY_STRING = "";
    private FontData myCachedFontData;

    private static Integer getGridDataAlignment(Alignment alignment) {
        switch (alignment.getValue()) {
            case 0: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 1: {
                return 2;
            }
            case 3: {
                return 4;
            }
        }
        return null;
    }

    private static int getFlowLayoutAllignment(Alignment alignment, boolean isToolbar) {
        switch (alignment.getValue()) {
            case 0: {
                return isToolbar ? 1 : 1;
            }
            case 2: {
                return isToolbar ? 2 : 2;
            }
        }
        return isToolbar ? 0 : 0;
    }

    protected static int getLineStyle(LineKind lineKind) {
        switch (lineKind.getValue()) {
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
        }
        return 1;
    }

    protected static Color getColor(org.eclipse.gmf.gmfgraph.Color modelColor) {
        if (modelColor instanceof ConstantColor) {
            ConstantColor constantColor = (ConstantColor)modelColor;
            switch (constantColor.getValue()) {
                case BLACK_LITERAL: {
                    return ColorConstants.black;
                }
                case BLUE_LITERAL: {
                    return ColorConstants.blue;
                }
                case CYAN_LITERAL: {
                    return ColorConstants.cyan;
                }
                case DARK_BLUE_LITERAL: {
                    return ColorConstants.darkBlue;
                }
                case DARK_GRAY_LITERAL: {
                    return ColorConstants.darkGray;
                }
                case DARK_GREEN_LITERAL: {
                    return ColorConstants.darkGreen;
                }
                case GRAY_LITERAL: {
                    return ColorConstants.gray;
                }
                case GREEN_LITERAL: {
                    return ColorConstants.green;
                }
                case LIGHT_BLUE_LITERAL: {
                    return ColorConstants.lightBlue;
                }
                case LIGHT_GRAY_LITERAL: {
                    return ColorConstants.lightGray;
                }
                case LIGHT_GREEN_LITERAL: {
                    return ColorConstants.lightGreen;
                }
                case ORANGE_LITERAL: {
                    return ColorConstants.orange;
                }
                case RED_LITERAL: {
                    return ColorConstants.red;
                }
                case WHITE_LITERAL: {
                    return ColorConstants.white;
                }
                case YELLOW_LITERAL: {
                    return ColorConstants.yellow;
                }
            }
        } else if (modelColor instanceof RGBColor) {
            RGBColor rgbColor = (RGBColor)modelColor;
            return DiagramColorRegistry.getInstance().getColor(new RGB(rgbColor.getRed(), rgbColor.getGreen(), rgbColor.getBlue()));
        }
        return null;
    }

    public AbstractFigureEditPart(View view) {
        super(view);
    }

    private Object getLayoutConstraint() {
        Shape shape = this.getShape();
        if (shape == null || shape.getLayoutData() == null) {
            return null;
        }
        LayoutData layoutData = shape.getLayoutData();
        switch (layoutData.eClass().getClassifierID()) {
            case 58: {
                BorderLayoutData borderLayoutData = (BorderLayoutData)layoutData;
                if (borderLayoutData.getAlignment() == null) break;
                switch (borderLayoutData.getAlignment().getValue()) {
                    case 1: 
                    case 3: {
                        return BorderLayout.CENTER;
                    }
                    case 0: {
                        return borderLayoutData.isVertical() ? BorderLayout.TOP : BorderLayout.LEFT;
                    }
                    case 2: {
                        return borderLayoutData.isVertical() ? BorderLayout.BOTTOM : BorderLayout.RIGHT;
                    }
                }
                break;
            }
            case 56: {
                break;
            }
            case 57: {
                GridLayoutData gridLayoutData = (GridLayoutData)layoutData;
                GridData result = new GridData();
                result.grabExcessHorizontalSpace = gridLayoutData.isGrabExcessHorizontalSpace();
                result.grabExcessVerticalSpace = gridLayoutData.isGrabExcessVerticalSpace();
                Integer alignment = AbstractFigureEditPart.getGridDataAlignment(gridLayoutData.getHorizontalAlignment());
                if (alignment != null) {
                    result.horizontalAlignment = alignment;
                }
                if ((alignment = AbstractFigureEditPart.getGridDataAlignment(gridLayoutData.getVerticalAlignment())) != null) {
                    result.verticalAlignment = alignment;
                }
                result.verticalSpan = gridLayoutData.getVerticalSpan();
                result.horizontalSpan = gridLayoutData.getHorizontalSpan();
                result.horizontalIndent = this.getMapMode().DPtoLP(gridLayoutData.getHorizontalIndent());
                if (gridLayoutData.getSizeHint() != null) {
                    result.widthHint = this.getMapMode().DPtoLP(gridLayoutData.getSizeHint().getDx());
                    result.heightHint = this.getMapMode().DPtoLP(gridLayoutData.getSizeHint().getDy());
                } else {
                    result.widthHint = -1;
                    result.heightHint = -1;
                }
                return result;
            }
            case 67: {
                XYLayoutData xyLayoutData = (XYLayoutData)layoutData;
                Rectangle result = new Rectangle();
                if (xyLayoutData.getTopLeft() != null && xyLayoutData.getSize() != null) {
                    result.setLocation(this.getMapMode().DPtoLP(xyLayoutData.getTopLeft().getX()), this.getMapMode().DPtoLP(xyLayoutData.getTopLeft().getY()));
                    result.setSize(this.getMapMode().DPtoLP(xyLayoutData.getSize().getDx()), this.getMapMode().DPtoLP(xyLayoutData.getSize().getDy()));
                }
                return result;
            }
        }
        return null;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        Object layoutConstraint = null;
        if (childEditPart instanceof AbstractFigureEditPart) {
            layoutConstraint = ((AbstractFigureEditPart)childEditPart).getLayoutConstraint();
        } else if (childEditPart instanceof AbstractPointEditPart) {
            layoutConstraint = ((AbstractPointEditPart)childEditPart).getLayoutConstraint();
        }
        LayoutManager layoutManager = this.getContentPane().getLayoutManager();
        if (layoutManager instanceof BorderLayout) {
            if (BorderLayout.BOTTOM != layoutConstraint && BorderLayout.CENTER != layoutConstraint && BorderLayout.LEFT != layoutConstraint && BorderLayout.RIGHT != layoutConstraint && BorderLayout.TOP != layoutConstraint) {
                layoutConstraint = null;
            }
        } else if (layoutManager instanceof GridLayout) {
            if (!(layoutConstraint instanceof GridData)) {
                layoutConstraint = null;
            }
        } else if (layoutManager instanceof XYLayout && !(layoutConstraint instanceof Rectangle)) {
            layoutConstraint = null;
        }
        this.getContentPane().add(child, layoutConstraint, index);
    }

    protected LayoutManager getLayoutManager(Layout layout) {
        if (layout instanceof org.eclipse.gmf.gmfgraph.BorderLayout) {
            org.eclipse.gmf.gmfgraph.BorderLayout borderLayout = (org.eclipse.gmf.gmfgraph.BorderLayout)layout;
            BorderLayout layoutManager = new BorderLayout();
            if (borderLayout.getSpacing() != null) {
                layoutManager.setHorizontalSpacing(this.getMapMode().DPtoLP(borderLayout.getSpacing().getDx()));
                layoutManager.setVerticalSpacing(this.getMapMode().DPtoLP(borderLayout.getSpacing().getDy()));
            }
            return layoutManager;
        }
        if (layout instanceof FlowLayout) {
            FlowLayout flowLayout = (FlowLayout)layout;
            if (flowLayout.isForceSingleLine()) {
                ToolbarLayout layoutManager = new ToolbarLayout();
                layoutManager.setStretchMinorAxis(flowLayout.isMatchMinorSize());
                layoutManager.setMinorAlignment(AbstractFigureEditPart.getFlowLayoutAllignment(flowLayout.getMinorAlignment(), flowLayout.isForceSingleLine()));
                layoutManager.setSpacing(flowLayout.getMajorSpacing());
                layoutManager.setVertical(flowLayout.isVertical());
                return layoutManager;
            }
            org.eclipse.draw2d.FlowLayout layoutManager = new org.eclipse.draw2d.FlowLayout();
            layoutManager.setStretchMinorAxis(flowLayout.isMatchMinorSize());
            layoutManager.setMinorAlignment(AbstractFigureEditPart.getFlowLayoutAllignment(flowLayout.getMinorAlignment(), flowLayout.isForceSingleLine()));
            layoutManager.setMajorAlignment(AbstractFigureEditPart.getFlowLayoutAllignment(flowLayout.getMajorAlignment(), flowLayout.isForceSingleLine()));
            layoutManager.setMajorSpacing(flowLayout.getMajorSpacing());
            layoutManager.setMinorSpacing(flowLayout.getMinorSpacing());
            layoutManager.setHorizontal(!flowLayout.isVertical());
            return layoutManager;
        }
        if (layout instanceof GridLayout) {
            GridLayout gridLayout = (GridLayout)layout;
            org.eclipse.draw2d.GridLayout layoutManager = new org.eclipse.draw2d.GridLayout();
            layoutManager.numColumns = gridLayout.getNumColumns();
            layoutManager.makeColumnsEqualWidth = gridLayout.isEqualWidth();
            if (gridLayout.getMargins() != null) {
                layoutManager.marginWidth = this.getMapMode().DPtoLP(gridLayout.getMargins().getDx());
                layoutManager.marginHeight = this.getMapMode().DPtoLP(gridLayout.getMargins().getDy());
            } else {
                int defaultMargin = 5;
                layoutManager.marginWidth = this.getMapMode().DPtoLP(defaultMargin);
                layoutManager.marginHeight = this.getMapMode().DPtoLP(defaultMargin);
            }
            if (gridLayout.getSpacing() != null) {
                layoutManager.horizontalSpacing = this.getMapMode().DPtoLP(gridLayout.getSpacing().getDx());
                layoutManager.verticalSpacing = this.getMapMode().DPtoLP(gridLayout.getSpacing().getDy());
            } else {
                int defaultSpacing = 5;
                layoutManager.horizontalSpacing = this.getMapMode().DPtoLP(defaultSpacing);
                layoutManager.verticalSpacing = this.getMapMode().DPtoLP(defaultSpacing);
            }
            return layoutManager;
        }
        if (layout instanceof org.eclipse.gmf.gmfgraph.StackLayout) {
            return new StackLayout();
        }
        if (layout instanceof org.eclipse.gmf.gmfgraph.XYLayout) {
            return new XYLayout();
        }
        return null;
    }

    protected Dimension getCornerDimensions(int width, int height) {
        return new Dimension(this.getMapMode().DPtoLP(width), this.getMapMode().DPtoLP(height));
    }

    protected PointList getPointList(List<Point> template) {
        PointList result = new PointList();
        for (Point point : template) {
            result.addPoint(new org.eclipse.draw2d.geometry.Point(this.getMapMode().DPtoLP(point.getX()), this.getMapMode().DPtoLP(point.getY())));
        }
        return result;
    }

    protected Dimension getDraw2dDimension(org.eclipse.gmf.gmfgraph.Dimension dimension) {
        return new Dimension(this.getMapMode().DPtoLP(dimension.getDx()), this.getMapMode().DPtoLP(dimension.getDy()));
    }

    protected org.eclipse.draw2d.geometry.Point getDraw2DPoint(Point point) {
        return new org.eclipse.draw2d.geometry.Point(this.getMapMode().DPtoLP(point.getX()), this.getMapMode().DPtoLP(point.getY()));
    }

    protected void refreshLayoutData() {
        if (!this.hasParentFigure()) {
            return;
        }
        Object layoutConstraint = this.getLayoutConstraint();
        if (layoutConstraint != null) {
            this.getFigure().getParent().setConstraint(this.getFigure(), layoutConstraint);
        }
        if (this.getParent() instanceof AbstractFigureEditPart) {
            ((AbstractFigureEditPart)this.getParent()).handleMajorSemanticChange();
        }
    }

    private boolean hasParentFigure() {
        return this.getFigure().getParent() != null;
    }

    protected void refreshLayoutManager() {
        if (!this.hasParentFigure()) {
            return;
        }
        this.handleMajorSemanticChange();
    }

    protected Shape getShape() {
        View view = this.getNotationView();
        if (view != null && view.getElement() instanceof Shape) {
            return (Shape)view.getElement();
        }
        return null;
    }

    protected void refreshFont() {
        Font modelFont = this.getShape().getFont();
        if (modelFont instanceof BasicFont) {
            BasicFont basicFont = (BasicFont)modelFont;
            int fontStyle = 0;
            switch (basicFont.getStyle()) {
                case BOLD_LITERAL: {
                    fontStyle = 1;
                    break;
                }
                case ITALIC_LITERAL: {
                    fontStyle = 2;
                }
            }
            if (basicFont.getFaceName() == null) {
                return;
            }
            FontData fontData = new FontData(basicFont.getFaceName(), basicFont.getHeight(), fontStyle);
            if (this.myCachedFontData != null && this.myCachedFontData.equals((Object)fontData)) {
                return;
            }
            org.eclipse.swt.graphics.Font font = this.getResourceManager().createFont(FontDescriptor.createFrom((FontData)fontData));
            this.getNodeFigure().setFont(font);
            this.getNodeFigure().repaint();
            if (this.myCachedFontData != null) {
                this.getResourceManager().destroyFont(FontDescriptor.createFrom((FontData)this.myCachedFontData));
            }
        } else {
            this.getNodeFigure().setFont(null);
            this.getNodeFigure().repaint();
        }
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("ConnectionHandlesPolicy", (EditPolicy)new MyConnectionHandleEditPolicy());
    }

    private static class MyConnectionHandle
    extends ConnectionHandle {
        private final MyHandleTool myTool;

        public MyConnectionHandle(IGraphicalEditPart ownerEditPart, EditPart nextChild, String tooltip) {
            super(ownerEditPart, ConnectionHandle.HandleDirection.INCOMING, tooltip);
            this.myTool = new MyHandleTool(nextChild, tooltip);
        }

        protected DragTracker createDragTracker() {
            return this.myTool;
        }
    }

    private static class MyConnectionHandleEditPolicy
    extends ConnectionHandleEditPolicy {
        private MyConnectionHandleEditPolicy() {
        }

        protected List getHandleFigures() {
            IGraphicalEditPart selectedPart = (IGraphicalEditPart)this.getHost();
            ArrayList<MyConnectionHandle> result = new ArrayList<MyConnectionHandle>(selectedPart.getChildren().size());
            int i = 0;
            while (i < selectedPart.getChildren().size()) {
                EditPart next = (EditPart)selectedPart.getChildren().get(i);
                String tooltip = AbstractFigureEditPart.EMPTY_STRING;
                if (next instanceof AbstractFigureEditPart) {
                    AbstractFigureEditPart nextAF = (AbstractFigureEditPart)next;
                    View model = (View)nextAF.getModel();
                    RealFigure modelElement = (RealFigure)model.getElement();
                    String name = modelElement.getName();
                    tooltip = String.valueOf(modelElement.eClass().getName()) + ":" + (name != null && name.length() != 0 ? name : String.valueOf(i + 1));
                }
                result.add(new MyConnectionHandle(selectedPart, next, tooltip));
                ++i;
            }
            return result;
        }
    }

    private static class MyHandleTool
    extends AbstractTool
    implements DragTracker {
        private final EditPart myTarget;
        private final String myCommandName;

        public MyHandleTool(EditPart target, String commandName) {
            this.myTarget = target;
            this.myCommandName = commandName;
        }

        protected boolean handleButtonUp(int button) {
            this.myTarget.getViewer().select(this.myTarget);
            return true;
        }

        protected String getCommandName() {
            return this.myCommandName;
        }
    }
}

