/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.logic;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.Circuit;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.LED;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.Terminal;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.runtime.diagram.ui.AbstractTestBase;
import org.eclipse.gmf.tests.runtime.diagram.ui.logic.CanonicalTestFixture;

public class LogicTransientViewsTests
extends AbstractTestBase {
    public static Test suite() {
        TestSuite s = new TestSuite(LogicTransientViewsTests.class);
        return s;
    }

    public LogicTransientViewsTests() {
        super("Transient View Test Suite");
    }

    protected void setTestFixture() {
        this.testFixture = new CanonicalTestFixture();
    }

    protected CanonicalTestFixture getCanonicalTestFixture() {
        return (CanonicalTestFixture)this.getTestFixture();
    }

    public void testTransientWiresCreation_AcrossTransientLeds() {
        try {
            LogicTransientViewsTests.println("testTransientWiresCreation_AcrossTransientLeds() starting ...");
            CanonicalTestFixture _testFixture = this.getCanonicalTestFixture();
            IGraphicalEditPart logicCompartment = _testFixture.getCanonicalCompartment(0);
            LED led1 = _testFixture.createLED(ViewUtil.resolveSemanticElement((View)logicCompartment.getNotationView()));
            LED led2 = _testFixture.createLED(ViewUtil.resolveSemanticElement((View)logicCompartment.getNotationView()));
            Terminal term1 = (Terminal)led1.getOutputTerminals().get(0);
            Terminal term2 = (Terminal)led2.getInputTerminals().get(0);
            IElementType typeWire = ElementTypeRegistry.getInstance().getType("logic.wire");
            IElementType typeCircuit = ElementTypeRegistry.getInstance().getType("logic.circuit");
            CreateRelationshipRequest crr = new CreateRelationshipRequest(this.getTestFixture().getEditingDomain(), (EObject)term1, (EObject)term2, typeWire);
            ICommand createWire = typeCircuit.getEditHelper().getEditCommand((IEditCommandRequest)crr);
            _testFixture.execute(createWire);
            this.flushEventQueue();
            List connectorEPs = this.getDiagramEditPart().getConnections();
            LogicTransientViewsTests.assertEquals((String)"Unexpected Wire count.", (int)1, (int)connectorEPs.size());
            final ConnectionEditPart ep = (ConnectionEditPart)connectorEPs.get(0);
            this.assertTransient((View)ep.getSource().getModel());
            this.assertTransient((View)ep.getTarget().getModel());
            this.assertTransient((View)ep.getModel());
            TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)ep).getEditingDomain();
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, ""){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    ((View)ep.getModel()).setVisible(false);
                    return Status.OK_STATUS;
                }
            };
            try {
                OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                LogicTransientViewsTests.assertFalse((boolean)false);
            }
            this.assertPersisted((View)ep.getSource().getModel());
            this.assertPersisted((View)ep.getTarget().getModel());
            this.assertPersisted((View)ep.getModel());
        }
        finally {
            LogicTransientViewsTests.println("testTransientWiresCreation_AcrossTransientLeds() complete.");
        }
    }

    private GraphicalEditPart _editPartForSemanticElement(GraphicalEditPart container, Object element) {
        List children = container.getChildren();
        for (GraphicalEditPart ep : children) {
            if (ep.getNotationView().getElement() == element) {
                return ep;
            }
            if ((ep = this._editPartForSemanticElement(ep, element)) == null) continue;
            return ep;
        }
        return null;
    }

    public void testTransientWiresCreation_AcrossPersistedLeds() {
        try {
            LogicTransientViewsTests.println("testTransientWiresCreation_AcrossPersistedLeds() starting ...");
            CanonicalTestFixture _testFixture = this.getCanonicalTestFixture();
            IGraphicalEditPart logicCompartment = _testFixture.getCanonicalCompartment(0);
            LED led1 = _testFixture.createLED(ViewUtil.resolveSemanticElement((View)logicCompartment.getNotationView()));
            LED led2 = _testFixture.createLED(ViewUtil.resolveSemanticElement((View)logicCompartment.getNotationView()));
            GraphicalEditPart ledEditPart = (GraphicalEditPart)this.getDiagramEditPart().getChildren().get(0);
            Terminal term1 = (Terminal)led1.getOutputTerminals().get(0);
            Terminal term2 = (Terminal)led2.getInputTerminals().get(0);
            this.flushEventQueue();
            final GraphicalEditPart ep1 = this._editPartForSemanticElement(ledEditPart, term1);
            TransactionalEditingDomain editingDomain = ledEditPart.getEditingDomain();
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, ""){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    ((View)((View)ep1.getModel()).eContainer()).persistChildren();
                    return Status.OK_STATUS;
                }
            };
            try {
                this.getDiagramEditPart().getDiagramEditDomain().getActionManager().getOperationHistory().execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                LogicTransientViewsTests.assertFalse((boolean)false);
            }
            this.assertPersisted((View)ep1.getModel());
            IElementType typeWire = ElementTypeRegistry.getInstance().getType("logic.wire");
            IElementType typeCircuit = ElementTypeRegistry.getInstance().getType("logic.circuit");
            CreateRelationshipRequest crr = new CreateRelationshipRequest(editingDomain, (EObject)term1, (EObject)term2, typeWire);
            ICommand createWire = typeCircuit.getEditHelper().getEditCommand((IEditCommandRequest)crr);
            _testFixture.execute(createWire);
            this.flushEventQueue();
            List connectorEPs = this.getDiagramEditPart().getConnections();
            LogicTransientViewsTests.assertEquals((String)"Unexpected Wire count.", (int)1, (int)connectorEPs.size());
            ConnectionEditPart ep = (ConnectionEditPart)connectorEPs.get(0);
            this.assertTransient((View)ep.getModel());
        }
        finally {
            LogicTransientViewsTests.println("testTransientWiresCreation_AcrossPersistedLeds() complete.");
        }
    }

    public void testTransientLEDsCreation() {
        try {
            LogicTransientViewsTests.println("testTransientLEDsCreation() starting ...");
            CanonicalTestFixture _testFixture = this.getCanonicalTestFixture();
            IGraphicalEditPart logicCompartment = _testFixture.getCanonicalCompartment(0);
            ArrayList<LED> properties = new ArrayList<LED>();
            int size = logicCompartment.getChildren().size();
            int count = 5;
            int i = 0;
            while (i < count) {
                properties.add(_testFixture.createLED(ViewUtil.resolveSemanticElement((View)logicCompartment.getNotationView())));
                LogicTransientViewsTests.assertEquals((String)"Unexpected LED count.", (int)(++size), (int)logicCompartment.getChildren().size());
                ++i;
            }
            this.assertTransient(logicCompartment.getChildren());
            Rectangle rect = new Rectangle(logicCompartment.getFigure().getBounds());
            logicCompartment.getFigure().translateToAbsolute((Translatable)rect);
            IElementType typeLED = ElementTypeRegistry.getInstance().getType("logic.led");
            this.getCanonicalTestFixture().createShapeUsingTool(typeLED, rect.getCenter(), logicCompartment);
            this.assertPersisted(logicCompartment.getChildren());
            LED led = _testFixture.createLED(ViewUtil.resolveSemanticElement((View)logicCompartment.getNotationView()));
            List children = logicCompartment.getChildren();
            for (GraphicalEditPart element : children) {
                View view = element.getNotationView();
                if (view == null) continue;
                EObject _led = view.getElement();
                if (_led == led) {
                    this.assertTransient(view);
                    continue;
                }
                this.assertPersisted(view);
            }
        }
        finally {
            LogicTransientViewsTests.println("testTransientLEDsCreation() complete.");
        }
    }

    public void testTransientCircuitsCreation() {
        try {
            LogicTransientViewsTests.println("testTransientCircuitsCreation() starting ...");
            CanonicalTestFixture _testFixture = this.getCanonicalTestFixture();
            IGraphicalEditPart logicCompartment = _testFixture.getCanonicalCompartment(0);
            ArrayList<Circuit> properties = new ArrayList<Circuit>();
            int size = logicCompartment.getChildren().size();
            int count = 5;
            int i = 0;
            while (i < count) {
                properties.add(_testFixture.createCircuit(ViewUtil.resolveSemanticElement((View)logicCompartment.getNotationView())));
                LogicTransientViewsTests.assertEquals((String)"Unexpected Circuit count.", (int)(++size), (int)logicCompartment.getChildren().size());
                ++i;
            }
            this.assertTransient(logicCompartment.getChildren());
            Rectangle rect = new Rectangle(logicCompartment.getFigure().getBounds());
            logicCompartment.getFigure().translateToAbsolute((Translatable)rect);
            IElementType typeCircuit = ElementTypeRegistry.getInstance().getType("logic.circuit");
            this.getCanonicalTestFixture().createShapeUsingTool(typeCircuit, rect.getCenter(), logicCompartment);
            this.assertPersisted(logicCompartment.getChildren());
            Circuit circuit = _testFixture.createCircuit(ViewUtil.resolveSemanticElement((View)logicCompartment.getNotationView()));
            List children = logicCompartment.getChildren();
            for (GraphicalEditPart element : children) {
                View view = element.getNotationView();
                if (view == null) continue;
                EObject _circuit = view.getElement();
                if (_circuit == circuit) {
                    this.assertTransient(view);
                    continue;
                }
                this.assertPersisted(view);
            }
        }
        finally {
            LogicTransientViewsTests.println("testTransientCircuitsCreation() complete.");
        }
    }

    public void XtestPersistViewUndoTransaction() {
        try {
            LogicTransientViewsTests.println("testPersistViewUndoTransaction() starting ...");
            CanonicalTestFixture _testFixture = this.getCanonicalTestFixture();
            IGraphicalEditPart logicCompartment = _testFixture.getCanonicalCompartment(0);
            ArrayList<Circuit> properties = new ArrayList<Circuit>();
            int size = logicCompartment.getChildren().size();
            int count = 4;
            int i = 0;
            while (i < count) {
                properties.add(_testFixture.createCircuit(ViewUtil.resolveSemanticElement((View)logicCompartment.getNotationView())));
                LogicTransientViewsTests.assertEquals((String)"Unexpected Circuit count.", (int)(++size), (int)logicCompartment.getChildren().size());
                ++i;
            }
            List editParts = logicCompartment.getChildren();
            this.assertTransient(editParts);
            List views = this.getViewsFromEditParts(editParts);
            Rectangle rect = new Rectangle(logicCompartment.getFigure().getBounds());
            logicCompartment.getFigure().translateToAbsolute((Translatable)rect);
            IElementType typeCircuit = ElementTypeRegistry.getInstance().getType("logic.circuit");
            this.getCanonicalTestFixture().createShapeUsingTool(typeCircuit, rect.getCenter(), logicCompartment);
            this.assertPersisted(logicCompartment.getChildren());
            if (this.getCommandStack().canUndo()) {
                this.getCommandStack().undo();
                this.flushEventQueue();
                List editParts2 = logicCompartment.getChildren();
                List views2 = this.getViewsFromEditParts(editParts2);
                for (Object element : views) {
                    if (views2.contains(element)) continue;
                    LogicTransientViewsTests.fail((String)"undo operation failed");
                }
            }
        }
        finally {
            LogicTransientViewsTests.println("testPersistViewUndoTransaction() complete.");
        }
    }

    private List getViewsFromEditParts(List editParts) {
        ArrayList<Object> views = new ArrayList<Object>();
        for (GraphicalEditPart gEP : editParts) {
            views.add(gEP.getModel());
        }
        return views;
    }

    private void assertPersisted(View view) {
        EStructuralFeature feature;
        if (view != null && (feature = view.eContainingFeature()) != null) {
            LogicTransientViewsTests.assertFalse((String)"Expected a Persisted View", (boolean)feature.isTransient());
        }
    }

    private void assertTransient(View view) {
        EStructuralFeature feature;
        if (view != null && (feature = view.eContainingFeature()) != null) {
            LogicTransientViewsTests.assertTrue((String)"Expected a Transient View", (boolean)feature.isTransient());
        }
    }

    private void assertPersisted(List children) {
        for (GraphicalEditPart element : children) {
            EStructuralFeature feature;
            View view = element.getNotationView();
            if (view == null || (feature = view.eContainingFeature()) == null) continue;
            LogicTransientViewsTests.assertFalse((String)"Expected a Persisted View", (boolean)feature.isTransient());
        }
    }

    private void assertTransient(List children) {
        for (GraphicalEditPart element : children) {
            EStructuralFeature feature;
            View view = element.getNotationView();
            if (view == null || (feature = view.eContainingFeature()) == null) continue;
            LogicTransientViewsTests.assertTrue((String)"Expected a Transient View", (boolean)feature.isTransient());
        }
    }
}

