/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.logic;

import java.util.LinkedList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.Tool;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gmf.runtime.common.ui.action.IDisposableAction;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.ArrangeAction;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.GroupAction;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.SelectAllAction;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.UngroupAction;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GroupEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.geoshapes.type.GeoshapeType;
import org.eclipse.gmf.runtime.diagram.ui.internal.figures.IExpandableFigure;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.type.DiagramNotationType;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.runtime.diagram.ui.AbstractTestBase;
import org.eclipse.gmf.tests.runtime.diagram.ui.logic.LogicTestFixture;
import org.eclipse.gmf.tests.runtime.diagram.ui.util.ITestActionCallback;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupTests
extends AbstractTestBase {
    protected View neView;
    protected View nwView;
    protected View seView;
    protected View swView;

    public static Test suite() {
        TestSuite s = new TestSuite(GroupTests.class);
        return s;
    }

    public GroupTests() {
        super("Group Tests");
    }

    @Override
    protected void setTestFixture() {
        this.testFixture = new GroupTestFixture();
    }

    protected LogicTestFixture getFixture() {
        return (LogicTestFixture)this.testFixture;
    }

    protected void setupShapes() {
        IElementType CIRCUIT_TYPE = ElementTypeRegistry.getInstance().getType("logic.circuit");
        ShapeEditPart nwCircuitEP = this.getFixture().createShapeUsingTool(CIRCUIT_TYPE, new Point(10, 10), new Dimension(50, 50), this.getContainerEP());
        ShapeEditPart neNoteEP = this.getFixture().createShapeUsingTool((IElementType)DiagramNotationType.NOTE, new Point(100, 10), new Dimension(50, 50), this.getContainerEP());
        ShapeEditPart swGeoshapeEP = this.getFixture().createShapeUsingTool((IElementType)DiagramNotationType.NOTE, new Point(10, 100), new Dimension(50, 50), this.getContainerEP());
        ShapeEditPart seCircuitEP = this.getFixture().createShapeUsingTool(CIRCUIT_TYPE, new Point(100, 100), new Dimension(50, 50), this.getContainerEP());
        this.flushEventQueue();
        this.nwView = (View)nwCircuitEP.getModel();
        this.neView = (View)neNoteEP.getModel();
        this.swView = (View)swGeoshapeEP.getModel();
        this.seView = (View)seCircuitEP.getModel();
        this.getFixture().createConnectorUsingTool((IGraphicalEditPart)swGeoshapeEP, (IGraphicalEditPart)nwCircuitEP, (IElementType)GeoshapeType.LINE);
        this.getFixture().createConnectorUsingTool((IGraphicalEditPart)neNoteEP, (IGraphicalEditPart)seCircuitEP, (IElementType)GeoshapeType.LINE);
        this.getFixture().createConnectorUsingTool((IGraphicalEditPart)neNoteEP, (IGraphicalEditPart)swGeoshapeEP, (IElementType)GeoshapeType.LINE);
        this.getFixture().createConnectorUsingTool((IGraphicalEditPart)swGeoshapeEP, (IGraphicalEditPart)seCircuitEP, (IElementType)GeoshapeType.LINE);
        this.flushEventQueue();
    }

    protected IGraphicalEditPart getContainerEP() {
        return this.getDiagramEditPart();
    }

    protected ShapeEditPart getNWShape() {
        return (ShapeEditPart)this.findEditPart(this.nwView);
    }

    protected ShapeEditPart getNEShape() {
        return (ShapeEditPart)this.findEditPart(this.neView);
    }

    protected ShapeEditPart getSWShape() {
        return (ShapeEditPart)this.findEditPart(this.swView);
    }

    protected ShapeEditPart getSEShape() {
        return (ShapeEditPart)this.findEditPart(this.seView);
    }

    protected void setupShapesAndGroups() {
        this.setupShapes();
        LinkedList<ShapeEditPart> shapes = new LinkedList<ShapeEditPart>();
        shapes.add(this.getNWShape());
        shapes.add(this.getSWShape());
        GroupEditPart groupEP = this.groupShapes(shapes);
        shapes.clear();
        shapes.add((ShapeEditPart)groupEP);
        shapes.add(this.getNEShape());
        this.groupShapes(shapes);
        GroupTests.assertEquals((int)2, (int)this.getContainerEP().getChildren().size());
        GroupTests.assertEquals((int)2, (int)this.getOuterGroupEP().getChildren().size());
        GroupTests.assertEquals((int)2, (int)this.getInnerGroupEP().getChildren().size());
    }

    protected GroupEditPart getInnerGroupEP() {
        return (GroupEditPart)this.getNWShape().getParent();
    }

    protected GroupEditPart getOuterGroupEP() {
        return (GroupEditPart)this.getNEShape().getParent();
    }

    protected GroupEditPart groupShapes(List<ShapeEditPart> editparts) {
        View childView = (View)editparts.get(0).getModel();
        GroupRequest request = new GroupRequest((Object)"groupAction");
        request.setEditParts(editparts);
        Command cmd = editparts.get(0).getParent().getCommand((Request)request);
        GroupTests.assertTrue((boolean)cmd.canExecute());
        this.getCommandStack().execute(cmd);
        this.flushEventQueue();
        EditPart groupEP = this.findEditPart(childView).getParent();
        GroupTests.assertTrue((boolean)(groupEP instanceof GroupEditPart));
        return (GroupEditPart)groupEP;
    }

    protected Tool getSelectionToolFromPalette() {
        PaletteViewer paletteViewer = this.getDiagramEditPart().getViewer().getEditDomain().getPaletteViewer();
        ToolEntry selectionTool = paletteViewer.getPaletteRoot().getDefaultEntry();
        paletteViewer.setActiveTool(selectionTool);
        Tool tool = selectionTool.createTool();
        tool.setEditDomain((EditDomain)this.getDiagramWorkbenchPart().getDiagramEditDomain());
        return tool;
    }

    protected IGraphicalEditPart findEditPart(View view) {
        return (IGraphicalEditPart)this.getDiagramEditPart().getViewer().getEditPartRegistry().get(view);
    }

    protected MouseEvent createMouseEvent(int x, int y) {
        Event e = new Event();
        e.widget = this.getDiagramEditPart().getViewer().getControl();
        e.display = e.widget.getDisplay();
        e.button = 1;
        e.x = x;
        e.y = y;
        return new MouseEvent(e);
    }

    protected MouseEvent createRightMouseEvent(int x, int y) {
        Event e = new Event();
        e.widget = this.getDiagramEditPart().getViewer().getControl();
        e.display = e.widget.getDisplay();
        e.button = 3;
        e.x = x;
        e.y = y;
        return new MouseEvent(e);
    }

    protected Rectangle getAbsoluteBounds(IGraphicalEditPart editpart) {
        IFigure figure = editpart.getFigure();
        Rectangle bounds = figure instanceof IExpandableFigure ? ((IExpandableFigure)figure).getExtendedBounds().getCopy() : figure.getBounds().getCopy();
        editpart.getFigure().translateToAbsolute((Translatable)bounds);
        return bounds;
    }

    protected void assertNotEquals(Object object1, Object object2) {
        GroupTests.assertFalse((boolean)object1.equals(object2));
    }

    public void testGroupCommandAndUndoRedo() throws Exception {
        this.setupShapes();
        LinkedList<ShapeEditPart> shapes = new LinkedList<ShapeEditPart>();
        shapes.add(this.getNWShape());
        shapes.add(this.getSWShape());
        GroupEditPart group1EP = this.groupShapes(shapes);
        GroupTests.assertEquals((int)3, (int)this.getContainerEP().getChildren().size());
        GroupTests.assertEquals((Object)group1EP, (Object)this.getSWShape().getParent());
        GroupTests.assertEquals((Object)group1EP.getParent(), (Object)this.getContainerEP());
        GroupTests.assertEquals((int)2, (int)group1EP.getChildren().size());
        GroupTests.assertEquals((Object)this.getAbsoluteBounds((IGraphicalEditPart)group1EP), (Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape()).union(this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape())));
        GroupTests.assertTrue((boolean)this.getCommandStack().canUndo());
        this.getCommandStack().undo();
        this.flushEventQueue();
        GroupTests.assertEquals((Object)this.getContainerEP(), (Object)this.getNWShape().getParent());
        GroupTests.assertEquals((Object)this.getSWShape().getParent(), (Object)this.getContainerEP());
        GroupTests.assertEquals((int)4, (int)this.getContainerEP().getChildren().size());
        GroupTests.assertTrue((boolean)this.getCommandStack().canRedo());
        this.getCommandStack().redo();
        this.flushEventQueue();
        group1EP = (GroupEditPart)this.getNWShape().getParent();
        GroupTests.assertEquals((Object)group1EP, (Object)this.getSWShape().getParent());
        GroupTests.assertEquals((Object)group1EP.getParent(), (Object)this.getContainerEP());
        GroupTests.assertEquals((int)2, (int)group1EP.getChildren().size());
        GroupTests.assertEquals((int)3, (int)this.getContainerEP().getChildren().size());
        GroupTests.assertEquals((Object)this.getAbsoluteBounds((IGraphicalEditPart)group1EP), (Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape()).union(this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape())));
        shapes.clear();
        shapes.add((ShapeEditPart)group1EP);
        shapes.add(this.getNEShape());
        GroupEditPart group2EP = this.groupShapes(shapes);
        group1EP = (GroupEditPart)this.getNWShape().getParent();
        GroupTests.assertEquals((Object)group1EP, (Object)this.getSWShape().getParent());
        GroupTests.assertEquals((Object)group2EP, (Object)group1EP.getParent());
        GroupTests.assertEquals((Object)group2EP, (Object)this.getNEShape().getParent());
        GroupTests.assertEquals((Object)this.getContainerEP(), (Object)group2EP.getParent());
        GroupTests.assertEquals((int)2, (int)group1EP.getChildren().size());
        GroupTests.assertEquals((int)2, (int)group2EP.getChildren().size());
        GroupTests.assertEquals((int)2, (int)this.getContainerEP().getChildren().size());
        GroupTests.assertEquals((Object)this.getAbsoluteBounds((IGraphicalEditPart)group2EP), (Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getNEShape()).union(this.getAbsoluteBounds((IGraphicalEditPart)group1EP)));
        GroupTests.assertTrue((boolean)this.getCommandStack().canUndo());
        this.getCommandStack().undo();
        this.flushEventQueue();
        group1EP = (GroupEditPart)this.getNWShape().getParent();
        GroupTests.assertEquals((Object)this.getContainerEP(), (Object)group1EP.getParent());
        GroupTests.assertEquals((Object)this.getContainerEP(), (Object)this.getNEShape().getParent());
        GroupTests.assertEquals((int)3, (int)this.getContainerEP().getChildren().size());
        GroupTests.assertTrue((boolean)this.getCommandStack().canRedo());
        this.getCommandStack().redo();
        this.flushEventQueue();
        group1EP = (GroupEditPart)this.getNWShape().getParent();
        group2EP = (GroupEditPart)this.getNEShape().getParent();
        GroupTests.assertEquals((Object)group2EP, (Object)group1EP.getParent());
        GroupTests.assertEquals((Object)this.getContainerEP(), (Object)group2EP.getParent());
        GroupTests.assertEquals((int)2, (int)group1EP.getChildren().size());
        GroupTests.assertEquals((int)2, (int)group2EP.getChildren().size());
        GroupTests.assertEquals((int)2, (int)this.getContainerEP().getChildren().size());
        GroupTests.assertEquals((Object)this.getAbsoluteBounds((IGraphicalEditPart)group2EP), (Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getNEShape()).union(this.getAbsoluteBounds((IGraphicalEditPart)group1EP)));
    }

    public void testUngroupCommandAndUndoRedo() throws Exception {
        this.setupShapesAndGroups();
        Request request = new Request((Object)"ungroupAction");
        Command cmd = this.getOuterGroupEP().getCommand(request);
        GroupTests.assertTrue((boolean)cmd.canExecute());
        this.getCommandStack().execute(cmd);
        GroupTests.assertEquals((int)3, (int)this.getContainerEP().getChildren().size());
        GroupTests.assertEquals((Object)this.getContainerEP(), (Object)this.getInnerGroupEP().getParent());
        GroupTests.assertEquals((Object)this.getContainerEP(), (Object)this.getNEShape().getParent());
        GroupTests.assertTrue((boolean)this.getCommandStack().canUndo());
        this.getCommandStack().undo();
        GroupTests.assertEquals((int)2, (int)this.getContainerEP().getChildren().size());
        GroupTests.assertEquals((Object)this.getOuterGroupEP(), (Object)this.getInnerGroupEP().getParent());
        GroupTests.assertEquals((int)2, (int)this.getOuterGroupEP().getChildren().size());
        GroupTests.assertTrue((boolean)this.getCommandStack().canRedo());
        this.getCommandStack().redo();
        GroupTests.assertEquals((int)3, (int)this.getContainerEP().getChildren().size());
        GroupTests.assertEquals((Object)this.getContainerEP(), (Object)this.getInnerGroupEP().getParent());
        GroupTests.assertEquals((Object)this.getContainerEP(), (Object)this.getNEShape().getParent());
    }

    public void testGroupIsSelectedAfterGroupAction() throws Exception {
        this.setupShapes();
        LinkedList<ShapeEditPart> shapes = new LinkedList<ShapeEditPart>();
        shapes.add(this.getNWShape());
        shapes.add(this.getSWShape());
        GroupAction action = new GroupAction(this.getWorkbenchPage());
        this.getWorkbenchPage().activate((IWorkbenchPart)this.getDiagramWorkbenchPart());
        action.init();
        IDiagramGraphicalViewer viewer = this.getDiagramWorkbenchPart().getDiagramGraphicalViewer();
        viewer.deselectAll();
        viewer.setSelection((ISelection)new StructuredSelection(shapes));
        action.refresh();
        GroupTests.assertTrue((boolean)action.isEnabled());
        action.run();
        action.dispose();
        this.flushEventQueue();
        GroupTests.assertEquals((int)1, (int)((StructuredSelection)viewer.getSelection()).size());
        GroupTests.assertTrue((boolean)(((StructuredSelection)viewer.getSelection()).getFirstElement() instanceof GroupEditPart));
    }

    public void testGroupActionEnablement() throws Exception {
        this.setupShapes();
        GroupAction action = new GroupAction(this.getWorkbenchPage());
        this.getWorkbenchPage().activate((IWorkbenchPart)this.getDiagramWorkbenchPart());
        action.init();
        IDiagramGraphicalViewer viewer = this.getDiagramWorkbenchPart().getDiagramGraphicalViewer();
        viewer.deselectAll();
        viewer.setSelection((ISelection)new StructuredSelection(this.getDiagramEditPart().getPrimaryEditParts()));
        action.refresh();
        GroupTests.assertTrue((boolean)action.isEnabled());
        viewer.setSelection((ISelection)new StructuredSelection((Object)this.getNWShape()));
        action.refresh();
        GroupTests.assertFalse((boolean)action.isEnabled());
        viewer.setSelection((ISelection)new StructuredSelection(this.getDiagramEditPart().getPrimaryEditParts()));
        action.refresh();
        GroupTests.assertTrue((boolean)action.isEnabled());
        viewer.setSelection((ISelection)new StructuredSelection(this.getDiagramEditPart().getConnections()));
        action.refresh();
        GroupTests.assertFalse((boolean)action.isEnabled());
        LinkedList<ShapeEditPart> shapes = new LinkedList<ShapeEditPart>();
        shapes.add(this.getNWShape());
        shapes.add(this.getSWShape());
        GroupEditPart groupEP = this.groupShapes(shapes);
        shapes.clear();
        shapes.add((ShapeEditPart)groupEP);
        shapes.add(this.getNEShape());
        viewer.setSelection((ISelection)new StructuredSelection(shapes));
        action.refresh();
        GroupTests.assertTrue((boolean)action.isEnabled());
        this.getContainerEP().disableEditMode();
        action.refresh();
        GroupTests.assertFalse((boolean)action.isEnabled());
    }

    public void testUngroupActionEnablement() throws Exception {
        this.setupShapes();
        LinkedList<ShapeEditPart> shapes = new LinkedList<ShapeEditPart>();
        shapes.add(this.getNWShape());
        shapes.add(this.getSWShape());
        GroupEditPart group1EP = this.groupShapes(shapes);
        shapes.clear();
        shapes.add(this.getNEShape());
        shapes.add(this.getSEShape());
        GroupEditPart group2EP = this.groupShapes(shapes);
        UngroupAction action = new UngroupAction(this.getWorkbenchPage());
        this.getWorkbenchPage().activate((IWorkbenchPart)this.getDiagramWorkbenchPart());
        action.init();
        IDiagramGraphicalViewer viewer = this.getDiagramWorkbenchPart().getDiagramGraphicalViewer();
        viewer.deselectAll();
        viewer.setSelection((ISelection)new StructuredSelection((Object)this.getInnerGroupEP()));
        action.refresh();
        GroupTests.assertTrue((boolean)action.isEnabled());
        LinkedList<GroupEditPart> groups = new LinkedList<GroupEditPart>();
        groups.add(group1EP);
        groups.add(group2EP);
        viewer.setSelection((ISelection)new StructuredSelection(groups));
        action.refresh();
        GroupTests.assertTrue((boolean)action.isEnabled());
    }

    public void testSelectGroupWithClickAndDrag() throws Exception {
        this.setupShapesAndGroups();
        EditPartViewer viewer = this.getDiagramEditPart().getViewer();
        PaletteViewer paletteViewer = viewer.getEditDomain().getPaletteViewer();
        ToolEntry selectionTool = paletteViewer.getPaletteRoot().getDefaultEntry();
        paletteViewer.setActiveTool(selectionTool);
        Tool tool = selectionTool.createTool();
        tool.setEditDomain((EditDomain)this.getDiagramWorkbenchPart().getDiagramEditDomain());
        viewer.getSelectionManager().deselectAll();
        tool.activate();
        tool.mouseDown(this.createMouseEvent(0, 0), viewer);
        tool.mouseDrag(this.createMouseEvent(200, 200), viewer);
        tool.mouseUp(this.createMouseEvent(200, 200), viewer);
        tool.deactivate();
        GroupTests.assertEquals((int)6, (int)viewer.getSelectedEditParts().size());
        GroupTests.assertTrue((boolean)viewer.getSelectedEditParts().contains(this.getOuterGroupEP()));
    }

    public void testSelectGroupWithRightClick() throws Exception {
        this.setupShapesAndGroups();
        Tool tool = this.getSelectionToolFromPalette();
        EditPartViewer viewer = this.getDiagramEditPart().getViewer();
        viewer.getSelectionManager().deselectAll();
        tool.activate();
        Point point = this.getAbsoluteBounds((IGraphicalEditPart)this.getNEShape()).getCenter();
        tool.mouseDown(this.createMouseEvent(point.x, point.y), viewer);
        tool.mouseUp(this.createMouseEvent(point.x, point.y), viewer);
        GroupTests.assertEquals((int)1, (int)viewer.getSelectedEditParts().size());
        GroupTests.assertTrue((boolean)viewer.getSelectedEditParts().contains(this.getOuterGroupEP()));
        tool.mouseDown(this.createRightMouseEvent(point.x, point.y), viewer);
        tool.mouseUp(this.createRightMouseEvent(point.x, point.y), viewer);
        GroupTests.assertEquals((int)1, (int)viewer.getSelectedEditParts().size());
        GroupTests.assertTrue((boolean)viewer.getSelectedEditParts().contains(this.getOuterGroupEP()));
    }

    public void testSelectShapesAndGroupsWithClick() throws Exception {
        this.setupShapesAndGroups();
        Tool tool = this.getSelectionToolFromPalette();
        EditPartViewer viewer = this.getDiagramEditPart().getViewer();
        viewer.getSelectionManager().deselectAll();
        tool.activate();
        Point point = this.getAbsoluteBounds((IGraphicalEditPart)this.getNEShape()).getCenter();
        tool.mouseDown(this.createMouseEvent(point.x, point.y), viewer);
        tool.mouseUp(this.createMouseEvent(point.x, point.y), viewer);
        GroupTests.assertEquals((int)1, (int)viewer.getSelectedEditParts().size());
        GroupTests.assertTrue((boolean)viewer.getSelectedEditParts().contains(this.getOuterGroupEP()));
        tool.mouseDown(this.createMouseEvent(point.x, point.y), viewer);
        tool.mouseUp(this.createMouseEvent(point.x, point.y), viewer);
        GroupTests.assertEquals((int)1, (int)viewer.getSelectedEditParts().size());
        GroupTests.assertTrue((boolean)viewer.getSelectedEditParts().contains(this.getNEShape()));
        tool.mouseDown(this.createRightMouseEvent(point.x, point.y), viewer);
        tool.mouseUp(this.createRightMouseEvent(point.x, point.y), viewer);
        GroupTests.assertEquals((int)1, (int)viewer.getSelectedEditParts().size());
        GroupTests.assertTrue((boolean)viewer.getSelectedEditParts().contains(this.getNEShape()));
        viewer.getSelectionManager().deselectAll();
        point = this.getAbsoluteBounds((IGraphicalEditPart)this.getSEShape()).getCenter();
        tool.mouseDown(this.createMouseEvent(point.x, point.y), viewer);
        tool.mouseUp(this.createMouseEvent(point.x, point.y), viewer);
        GroupTests.assertEquals((int)1, (int)viewer.getSelectedEditParts().size());
        GroupTests.assertTrue((boolean)viewer.getSelectedEditParts().contains(this.getSEShape()));
        viewer.getSelectionManager().deselectAll();
        point = this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape()).getBottom();
        Point point2 = this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape()).getTop();
        point.translate(0, (point2.y - point.y) / 2);
        tool.mouseDown(this.createMouseEvent(point.x, point.y), viewer);
        tool.mouseUp(this.createMouseEvent(point.x, point.y), viewer);
        GroupTests.assertTrue((String)"should be empty unless we happened to click on one of the lines", (viewer.getSelectedEditParts().isEmpty() || viewer.getSelectedEditParts().get(0) instanceof ConnectionEditPart ? 1 : 0) != 0);
        viewer.getSelectionManager().deselectAll();
        point = this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape()).getCenter();
        tool.mouseDown(this.createMouseEvent(point.x, point.y), viewer);
        tool.mouseUp(this.createMouseEvent(point.x, point.y), viewer);
        GroupTests.assertEquals((int)1, (int)viewer.getSelectedEditParts().size());
        GroupTests.assertTrue((boolean)viewer.getSelectedEditParts().contains(this.getOuterGroupEP()));
        tool.mouseDown(this.createMouseEvent(point.x, point.y), viewer);
        tool.mouseUp(this.createMouseEvent(point.x, point.y), viewer);
        GroupTests.assertEquals((int)1, (int)viewer.getSelectedEditParts().size());
        GroupTests.assertTrue((boolean)viewer.getSelectedEditParts().contains(this.getInnerGroupEP()));
        tool.mouseDown(this.createMouseEvent(point.x, point.y), viewer);
        tool.mouseUp(this.createMouseEvent(point.x, point.y), viewer);
        GroupTests.assertEquals((int)1, (int)viewer.getSelectedEditParts().size());
        GroupTests.assertTrue((boolean)viewer.getSelectedEditParts().contains(this.getNWShape()));
        tool.deactivate();
    }

    public void testSelectGroupWithClickOddScenario() throws Exception {
        this.setupShapes();
        LinkedList<ShapeEditPart> shapes = new LinkedList<ShapeEditPart>();
        shapes.add(this.getNWShape());
        shapes.add(this.getSWShape());
        GroupEditPart group1EP = this.groupShapes(shapes);
        shapes.clear();
        shapes.add(this.getNEShape());
        shapes.add(this.getSEShape());
        GroupEditPart group2EP = this.groupShapes(shapes);
        shapes.clear();
        shapes.add((ShapeEditPart)group1EP);
        shapes.add((ShapeEditPart)group2EP);
        GroupEditPart outerGroupEP = this.groupShapes(shapes);
        Tool tool = this.getSelectionToolFromPalette();
        EditPartViewer viewer = this.getDiagramEditPart().getViewer();
        viewer.getSelectionManager().deselectAll();
        tool.activate();
        Point point = this.getAbsoluteBounds((IGraphicalEditPart)this.getNEShape()).getCenter();
        tool.mouseDown(this.createMouseEvent(point.x, point.y), viewer);
        tool.mouseUp(this.createMouseEvent(point.x, point.y), viewer);
        GroupTests.assertEquals((int)1, (int)viewer.getSelectedEditParts().size());
        GroupTests.assertTrue((boolean)viewer.getSelectedEditParts().contains(outerGroupEP));
        tool.deactivate();
    }

    public void testSelectConnectionInGroupWithClick() throws Exception {
        this.setupShapes();
        LinkedList<ShapeEditPart> shapes = new LinkedList<ShapeEditPart>();
        shapes.add(this.getNWShape());
        shapes.add(this.getSWShape());
        GroupEditPart groupEP = this.groupShapes(shapes);
        ConnectionEditPart connectionEP = (ConnectionEditPart)this.getNWShape().getTargetConnections().get(0);
        Tool tool = this.getSelectionToolFromPalette();
        EditPartViewer viewer = this.getDiagramEditPart().getViewer();
        viewer.getSelectionManager().deselectAll();
        tool.activate();
        Point point = this.getAbsoluteBounds((IGraphicalEditPart)connectionEP).getCenter();
        tool.mouseDown(this.createMouseEvent(point.x, point.y), viewer);
        tool.mouseUp(this.createMouseEvent(point.x, point.y), viewer);
        GroupTests.assertEquals((int)1, (int)viewer.getSelectedEditParts().size());
        GroupTests.assertEquals((Object)connectionEP, viewer.getSelectedEditParts().get(0));
        GroupTests.assertTrue((boolean)connectionEP.isActive());
        GroupTests.assertTrue((boolean)connectionEP.getSource().isActive());
        GroupTests.assertEquals((Object)groupEP, (Object)connectionEP.getSource().getParent());
        GroupTests.assertTrue((boolean)connectionEP.getTarget().isActive());
        GroupTests.assertEquals((Object)groupEP, (Object)connectionEP.getTarget().getParent());
        tool.deactivate();
    }

    public void disabledM6testMoveGroup() throws Exception {
        this.setupShapesAndGroups();
        Tool tool = this.getSelectionToolFromPalette();
        Rectangle origGroupBounds = this.getAbsoluteBounds((IGraphicalEditPart)this.getInnerGroupEP());
        Rectangle origNEShapeBounds = this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape());
        Rectangle origSEShapeBounds = this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape());
        Point offset = new Point(25, 25);
        EditPartViewer viewer = this.getDiagramEditPart().getViewer();
        viewer.getSelectionManager().deselectAll();
        tool.activate();
        Point point = origNEShapeBounds.getCenter();
        tool.mouseDown(this.createMouseEvent(point.x, point.y), viewer);
        point.translate(offset);
        tool.mouseDrag(this.createMouseEvent(point.x, point.y), viewer);
        tool.mouseUp(this.createMouseEvent(point.x, point.y), viewer);
        tool.deactivate();
        this.flushEventQueue();
        Dimension resultingOffset = origGroupBounds.getLocation().getDifference(this.getAbsoluteBounds((IGraphicalEditPart)this.getInnerGroupEP()).getLocation());
        GroupTests.assertTrue((resultingOffset.height != 0 && resultingOffset.width != 0 ? 1 : 0) != 0);
        GroupTests.assertEquals((Object)resultingOffset, (Object)origNEShapeBounds.getLocation().getDifference(this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape()).getLocation()));
        GroupTests.assertEquals((Object)resultingOffset, (Object)origSEShapeBounds.getLocation().getDifference(this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape()).getLocation()));
        origGroupBounds = this.getAbsoluteBounds((IGraphicalEditPart)this.getInnerGroupEP());
        origNEShapeBounds = this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape());
        origSEShapeBounds = this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape());
        point = origNEShapeBounds.getCenter();
        offset = new Point(-25, -25);
        viewer.getSelectionManager().deselectAll();
        viewer.select((EditPart)this.getInnerGroupEP());
        tool.activate();
        tool.mouseDown(this.createMouseEvent(point.x, point.y), viewer);
        point.translate(offset);
        tool.mouseDrag(this.createMouseEvent(point.x, point.y), viewer);
        tool.mouseUp(this.createMouseEvent(point.x, point.y), viewer);
        tool.deactivate();
        this.flushEventQueue();
        resultingOffset = origGroupBounds.getLocation().getDifference(this.getAbsoluteBounds((IGraphicalEditPart)this.getInnerGroupEP()).getLocation());
        GroupTests.assertTrue((resultingOffset.height != 0 && resultingOffset.width != 0 ? 1 : 0) != 0);
        resultingOffset = origNEShapeBounds.getLocation().getDifference(this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape()).getLocation());
        GroupTests.assertTrue((resultingOffset.height != 0 && resultingOffset.width != 0 ? 1 : 0) != 0);
        resultingOffset = origSEShapeBounds.getLocation().getDifference(this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape()).getLocation());
        GroupTests.assertTrue((resultingOffset.height != 0 && resultingOffset.width != 0 ? 1 : 0) != 0);
        GroupTests.assertEquals((Object)origGroupBounds.getSize(), (Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getInnerGroupEP()).getSize());
        GroupTests.assertEquals((Object)origNEShapeBounds.getSize(), (Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape()).getSize());
        GroupTests.assertEquals((Object)origSEShapeBounds.getSize(), (Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape()).getSize());
    }

    public void testMoveShapeInGroup2() throws Exception {
        this.setupShapesAndGroups();
        Rectangle origNEShapeBounds = this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape());
        Rectangle origSEShapeBounds = this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape());
        ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"move");
        request.setMoveDelta(new Point(-20, -20));
        request.setEditParts((EditPart)this.getNWShape());
        this.getNWShape().getCommand((Request)request).execute();
        this.flushEventQueue();
        this.assertNotEquals(origNEShapeBounds, this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape()));
        GroupTests.assertEquals((Object)origSEShapeBounds, (Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape()));
        GroupTests.assertEquals((Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape()).union(this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape())), (Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getInnerGroupEP()));
        GroupTests.assertEquals((Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getNEShape()).union(this.getAbsoluteBounds((IGraphicalEditPart)this.getInnerGroupEP())), (Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getOuterGroupEP()));
        request.setMoveDelta(new Point(20, 20));
        this.getNWShape().getCommand((Request)request).execute();
        this.flushEventQueue();
        GroupTests.assertEquals((Object)origNEShapeBounds, (Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape()));
        GroupTests.assertEquals((Object)origSEShapeBounds, (Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape()));
        GroupTests.assertEquals((Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape()).union(this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape())), (Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getInnerGroupEP()));
        GroupTests.assertEquals((Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getNEShape()).union(this.getAbsoluteBounds((IGraphicalEditPart)this.getInnerGroupEP())), (Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getOuterGroupEP()));
        request.setMoveDelta(this.getAbsoluteBounds((IGraphicalEditPart)this.getOuterGroupEP()).getBottomRight().getTranslated(20, 20));
        this.getNWShape().getCommand((Request)request).execute();
        this.flushEventQueue();
        this.assertNotEquals(origNEShapeBounds.getLocation(), this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape()).getLocation());
        GroupTests.assertEquals((Object)origSEShapeBounds.getLocation(), (Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape()).getLocation());
        GroupTests.assertEquals((Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape()).union(this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape())), (Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getInnerGroupEP()));
        GroupTests.assertEquals((Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getNEShape()).union(this.getAbsoluteBounds((IGraphicalEditPart)this.getInnerGroupEP())), (Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getOuterGroupEP()));
    }

    public void testUngroupShapesMaintainsShapeLocations() throws Exception {
        this.setupShapesAndGroups();
        Rectangle origSEShapeBounds = this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape());
        Request request = new Request((Object)"ungroupAction");
        Command cmd = this.getInnerGroupEP().getCommand(request);
        GroupTests.assertTrue((boolean)cmd.canExecute());
        this.getCommandStack().execute(cmd);
        this.flushEventQueue();
        GroupTests.assertEquals((Object)origSEShapeBounds, (Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape()));
        Rectangle origNWShapeBounds = this.getAbsoluteBounds((IGraphicalEditPart)this.getNEShape());
        request = new Request((Object)"ungroupAction");
        cmd = this.getInnerGroupEP().getCommand(request);
        GroupTests.assertTrue((boolean)cmd.canExecute());
        this.getCommandStack().execute(cmd);
        this.flushEventQueue();
        GroupTests.assertEquals((Object)origNWShapeBounds, (Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getNEShape()));
    }

    public void testDeleteShapeInGroup() throws Exception {
        this.setupShapes();
        LinkedList<ShapeEditPart> shapes = new LinkedList<ShapeEditPart>();
        shapes.add(this.getNWShape());
        shapes.add(this.getSWShape());
        shapes.add(this.getSEShape());
        GroupEditPart groupEP = this.groupShapes(shapes);
        shapes.clear();
        shapes.add((ShapeEditPart)groupEP);
        shapes.add(this.getNEShape());
        this.groupShapes(shapes);
        GroupTests.assertEquals((int)1, (int)this.getContainerEP().getChildren().size());
        GroupTests.assertEquals((int)2, (int)this.getOuterGroupEP().getChildren().size());
        GroupTests.assertEquals((int)3, (int)this.getInnerGroupEP().getChildren().size());
        GroupRequest request = new GroupRequest((Object)"delete");
        this.getCommandStack().execute(this.getSWShape().getCommand((Request)request));
        GroupTests.assertEquals((int)2, (int)this.getInnerGroupEP().getChildren().size());
        this.getCommandStack().execute(this.getNWShape().getCommand((Request)request));
        GroupTests.assertEquals((Object)this.getOuterGroupEP(), (Object)this.getSEShape().getParent());
        GroupTests.assertEquals((int)2, (int)this.getOuterGroupEP().getChildren().size());
        this.getCommandStack().undo();
        this.getCommandStack().undo();
        GroupTests.assertEquals((int)1, (int)this.getContainerEP().getChildren().size());
        GroupTests.assertEquals((int)2, (int)this.getOuterGroupEP().getChildren().size());
        GroupTests.assertEquals((int)3, (int)this.getInnerGroupEP().getChildren().size());
    }

    public void testCannotResizeGroup() throws Exception {
        this.setupShapesAndGroups();
        ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"resize");
        request.setResizeDirection(4);
        request.setEditParts((EditPart)this.getOuterGroupEP());
        request.setSizeDelta(new Dimension(0, 100));
        Command cmd = this.getOuterGroupEP().getCommand((Request)request);
        GroupTests.assertTrue((cmd == null || !cmd.canExecute() ? 1 : 0) != 0);
    }

    public void testResizeShapeInGroup() throws Exception {
        this.setupShapesAndGroups();
        Rectangle origNEShapeBounds = this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape());
        Rectangle origSEShapeBounds = this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape());
        ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"resize");
        request.setResizeDirection(12);
        request.setMoveDelta(new Point(-10, 0));
        request.setEditParts((EditPart)this.getNWShape());
        request.setSizeDelta(new Dimension(10, 10));
        this.getNWShape().getCommand((Request)request).execute();
        this.flushEventQueue();
        this.assertNotEquals(origNEShapeBounds.getSize(), this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape()).getSize());
        this.assertNotEquals(origNEShapeBounds.getLocation(), this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape()).getLocation());
        GroupTests.assertEquals((Object)origSEShapeBounds, (Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape()));
        GroupTests.assertEquals((Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape()).union(this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape())), (Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getInnerGroupEP()));
        origNEShapeBounds = this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape());
        origSEShapeBounds = this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape());
        request.setResizeDirection(17);
        request.setMoveDelta(new Point(0, -10));
        this.getNWShape().getCommand((Request)request).execute();
        this.flushEventQueue();
        this.assertNotEquals(origNEShapeBounds.getLocation(), this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape()).getLocation());
        GroupTests.assertEquals((Object)origSEShapeBounds, (Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape()));
        GroupTests.assertEquals((Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape()).union(this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape())), (Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getInnerGroupEP()));
        origNEShapeBounds = this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape());
        origSEShapeBounds = this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape());
        request.setResizeDirection(20);
        request.setMoveDelta(new Point(0, 0));
        request.setEditParts((EditPart)this.getSWShape());
        this.getSWShape().getCommand((Request)request).execute();
        this.flushEventQueue();
        this.assertNotEquals(origSEShapeBounds.getSize(), this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape()).getSize());
        GroupTests.assertEquals((Object)origSEShapeBounds.getLocation(), (Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape()).getLocation());
        GroupTests.assertEquals((Object)origNEShapeBounds, (Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape()));
        GroupTests.assertEquals((Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape()).union(this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape())), (Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getInnerGroupEP()));
        origNEShapeBounds = this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape());
        origSEShapeBounds = this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape());
        request.setResizeDirection(9);
        request.setMoveDelta(new Point(-10, -10));
        this.getSWShape().getCommand((Request)request).execute();
        this.flushEventQueue();
        this.assertNotEquals(origSEShapeBounds.getSize(), this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape()).getSize());
        this.assertNotEquals(origSEShapeBounds.getLocation(), this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape()).getLocation());
        GroupTests.assertEquals((Object)origNEShapeBounds, (Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape()));
        GroupTests.assertEquals((Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape()).union(this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape())), (Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getInnerGroupEP()));
        origNEShapeBounds = this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape());
        origSEShapeBounds = this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape());
        request.setResizeDirection(17);
        request.setMoveDelta(new Point(0, 10));
        request.setEditParts((EditPart)this.getNWShape());
        request.setSizeDelta(new Dimension(-10, -10));
        this.getNWShape().getCommand((Request)request).execute();
        this.flushEventQueue();
        this.assertNotEquals(origNEShapeBounds, this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape()));
        GroupTests.assertEquals((Object)origSEShapeBounds, (Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape()));
        GroupTests.assertEquals((Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape()).union(this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape())), (Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getInnerGroupEP()));
        request.setResizeDirection(12);
        request.setMoveDelta(new Point(10, 0));
        this.getNWShape().getCommand((Request)request).execute();
        this.flushEventQueue();
        GroupTests.assertEquals((Object)origSEShapeBounds, (Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape()));
        GroupTests.assertEquals((Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape()).union(this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape())), (Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getInnerGroupEP()));
        origNEShapeBounds = this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape());
        origSEShapeBounds = this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape());
        request.setResizeDirection(20);
        request.setMoveDelta(new Point(0, 0));
        request.setEditParts((EditPart)this.getSWShape());
        this.getSWShape().getCommand((Request)request).execute();
        this.flushEventQueue();
        this.assertNotEquals(origSEShapeBounds, this.getSWShape().getFigure().getBounds());
        GroupTests.assertEquals((Object)origNEShapeBounds, (Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape()));
        GroupTests.assertEquals((Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape()).union(this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape())), (Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getInnerGroupEP()));
        request.setResizeDirection(9);
        request.setMoveDelta(new Point(10, 10));
        this.getSWShape().getCommand((Request)request).execute();
        GroupTests.assertEquals((Object)origNEShapeBounds, (Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape()));
        GroupTests.assertEquals((Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getNWShape()).union(this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape())), (Object)this.getAbsoluteBounds((IGraphicalEditPart)this.getInnerGroupEP()));
    }

    public void testDeleteGroup() throws Exception {
        this.setupShapesAndGroups();
        GroupRequest request = new GroupRequest((Object)"delete");
        this.getCommandStack().execute(this.getOuterGroupEP().getCommand((Request)request));
        GroupTests.assertEquals((int)1, (int)this.getContainerEP().getChildren().size());
        this.getCommandStack().undo();
        GroupTests.assertEquals((int)2, (int)this.getContainerEP().getChildren().size());
        GroupTests.assertEquals((int)2, (int)this.getOuterGroupEP().getChildren().size());
        GroupTests.assertEquals((int)2, (int)this.getInnerGroupEP().getChildren().size());
    }

    public void testSelectActions() throws Exception {
        this.setupShapesAndGroups();
        this.getContainerEP().getViewer().setSelection((ISelection)new StructuredSelection((Object)this.getContainerEP()));
        SelectAllAction selectAction = SelectAllAction.createSelectAllAction((IWorkbenchPage)this.getWorkbenchPage());
        this.testAction((IDisposableAction)selectAction, new ITestActionCallback(){

            public void onRunExecution() {
                List selectedParts = GroupTests.this.getContainerEP().getViewer().getSelectedEditParts();
                GroupTests.assertEquals((int)6, (int)selectedParts.size());
                GroupTests.assertTrue((boolean)selectedParts.contains(GroupTests.this.getOuterGroupEP()));
                GroupTests.assertTrue((boolean)selectedParts.contains(GroupTests.this.getNEShape().getSourceConnections().get(0)));
                GroupTests.assertFalse((boolean)selectedParts.contains(GroupTests.this.getNWShape()));
            }
        });
        this.getContainerEP().getViewer().deselectAll();
        this.getContainerEP().getViewer().setSelection((ISelection)new StructuredSelection((Object)this.getContainerEP()));
        selectAction = SelectAllAction.createSelectAllShapesAction((IWorkbenchPage)this.getWorkbenchPage());
        this.testAction((IDisposableAction)selectAction, new ITestActionCallback(){

            public void onRunExecution() {
                List selectedParts = GroupTests.this.getContainerEP().getViewer().getSelectedEditParts();
                GroupTests.assertEquals((int)2, (int)selectedParts.size());
                GroupTests.assertTrue((boolean)selectedParts.contains(GroupTests.this.getOuterGroupEP()));
                GroupTests.assertTrue((boolean)selectedParts.contains(GroupTests.this.getSEShape()));
            }
        });
        this.getContainerEP().getViewer().deselectAll();
        this.getContainerEP().getViewer().setSelection((ISelection)new StructuredSelection((Object)this.getContainerEP()));
        selectAction = SelectAllAction.createSelectAllConnectionsAction((IWorkbenchPage)this.getWorkbenchPage());
        this.testAction((IDisposableAction)selectAction, new ITestActionCallback(){

            public void onRunExecution() {
                List selectedParts = GroupTests.this.getContainerEP().getViewer().getSelectedEditParts();
                GroupTests.assertEquals((int)4, (int)selectedParts.size());
                GroupTests.assertTrue((boolean)selectedParts.contains(GroupTests.this.getNEShape().getSourceConnections().get(0)));
            }
        });
    }

    public void disabledM6testArrangeActions() throws Exception {
        this.setupShapesAndGroups();
        this.getContainerEP().getViewer().setSelection((ISelection)new StructuredSelection((Object)this.getContainerEP()));
        final Rectangle origOuterGroupBounds = this.getAbsoluteBounds((IGraphicalEditPart)this.getOuterGroupEP());
        final Rectangle seShapeBounds = this.getAbsoluteBounds((IGraphicalEditPart)this.getSEShape());
        ArrangeAction arrangeAction = ArrangeAction.createArrangeAllAction((IWorkbenchPage)this.getWorkbenchPage());
        this.testAction((IDisposableAction)arrangeAction, new ITestActionCallback(){

            public void onRunExecution() {
                GroupTests.assertEquals((Object)origOuterGroupBounds.getSize(), (Object)GroupTests.this.getAbsoluteBounds((IGraphicalEditPart)GroupTests.this.getOuterGroupEP()).getSize());
                GroupTests.this.assertNotEquals(seShapeBounds.getLocation(), GroupTests.this.getAbsoluteBounds((IGraphicalEditPart)GroupTests.this.getSEShape()).getLocation());
            }
        });
        this.getCommandStack().undo();
        this.getContainerEP().getViewer().deselectAll();
        this.getContainerEP().getViewer().setSelection((ISelection)new StructuredSelection((Object)this.getOuterGroupEP()));
        final Rectangle origInnerGroupBounds = this.getAbsoluteBounds((IGraphicalEditPart)this.getInnerGroupEP());
        final Rectangle swShapeBounds = this.getAbsoluteBounds((IGraphicalEditPart)this.getSWShape());
        arrangeAction = ArrangeAction.createArrangeSelectionAction((IWorkbenchPage)this.getWorkbenchPage());
        this.testAction((IDisposableAction)arrangeAction, new ITestActionCallback(){

            public void onRunExecution() {
                GroupTests.this.assertAlmostEquals(origInnerGroupBounds.getSize(), GroupTests.this.getAbsoluteBounds((IGraphicalEditPart)GroupTests.this.getInnerGroupEP()).getSize());
                GroupTests.this.assertNotEquals(swShapeBounds.getLocation(), GroupTests.this.getAbsoluteBounds((IGraphicalEditPart)GroupTests.this.getSWShape()).getLocation());
            }
        });
    }

    private void assertAlmostEquals(Dimension d1, Dimension d2) {
        GroupTests.assertTrue((Math.abs(d1.height - d2.height) <= 1 && Math.abs(d1.width - d2.width) <= 1 ? 1 : 0) != 0);
    }

    public class GroupTestFixture
    extends LogicTestFixture {
        protected void createShapesAndConnectors() throws Exception {
        }
    }
}

