/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.ui.dashboard;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.ecore.presentation.EcoreModelWizard;
import org.eclipse.emf.importer.ui.EMFModelWizard;
import org.eclipse.emf.importer.ui.GenModelReloadActionDelegate;
import org.eclipse.gmf.codegen.gmfgen.presentation.GMFGenModelWizard;
import org.eclipse.gmf.gmfgraph.presentation.GMFGraphModelWizard;
import org.eclipse.gmf.internal.bridge.ui.FileSelector;
import org.eclipse.gmf.internal.bridge.ui.dashboard.DashboardAction;
import org.eclipse.gmf.internal.bridge.ui.dashboard.DashboardFigure;
import org.eclipse.gmf.internal.bridge.ui.dashboard.DashboardState;
import org.eclipse.gmf.internal.bridge.ui.dashboard.HyperlinkFigure;
import org.eclipse.gmf.internal.bridge.ui.dashboard.Messages;
import org.eclipse.gmf.internal.bridge.ui.dashboard.ModelFigure;
import org.eclipse.gmf.internal.bridge.wizards.GMFGraphSimpleModelWizard;
import org.eclipse.gmf.internal.bridge.wizards.GMFToolSimpleModelWizard;
import org.eclipse.gmf.internal.bridge.wizards.NewGMFMapModelWizard;
import org.eclipse.gmf.internal.codegen.popup.actions.ExecuteTemplatesAction;
import org.eclipse.gmf.internal.codegen.popup.actions.TransformToGenModel;
import org.eclipse.gmf.mappings.presentation.GMFMapModelWizard;
import org.eclipse.gmf.tooldef.presentation.GMFToolModelWizard;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class DashboardMediator {
    private static final boolean STRICT = true;
    private DashboardFigure view;
    private Shell shell;
    private IProject project;
    private DashboardState state = new DashboardState();

    public DashboardMediator(Shell shell) {
        this.shell = shell;
    }

    public void setView(DashboardFigure view) {
        this.view = view;
        view.getDGMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_0, new SelectDGMAction()));
        view.getDGMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_1, new EditDGMAction()));
        view.getDGMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_2, new ReloadDGMAction()));
        view.getGDMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_0, new SelectGDMAction()));
        view.getGDMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_1, new EditGDMAction()));
        view.getGDMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_3, new CreateGDMAction()));
        view.getDMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_0, new SelectDMAction()));
        view.getDMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_1, new EditDMAction()));
        view.getDMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_3, new CreateDMAction()));
        view.getTDMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_0, new SelectTDMAction()));
        view.getTDMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_1, new EditTDMAction()));
        view.getTDMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_3, new CreateTDMAction()));
        view.getMMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_0, new SelectMMAction()));
        view.getMMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_1, new EditMMAction()));
        view.getMMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_3, new CreateMMAction()));
        view.getGMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_0, new SelectGMAction()));
        view.getGMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_1, new EditGMAction()));
        view.getGMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_3, new CreateGMAction()));
        view.getGMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_5, new GenerateDEAction()));
        view.getDM2DGMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_4, new DeriveDGMAction()));
        view.getDM2GDMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_4, new DeriveGDMAction()));
        view.getDM2TDMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_4, new DeriveTDMAction()));
        view.getDM2MMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_6, new CombineMMAction()));
        view.getMM2GMFigure().addAction(this.createLinkFigure(Messages.DashboardMediator_7, new GenerateGMAction()));
        this.updateStatus();
    }

    public IFigure createLinkFigure(String text, DashboardAction action) {
        HyperlinkFigure linkFigure = new HyperlinkFigure(action);
        linkFigure.setText(text);
        return linkFigure;
    }

    protected IFile getFile(String fileName) {
        return this.project.getFile((IPath)new Path(fileName));
    }

    protected String getName(IFile file) {
        if (file == null) {
            return null;
        }
        return file.getProjectRelativePath().toString();
    }

    public IProject getProject() {
        return this.project;
    }

    public DashboardState getState() {
        return this.state;
    }

    public void setProjectAndState(IProject project, DashboardState state) {
        this.project = project;
        this.state = state;
        if (this.state == null) {
            this.state = new DashboardState();
        }
        this.updateStatus();
    }

    protected void updateStatus() {
        if (this.project == null) {
            this.view.getStatusLine(0).setText(Messages.DashboardMediator_8);
            this.view.getStatusLine(1).setText("");
        } else {
            this.view.getStatusLine(0).setText(MessageFormat.format(Messages.DashboardMediator_15, this.project.getName()));
            double done = (double)this.state.getSpecifiedModelsCount() / (double)this.state.getModelsCount();
            this.view.getStatusLine(1).setText(MessageFormat.format(Messages.DashboardMediator_16, new Double(done)));
        }
        this.setModelName(this.view.getDGMFigure(), this.state.dgmFileName);
        this.setModelName(this.view.getGDMFigure(), this.state.gdmFileName);
        this.setModelName(this.view.getDMFigure(), this.state.dmFileName);
        this.setModelName(this.view.getTDMFigure(), this.state.tdmFileName);
        this.setModelName(this.view.getMMFigure(), this.state.mmFileName);
        this.setModelName(this.view.getGMFigure(), this.state.gmFileName);
        this.view.repaint();
    }

    protected void setModelName(ModelFigure figure, String name) {
        figure.setName(name);
    }

    protected abstract class SelectFileAction
    implements DashboardAction {
        protected SelectFileAction() {
        }

        public boolean isEnabled() {
            return DashboardMediator.this.project != null;
        }

        public void run() {
            IFile file = null;
            String fileName = this.getFileName();
            if (fileName != null) {
                file = DashboardMediator.this.getFile(fileName);
            }
            file = FileSelector.selectFile((Shell)DashboardMediator.this.shell, (String)this.getFigure().getDescription(), (IContainer)DashboardMediator.this.project, (IFile)file, (String)this.getFileExtension());
            this.setFileName(DashboardMediator.this.getName(file));
            DashboardMediator.this.updateStatus();
        }

        protected abstract ModelFigure getFigure();

        protected abstract String getFileName();

        protected abstract void setFileName(String var1);

        protected abstract String getFileExtension();
    }

    protected abstract class EditFileAction
    implements DashboardAction {
        protected EditFileAction() {
        }

        public boolean isEnabled() {
            return DashboardMediator.this.project != null && this.getFileName() != null;
        }

        public void run() {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            IFile modelFile = DashboardMediator.this.getFile(this.getFileName());
            try {
                String fileName = modelFile.getFullPath().toString();
                String editorId = workbench.getEditorRegistry().getDefaultEditor(fileName).getId();
                page.openEditor((IEditorInput)new FileEditorInput(modelFile), editorId);
            }
            catch (PartInitException pie) {
                String msg = MessageFormat.format(Messages.DashboardMediator_17, this.getFileName());
                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)msg, (String)pie.getMessage());
            }
        }

        protected abstract String getFileName();
    }

    protected abstract class RunWizardAction
    implements DashboardAction {
        private static final int SIZING_WIZARD_WIDTH = 500;
        private static final int SIZING_WIZARD_HEIGHT = 500;

        protected RunWizardAction() {
        }

        public boolean isEnabled() {
            return DashboardMediator.this.project != null;
        }

        public void run() {
            IWizard wizard = this.createWizard();
            if (wizard instanceof IWorkbenchWizard) {
                ((IWorkbenchWizard)wizard).init(PlatformUI.getWorkbench(), this.getSelection());
            }
            WizardDialog dialog = new WizardDialog(this, DashboardMediator.this.shell, wizard, wizard){
                final /* synthetic */ RunWizardAction this$1;
                private final /* synthetic */ IWizard val$wizard;
                {
                    this.this$1 = runWizardAction;
                    this.val$wizard = iWizard;
                    super($anonymous0, $anonymous1);
                }

                protected void finishPressed() {
                    this.this$1.wizardFinished(this.val$wizard);
                    super.finishPressed();
                }
            };
            dialog.create();
            dialog.getShell().setSize(Math.max(500, dialog.getShell().getSize().x), 500);
            dialog.open();
        }

        protected IStructuredSelection getSelection() {
            ArrayList selection = new ArrayList();
            this.addFile(selection, ((DashboardMediator)DashboardMediator.this).state.dmFileName);
            this.addFile(selection, ((DashboardMediator)DashboardMediator.this).state.dgmFileName);
            this.addFile(selection, ((DashboardMediator)DashboardMediator.this).state.gdmFileName);
            this.addFile(selection, ((DashboardMediator)DashboardMediator.this).state.tdmFileName);
            this.addFile(selection, ((DashboardMediator)DashboardMediator.this).state.mmFileName);
            this.addFile(selection, ((DashboardMediator)DashboardMediator.this).state.gmFileName);
            return new StructuredSelection(selection);
        }

        protected void addFile(List files, String name) {
            if (name == null) {
                return;
            }
            files.add(DashboardMediator.this.project.getFile(name));
        }

        protected abstract IWizard createWizard();

        protected void wizardFinished(IWizard wizard) {
        }
    }

    private class SelectDGMAction
    extends SelectFileAction {
        private SelectDGMAction() {
        }

        protected ModelFigure getFigure() {
            return DashboardMediator.this.view.getDGMFigure();
        }

        protected String getFileName() {
            return ((DashboardMediator)DashboardMediator.this).state.dgmFileName;
        }

        protected void setFileName(String fileName) {
            ((DashboardMediator)DashboardMediator.this).state.dgmFileName = fileName;
        }

        protected String getFileExtension() {
            return "genmodel";
        }
    }

    private class SelectGDMAction
    extends SelectFileAction {
        private SelectGDMAction() {
        }

        protected ModelFigure getFigure() {
            return DashboardMediator.this.view.getGDMFigure();
        }

        protected String getFileName() {
            return ((DashboardMediator)DashboardMediator.this).state.gdmFileName;
        }

        protected void setFileName(String fileName) {
            ((DashboardMediator)DashboardMediator.this).state.gdmFileName = fileName;
        }

        protected String getFileExtension() {
            return "gmfgraph";
        }
    }

    private class SelectDMAction
    extends SelectFileAction {
        private SelectDMAction() {
        }

        protected ModelFigure getFigure() {
            return DashboardMediator.this.view.getDMFigure();
        }

        protected String getFileName() {
            return ((DashboardMediator)DashboardMediator.this).state.dmFileName;
        }

        protected void setFileName(String fileName) {
            ((DashboardMediator)DashboardMediator.this).state.dmFileName = fileName;
        }

        protected String getFileExtension() {
            return "ecore";
        }
    }

    private class SelectTDMAction
    extends SelectFileAction {
        private SelectTDMAction() {
        }

        protected ModelFigure getFigure() {
            return DashboardMediator.this.view.getTDMFigure();
        }

        protected String getFileName() {
            return ((DashboardMediator)DashboardMediator.this).state.tdmFileName;
        }

        protected void setFileName(String fileName) {
            ((DashboardMediator)DashboardMediator.this).state.tdmFileName = fileName;
        }

        protected String getFileExtension() {
            return "gmftool";
        }
    }

    private class SelectMMAction
    extends SelectFileAction {
        private SelectMMAction() {
        }

        protected ModelFigure getFigure() {
            return DashboardMediator.this.view.getMMFigure();
        }

        protected String getFileName() {
            return ((DashboardMediator)DashboardMediator.this).state.mmFileName;
        }

        protected void setFileName(String fileName) {
            ((DashboardMediator)DashboardMediator.this).state.mmFileName = fileName;
        }

        protected String getFileExtension() {
            return "gmfmap";
        }
    }

    private class SelectGMAction
    extends SelectFileAction {
        private SelectGMAction() {
        }

        protected ModelFigure getFigure() {
            return DashboardMediator.this.view.getGMFigure();
        }

        protected String getFileName() {
            return ((DashboardMediator)DashboardMediator.this).state.gmFileName;
        }

        protected void setFileName(String fileName) {
            ((DashboardMediator)DashboardMediator.this).state.gmFileName = fileName;
        }

        protected String getFileExtension() {
            return "gmfgen";
        }
    }

    private class EditDGMAction
    extends EditFileAction {
        private EditDGMAction() {
        }

        protected String getFileName() {
            return ((DashboardMediator)DashboardMediator.this).state.dgmFileName;
        }
    }

    private class EditGDMAction
    extends EditFileAction {
        private EditGDMAction() {
        }

        protected String getFileName() {
            return ((DashboardMediator)DashboardMediator.this).state.gdmFileName;
        }
    }

    private class EditDMAction
    extends EditFileAction {
        private EditDMAction() {
        }

        protected String getFileName() {
            return ((DashboardMediator)DashboardMediator.this).state.dmFileName;
        }
    }

    private class EditTDMAction
    extends EditFileAction {
        private EditTDMAction() {
        }

        protected String getFileName() {
            return ((DashboardMediator)DashboardMediator.this).state.tdmFileName;
        }
    }

    private class EditMMAction
    extends EditFileAction {
        private EditMMAction() {
        }

        protected String getFileName() {
            return ((DashboardMediator)DashboardMediator.this).state.mmFileName;
        }
    }

    private class EditGMAction
    extends EditFileAction {
        private EditGMAction() {
        }

        protected String getFileName() {
            return ((DashboardMediator)DashboardMediator.this).state.gmFileName;
        }
    }

    private class CreateGDMAction
    extends RunWizardAction {
        private CreateGDMAction() {
        }

        protected IWizard createWizard() {
            return new GMFGraphModelWizard();
        }

        protected void wizardFinished(IWizard wizard) {
            IFile file = ((GMFGraphModelWizard)wizard).getModelFile();
            ((DashboardMediator)DashboardMediator.this).state.gdmFileName = DashboardMediator.this.getName(file);
            DashboardMediator.this.updateStatus();
        }
    }

    private class CreateDMAction
    extends RunWizardAction {
        private CreateDMAction() {
        }

        protected IWizard createWizard() {
            return new EcoreModelWizard();
        }

        protected void wizardFinished(IWizard wizard) {
            IFile file = ((EcoreModelWizard)wizard).getModelFile();
            ((DashboardMediator)DashboardMediator.this).state.dmFileName = DashboardMediator.this.getName(file);
            DashboardMediator.this.updateStatus();
        }
    }

    private class CreateTDMAction
    extends RunWizardAction {
        private CreateTDMAction() {
        }

        protected IWizard createWizard() {
            return new GMFToolModelWizard();
        }

        protected void wizardFinished(IWizard wizard) {
            IFile file = ((GMFToolModelWizard)wizard).getModelFile();
            ((DashboardMediator)DashboardMediator.this).state.tdmFileName = DashboardMediator.this.getName(file);
            DashboardMediator.this.updateStatus();
        }
    }

    private class CreateMMAction
    extends RunWizardAction {
        private CreateMMAction() {
        }

        protected IWizard createWizard() {
            return new GMFMapModelWizard();
        }

        protected void wizardFinished(IWizard wizard) {
            IFile file = ((GMFMapModelWizard)wizard).getModelFile();
            ((DashboardMediator)DashboardMediator.this).state.mmFileName = DashboardMediator.this.getName(file);
            DashboardMediator.this.updateStatus();
        }
    }

    private class CreateGMAction
    extends RunWizardAction {
        private CreateGMAction() {
        }

        protected IWizard createWizard() {
            return new GMFGenModelWizard();
        }

        protected void wizardFinished(IWizard wizard) {
            IFile file = ((GMFGenModelWizard)wizard).getModelFile();
            ((DashboardMediator)DashboardMediator.this).state.gmFileName = DashboardMediator.this.getName(file);
            DashboardMediator.this.updateStatus();
        }
    }

    private class ReloadDGMAction
    implements DashboardAction {
        private ReloadDGMAction() {
        }

        public boolean isEnabled() {
            return ((DashboardMediator)DashboardMediator.this).state.dgmFileName != null;
        }

        public void run() {
            IFile file = DashboardMediator.this.getFile(((DashboardMediator)DashboardMediator.this).state.dgmFileName);
            GenModelReloadActionDelegate action = new GenModelReloadActionDelegate();
            Action uiAction = new Action(this){
                final /* synthetic */ ReloadDGMAction this$1;
                {
                    this.this$1 = reloadDGMAction;
                }
            };
            action.selectionChanged((IAction)uiAction, (ISelection)new StructuredSelection((Object)file));
            action.run((IAction)uiAction);
            DashboardMediator.this.updateStatus();
        }
    }

    private class DeriveDGMAction
    extends RunWizardAction {
        private DeriveDGMAction() {
        }

        public boolean isEnabled() {
            return super.isEnabled() && ((DashboardMediator)DashboardMediator.this).state.dmFileName != null;
        }

        protected IWizard createWizard() {
            return new OpenEMFModelWizard();
        }

        protected void wizardFinished(IWizard wizard) {
            IFile file = ((OpenEMFModelWizard)wizard).getModelFile();
            ((DashboardMediator)DashboardMediator.this).state.dgmFileName = DashboardMediator.this.getName(file);
            DashboardMediator.this.updateStatus();
        }

        protected IStructuredSelection getSelection() {
            return new StructuredSelection((Object)DashboardMediator.this.getFile(((DashboardMediator)DashboardMediator.this).state.dmFileName));
        }
    }

    private static class OpenEMFModelWizard
    extends EMFModelWizard {
        private OpenEMFModelWizard() {
        }

        public IFile getModelFile() {
            IPath path = this.genModelContainerPath.append(this.genModelFileName);
            return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        }
    }

    private class DeriveGDMAction
    extends RunWizardAction {
        private DeriveGDMAction() {
        }

        public boolean isEnabled() {
            return super.isEnabled() && ((DashboardMediator)DashboardMediator.this).state.dmFileName != null;
        }

        protected IWizard createWizard() {
            return new GMFGraphSimpleModelWizard();
        }

        protected void wizardFinished(IWizard wizard) {
            IFile file = ((GMFGraphSimpleModelWizard)wizard).getModelFile();
            ((DashboardMediator)DashboardMediator.this).state.gdmFileName = DashboardMediator.this.getName(file);
            DashboardMediator.this.updateStatus();
        }

        protected IStructuredSelection getSelection() {
            return new StructuredSelection((Object)DashboardMediator.this.getFile(((DashboardMediator)DashboardMediator.this).state.dmFileName));
        }
    }

    private class DeriveTDMAction
    extends RunWizardAction {
        private DeriveTDMAction() {
        }

        public boolean isEnabled() {
            return super.isEnabled() && ((DashboardMediator)DashboardMediator.this).state.dmFileName != null;
        }

        protected IWizard createWizard() {
            return new GMFToolSimpleModelWizard();
        }

        protected void wizardFinished(IWizard wizard) {
            IFile file = ((GMFToolSimpleModelWizard)wizard).getModelFile();
            ((DashboardMediator)DashboardMediator.this).state.tdmFileName = DashboardMediator.this.getName(file);
            DashboardMediator.this.updateStatus();
        }

        protected IStructuredSelection getSelection() {
            return new StructuredSelection((Object)DashboardMediator.this.getFile(((DashboardMediator)DashboardMediator.this).state.dmFileName));
        }
    }

    private class CombineMMAction
    extends RunWizardAction {
        private CombineMMAction() {
        }

        public boolean isEnabled() {
            return DashboardMediator.this.project != null && ((DashboardMediator)DashboardMediator.this).state.gdmFileName != null && ((DashboardMediator)DashboardMediator.this).state.dmFileName != null && ((DashboardMediator)DashboardMediator.this).state.tdmFileName != null;
        }

        protected IWizard createWizard() {
            return new NewGMFMapModelWizard();
        }

        protected void wizardFinished(IWizard wizard) {
            IFile file = ((NewGMFMapModelWizard)wizard).getModelFile();
            ((DashboardMediator)DashboardMediator.this).state.mmFileName = DashboardMediator.this.getName(file);
            DashboardMediator.this.updateStatus();
        }
    }

    private class GenerateGMAction
    implements DashboardAction {
        private GenerateGMAction() {
        }

        public boolean isEnabled() {
            if (((DashboardMediator)DashboardMediator.this).state.dmFileName == null || ((DashboardMediator)DashboardMediator.this).state.dgmFileName == null || ((DashboardMediator)DashboardMediator.this).state.tdmFileName == null) {
                return false;
            }
            return DashboardMediator.this.project != null && ((DashboardMediator)DashboardMediator.this).state.mmFileName != null;
        }

        public void run() {
            IFile file = DashboardMediator.this.getFile(((DashboardMediator)DashboardMediator.this).state.mmFileName);
            TransformToGenModel action = new TransformToGenModel();
            Action uiAction = new Action(this){
                final /* synthetic */ GenerateGMAction this$1;
                {
                    this.this$1 = generateGMAction;
                }
            };
            uiAction.setText(Messages.DashboardMediator_13);
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            action.setActivePart((IAction)uiAction, window.getPartService().getActivePart());
            action.selectionChanged((IAction)uiAction, (ISelection)new StructuredSelection((Object)file));
            action.run((IAction)uiAction);
            IFile gfile = action.getGenModelFile();
            ((DashboardMediator)DashboardMediator.this).state.gmFileName = DashboardMediator.this.getName(gfile);
            DashboardMediator.this.updateStatus();
        }
    }

    private class GenerateDEAction
    implements DashboardAction {
        private GenerateDEAction() {
        }

        public boolean isEnabled() {
            if (((DashboardMediator)DashboardMediator.this).state.dmFileName == null || ((DashboardMediator)DashboardMediator.this).state.dgmFileName == null) {
                return false;
            }
            return DashboardMediator.this.project != null && ((DashboardMediator)DashboardMediator.this).state.gmFileName != null;
        }

        public void run() {
            IFile file = DashboardMediator.this.getFile(((DashboardMediator)DashboardMediator.this).state.gmFileName);
            ExecuteTemplatesAction action = new ExecuteTemplatesAction();
            Action uiAction = new Action(this){
                final /* synthetic */ GenerateDEAction this$1;
                {
                    this.this$1 = generateDEAction;
                }
            };
            uiAction.setText(Messages.DashboardMediator_14);
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            action.setActivePart((IAction)uiAction, window.getPartService().getActivePart());
            action.selectionChanged((IAction)uiAction, (ISelection)new StructuredSelection((Object)file));
            action.run((IAction)uiAction);
        }
    }
}

