/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmf.gmfgraph.Canvas;
import org.eclipse.gmf.internal.bridge.ui.Plugin;
import org.eclipse.gmf.internal.bridge.wizards.WizardUtil;
import org.eclipse.gmf.internal.bridge.wizards.pages.EntriesPage;
import org.eclipse.gmf.internal.bridge.wizards.pages.Messages;
import org.eclipse.gmf.internal.bridge.wizards.pages.NewMapFileCreationPage;
import org.eclipse.gmf.internal.bridge.wizards.pages.WizardInput;
import org.eclipse.gmf.internal.common.ui.ResourceLocationProvider;
import org.eclipse.gmf.mappings.CanvasMapping;
import org.eclipse.gmf.mappings.presentation.MapRefModelPages;
import org.eclipse.gmf.tooldef.GMFToolFactory;
import org.eclipse.gmf.tooldef.Palette;
import org.eclipse.gmf.tooldef.ToolRegistry;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class GMFMapGuideModelWizard
extends Wizard
implements INewWizard {
    protected IStructuredSelection mySelection;
    protected final WizardInput myHolder;
    protected final MapRefModelPages refPages;
    private IWorkbench myWorkbench;
    private ToolRegistry myRegistry;

    public GMFMapGuideModelWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.wizardTitle);
        this.myHolder = new WizardInput(){

            public EPackage getDomainModel() {
                return GMFMapGuideModelWizard.this.refPages.getDomainModel();
            }

            public Canvas getCanvasDef() {
                return GMFMapGuideModelWizard.this.refPages.getCanvas();
            }

            public ToolRegistry getToolDef() {
                if (this.isNewBlankToolDef()) {
                    return GMFMapGuideModelWizard.this.myRegistry;
                }
                Palette palette = GMFMapGuideModelWizard.this.refPages.getPalette();
                if (palette == null) {
                    return null;
                }
                return (ToolRegistry)palette.eContainer();
            }

            public boolean isNewBlankToolDef() {
                return GMFMapGuideModelWizard.this.refPages.shouldCreateNewToolingModel(false);
            }
        };
        this.refPages = new MapRefModelPages(true, this.myHolder.getResourceSet()){

            public void addPages(Wizard wizard, ISelection selection) {
                ResourceLocationProvider rloc = new ResourceLocationProvider(selection);
                this.addDomainPage(wizard, rloc);
                this.addToolPage(wizard, rloc);
                this.addGraphPage(wizard, rloc);
            }
        };
    }

    public void addPages() {
        this.addNewFilePage();
        this.refPages.addPages((Wizard)this, (ISelection)this.mySelection);
        this.refPages.getDomainModelSelectionPage().setModelRequired(true);
        this.refPages.getGraphModelSelectionPage().setModelRequired(true);
        this.refPages.getToolModelSelectionPage().setModelRequired(true);
        this.refPages.getDomainModelExt().addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                CanvasMapping cm = GMFMapGuideModelWizard.this.myHolder.getMapping().getDiagram();
                cm.setDomainModel((EPackage)arg);
            }
        });
        this.refPages.getDomainElementExt().addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                CanvasMapping cm = GMFMapGuideModelWizard.this.myHolder.getMapping().getDiagram();
                cm.setDomainMetaElement((EClass)arg);
            }
        });
        this.refPages.getCanvasExt().addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                CanvasMapping cm = GMFMapGuideModelWizard.this.myHolder.getMapping().getDiagram();
                cm.setDiagramCanvas((Canvas)arg);
                GMFMapGuideModelWizard.this.myHolder.feedDefaultMapping();
            }
        });
        this.refPages.allowNewToolingModel();
        this.refPages.getCreateNewToolingModelExt().addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                if (((Boolean)arg).booleanValue()) {
                    GMFMapGuideModelWizard.this.createBlankToolDef();
                }
            }
        });
        this.addDoMapPage();
    }

    public URI createBlankToolDef() {
        this.checkUnload((EObject)this.myRegistry);
        this.myRegistry = null;
        IPath toolDefFile = this.myHolder.getMappingFile().getFullPath().removeFileExtension().addFileExtension("gmftool");
        String baseName = this.myHolder.getMappingFile().getFullPath().removeFileExtension().lastSegment();
        int i = 1;
        IWorkspace wr = this.myHolder.getMappingFile().getProject().getWorkspace();
        while (wr.getRoot().findMember(toolDefFile) != null) {
            toolDefFile = toolDefFile.removeLastSegments(1).append(String.valueOf(baseName) + i).addFileExtension("gmftool");
            ++i;
        }
        URI toolDefURI = URI.createPlatformResourceURI((String)toolDefFile.toString(), (boolean)true);
        this.myRegistry = GMFToolFactory.eINSTANCE.createToolRegistry();
        this.myRegistry.setPalette(GMFToolFactory.eINSTANCE.createPalette());
        this.myHolder.getResourceSet().createResource(toolDefURI, "").getContents().add((Object)this.myRegistry);
        return toolDefURI;
    }

    private void checkUnload(EObject eobj) {
        if (eobj == null) {
            return;
        }
        if (eobj.eResource().getResourceSet() == this.myHolder.getResourceSet() && eobj.eResource().isLoaded()) {
            eobj.eResource().unload();
        }
    }

    protected void addNewFilePage() {
        this.addPage((IWizardPage)new NewMapFileCreationPage(this.mySelection, this.myHolder));
    }

    protected void addDoMapPage() {
        this.addPage((IWizardPage)new EntriesPage(this.myHolder));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.myWorkbench = workbench;
        this.mySelection = selection;
    }

    public boolean performFinish() {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor progressMonitor) {
                try {
                    try {
                        HashMap<String, String> options = new HashMap<String, String>();
                        options.put("ENCODING", "UTF-8");
                        if (GMFMapGuideModelWizard.this.myHolder.isNewBlankToolDef()) {
                            GMFMapGuideModelWizard.this.myHolder.getToolDef().eResource().save(options);
                        }
                        GMFMapGuideModelWizard.this.myHolder.getMapping().eResource().save(options);
                    }
                    catch (Exception ex) {
                        Plugin.log(ex);
                        progressMonitor.done();
                    }
                }
                finally {
                    progressMonitor.done();
                }
            }
        };
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            WizardUtil.selectReveal(this.myWorkbench, (ISelection)new StructuredSelection((Object)this.getModelFile()));
            WizardUtil.openInEditor(this.myWorkbench, this.getModelFile());
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (PartInitException ex) {
            Plugin.log((CoreException)((Object)ex));
        }
        return true;
    }

    public IFile getModelFile() {
        return this.myHolder.getMappingFile();
    }

    public WizardInput getWizardInput() {
        return this.myHolder;
    }
}

