/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.resources;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class AddBookmarkHelper {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static void addBookmark(final IDiagramWorkbenchPart editorPart) {
        final IStructuredSelection selection = (IStructuredSelection)editorPart.getSite().getWorkbenchWindow().getSelectionService().getSelection();
        try {
            TransactionUtil.getEditingDomain((EObject)editorPart.getDiagram()).runExclusive(new Runnable(){

                public void run() {
                    Iterator i = selection.toList().iterator();
                    while (i.hasNext()) {
                        String description;
                        Object selectedObject = i.next();
                        Assert.isTrue((boolean)(selectedObject instanceof EditPart));
                        EditPart editPart = (EditPart)selectedObject;
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.gmf.runtime.notation.View");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        View view = (View)editPart.getAdapter((Class)clazz);
                        Assert.isTrue((boolean)(selectedObject instanceof IPrimaryEditPart));
                        Assert.isNotNull((Object)view);
                        Assert.isTrue((view.eResource() != null ? 1 : 0) != 0);
                        String elementName = "";
                        EObject semanticElement = ViewUtil.resolveSemanticElement((View)view);
                        if (semanticElement != null) {
                            elementName = EMFCoreUtil.getQualifiedName((EObject)semanticElement, (boolean)true);
                        }
                        if ((description = AddBookmarkHelper.getDescription(elementName, editorPart)) == null) continue;
                        HashMap<String, String> attribMap = new HashMap<String, String>();
                        attribMap.put("message", description);
                        attribMap.put("location", elementName);
                        attribMap.put("elementId", ((XMLResource)view.eResource()).getID((EObject)view));
                        IResource resource = AddBookmarkHelper.getResource(editorPart);
                        Assert.isNotNull((Object)resource);
                        try {
                            IMarker marker = resource.createMarker("org.eclipse.gmf.runtime.common.ui.services.bookmark");
                            marker.setAttributes(attribMap);
                        }
                        catch (CoreException e) {
                            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"addBookmark", (Throwable)e);
                            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)4, (String)"addBookmark");
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            DiagramUIPlugin diagramUIPlugin = DiagramUIPlugin.getInstance();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.gmf.runtime.diagram.ui.internal.resources.AddBookmarkHelper");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Trace.catching((Plugin)diagramUIPlugin, (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, (Class)clazz, (String)"addBookmark()", (Throwable)e);
        }
    }

    private static IResource getResource(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            IEditorInput input = ((IEditorPart)part).getEditorInput();
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.core.resources.IFile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IFile)input.getAdapter((Class)clazz);
        }
        return null;
    }

    private static String getDescription(String defaultDescription, IWorkbenchPart part) {
        String title = DiagramUIMessages.AddBookmarkAction_dialog_title;
        String message = DiagramUIMessages.AddBookmarkAction_dialog_message;
        IInputValidator inputValidator = new IInputValidator(){

            public String isValid(String newText) {
                return newText == null || newText.length() == 0 ? " " : null;
            }
        };
        InputDialog dialog = new InputDialog(part.getSite().getShell(), title, message, defaultDescription, inputValidator);
        if (dialog.open() != 1) {
            String name = dialog.getValue();
            if (name == null) {
                return null;
            }
            return (name = name.trim()).length() == 0 ? null : name;
        }
        return null;
    }
}

