/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.figures;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.diagram.ui.internal.figures.IExpandableFigure;

public class BorderItemsAwareFreeFormLayer
extends FreeformLayer {
    private BorderItemAwareFreeFormHelper _helper = new BorderItemAwareFreeFormHelper((FreeformFigure)this);
    Rectangle extendedBounds = null;

    public Rectangle getBounds() {
        if (this.extendedBounds == null) {
            Iterator figuresIter = this.getChildren().iterator();
            Rectangle _bounds = super.getBounds().getCopy();
            while (figuresIter.hasNext()) {
                Figure element = (Figure)figuresIter.next();
                Rectangle rect = null;
                rect = element instanceof IExpandableFigure ? ((IExpandableFigure)element).getExtendedBounds() : element.getBounds();
                _bounds.union(rect);
            }
            this.extendedBounds = _bounds;
        }
        return this.extendedBounds;
    }

    public void invalidate() {
        this.extendedBounds = null;
        super.invalidate();
    }

    public void validate() {
        this.extendedBounds = null;
        super.validate();
    }

    public void add(IFigure child, Object constraint, int index) {
        super.add(child, constraint, index);
        this._helper.hookChild(child);
    }

    public Rectangle getFreeformExtent() {
        return this._helper.getFreeformExtent();
    }

    public void remove(IFigure child) {
        this._helper.unhookChild(child);
        super.remove(child);
    }

    public void setFreeformBounds(Rectangle bounds) {
        this._helper.setFreeformBounds(bounds);
    }

    public void borderFigureMoved() {
        this._helper.invalidate();
    }

    public class BorderItemAwareFreeFormHelper
    implements FreeformListener {
        private FreeformFigure host;
        private Rectangle freeformExtent;
        private FigureListener figureListener = new ChildTracker();

        public BorderItemAwareFreeFormHelper(FreeformFigure host) {
            this.host = host;
        }

        public void reset() {
            this.freeformExtent = null;
        }

        public Rectangle getFreeformExtent() {
            if (this.freeformExtent != null) {
                return this.freeformExtent;
            }
            List children = this.host.getChildren();
            int i = 0;
            while (i < children.size()) {
                IFigure child = (IFigure)children.get(i);
                Rectangle r = child instanceof FreeformFigure ? ((FreeformFigure)child).getFreeformExtent() : (child instanceof IExpandableFigure ? ((IExpandableFigure)child).getExtendedBounds() : child.getBounds());
                if (this.freeformExtent == null) {
                    this.freeformExtent = r.getCopy();
                } else {
                    this.freeformExtent.union(r);
                }
                ++i;
            }
            Insets insets = this.host.getInsets();
            if (this.freeformExtent == null) {
                this.freeformExtent = new Rectangle(0, 0, insets.getWidth(), insets.getHeight());
            } else {
                this.host.translateToParent((Translatable)this.freeformExtent);
                this.freeformExtent.expand(insets);
            }
            return this.freeformExtent;
        }

        public void hookChild(IFigure child) {
            this.invalidate();
            if (child instanceof FreeformFigure) {
                ((FreeformFigure)child).addFreeformListener((FreeformListener)this);
            } else {
                child.addFigureListener(this.figureListener);
            }
        }

        void invalidate() {
            this.freeformExtent = null;
            this.host.fireExtentChanged();
            if (this.host.getParent() != null) {
                this.host.getParent().revalidate();
            } else {
                this.host.revalidate();
            }
        }

        public void notifyFreeformExtentChanged() {
            this.invalidate();
        }

        public void setFreeformBounds(Rectangle bounds) {
            this.host.setBounds(bounds);
            bounds = bounds.getCopy();
            this.host.translateFromParent((Translatable)bounds);
            List children = this.host.getChildren();
            int i = 0;
            while (i < children.size()) {
                IFigure child = (IFigure)children.get(i);
                if (child instanceof FreeformFigure) {
                    ((FreeformFigure)child).setFreeformBounds(bounds);
                }
                ++i;
            }
        }

        public void unhookChild(IFigure child) {
            this.invalidate();
            if (child instanceof FreeformFigure) {
                ((FreeformFigure)child).removeFreeformListener((FreeformListener)this);
            } else {
                child.removeFigureListener(this.figureListener);
            }
        }

        class ChildTracker
        implements FigureListener {
            ChildTracker() {
            }

            public void figureMoved(IFigure source) {
                BorderItemAwareFreeFormHelper.this.invalidate();
            }
        }
    }
}

