/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.commands;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.lite.commands.CreateNotationalElementCommand;
import org.eclipse.gmf.runtime.lite.commands.ExpandDrawerCommand;
import org.eclipse.gmf.runtime.lite.services.IViewDecorator;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;

public class CreateNotationalNodeCommand
extends CreateNotationalElementCommand {
    public final Command myExposeCommand;

    public CreateNotationalNodeCommand(View parent, EObject domainElement, Rectangle constraint, IViewDecorator decorator) {
        this(parent, domainElement, constraint, decorator, true);
    }

    public CreateNotationalNodeCommand(View parent, EObject domainElement, Rectangle constraint, IViewDecorator decorator, boolean expose) {
        super(parent);
        Node createdNode = NotationFactory.eINSTANCE.createNode();
        this.setCreatedView((View)createdNode);
        createdNode.setElement(domainElement);
        decorator.decorateView((View)createdNode);
        if (constraint != null) {
            Bounds bounds = NotationFactory.eINSTANCE.createBounds();
            createdNode.setLayoutConstraint((LayoutConstraint)bounds);
            bounds.setX(constraint.x);
            bounds.setY(constraint.y);
            bounds.setWidth(constraint.width);
            bounds.setHeight(constraint.height);
        }
        this.myExposeCommand = expose ? new ExpandDrawerCommand(parent) : null;
    }

    protected boolean prepare() {
        if (!(this.getCreatedView() instanceof Node)) {
            return false;
        }
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.getParent());
        if (domain != null && domain.isReadOnly(this.getParent().eResource())) {
            return false;
        }
        return this.myExposeCommand == null || this.myExposeCommand.canExecute();
    }

    public boolean canUndo() {
        return this.myExposeCommand == null || this.myExposeCommand.canUndo();
    }

    public void execute() {
        if (this.myExposeCommand != null) {
            this.myExposeCommand.execute();
        }
        this.getParent().insertChild(this.getCreatedView());
    }

    public void undo() {
        this.getParent().removeChild(this.getCreatedView());
        if (this.myExposeCommand != null) {
            this.myExposeCommand.undo();
        }
    }

    public void redo() {
        this.execute();
    }
}

