/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.figures;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.lite.figures.SideAffixedElementPositioner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BorderItemLocator
extends SideAffixedElementPositioner
implements Locator {
    private final GraphicalEditPart myHostEditPart;
    private Rectangle myModelConstraint;
    private int preferredSide = 8;
    private int currentSide = 8;

    public BorderItemLocator(GraphicalEditPart editPart) {
        this.myHostEditPart = editPart;
    }

    public void setModelConstraint(Rectangle rectangle) {
        this.myModelConstraint = rectangle;
        if (this.getTargetFigure().getParent() != null) {
            this.getTargetFigure().getParent().revalidate();
        }
    }

    protected final IFigure getTargetFigure() {
        return this.myHostEditPart.getFigure();
    }

    public Rectangle getModelConstraint() {
        return this.myModelConstraint;
    }

    protected Rectangle getPreferredLocation() {
        if (this.getModelConstraint() == null) {
            return this.getPreferredLocation(this.getPreferredSideOfParent());
        }
        return this.toContainerCoordinates(this.getModelConstraint().getCopy());
    }

    protected Rectangle getPreferredLocation(int side) {
        Rectangle bounds = this.getParentBorder();
        int parentFigureWidth = bounds.width;
        int parentFigureHeight = bounds.height;
        int parentFigureX = bounds.x;
        int parentFigureY = bounds.y;
        int x = parentFigureX;
        int y = parentFigureY;
        Dimension borderItemSize = this.getBorderItemSize();
        if (side == 8) {
            x += this.getBorderItemOffset().width - borderItemSize.width;
            y += (parentFigureHeight - borderItemSize.height) / 2;
        } else if (side == 16) {
            x += parentFigureWidth - this.getBorderItemOffset().width;
            y += (parentFigureHeight - borderItemSize.height) / 2;
        } else if (side == 1) {
            x += (parentFigureWidth - borderItemSize.width) / 2;
            y += this.getBorderItemOffset().height - borderItemSize.height;
        } else if (side == 4) {
            x += (parentFigureWidth - borderItemSize.width) / 2;
            y += parentFigureHeight - this.getBorderItemOffset().height;
        }
        return new Rectangle(x, y, borderItemSize.width, borderItemSize.height);
    }

    public Rectangle toContainerCoordinates(Rectangle relativeOffset) {
        Point parentOrigin = this.getParentBorder().getTopLeft();
        relativeOffset.translate(parentOrigin);
        return relativeOffset;
    }

    public void relocate(IFigure borderItem) {
        assert (this.getTargetFigure() == borderItem);
        Rectangle rectSuggested = this.getPreferredLocation();
        int closestSide = BorderItemLocator.findClosestSideOfParent(rectSuggested, this.getParentBorder());
        this.setPreferredSideOfParent(closestSide);
        Rectangle newLocation = this.locateOnBorder(rectSuggested, this.getPreferredSideOfParent(), 0);
        borderItem.setBounds(newLocation);
        this.setCurrentSideOfParent(BorderItemLocator.findClosestSideOfParent(newLocation, this.getParentBorder()));
    }

    @Override
    public IFigure getHostFigure() {
        return ((GraphicalEditPart)this.myHostEditPart.getParent()).getFigure();
    }

    public int getPreferredSideOfParent() {
        return this.preferredSide;
    }

    public void setPreferredSideOfParent(int preferredSide) {
        this.preferredSide = preferredSide;
        this.setCurrentSideOfParent(preferredSide);
    }

    public int getCurrentSideOfParent() {
        return this.currentSide;
    }

    public void setCurrentSideOfParent(int side) {
        this.currentSide = side;
    }

    @Override
    protected Dimension getBorderItemSize() {
        Dimension size;
        Rectangle offset = this.getModelConstraint();
        Dimension dimension = size = offset == null ? null : offset.getSize();
        if (size == null || size.isEmpty()) {
            size = this.getTargetFigure().getPreferredSize().getCopy();
        }
        return size;
    }

    @Override
    protected Collection<? extends IFigure> getSiblings() {
        List children = this.myHostEditPart.getParent().getChildren();
        ArrayList<IFigure> result = new ArrayList<IFigure>(children.size());
        for (Object next : children) {
            IFigure nextFigure;
            GraphicalEditPart nextChild = (GraphicalEditPart)next;
            if (!nextChild.isActive() || nextChild == this.myHostEditPart || (nextFigure = nextChild.getFigure()).getParent() != this.myHostEditPart.getFigure().getParent()) continue;
            result.add(nextChild.getFigure());
        }
        return result;
    }
}

