/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.emf.core.resources;

import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.DefaultOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.emf.workspace.ResourceUndoContext;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.tests.runtime.emf.core.BaseTests;

public class GMFResourceModificationManagerTests
extends BaseTests {
    private DefaultOperationHistory history;

    public static void main(String[] args) {
        TestRunner.run((Test)GMFResourceModificationManagerTests.suite());
    }

    public static Test suite() {
        return new TestSuite(GMFResourceModificationManagerTests.class, "GMFResourceModificationManagerTests Test Suite");
    }

    protected void setUp() throws Exception {
        this.history = new DefaultOperationHistory();
        super.setUp();
        this.testEcoreResource.setTrackingModification(true);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.history = null;
    }

    protected TransactionalEditingDomain createEditingDomain() {
        return GMFEditingDomainFactory.getInstance().createEditingDomain((IOperationHistory)this.history);
    }

    protected IUndoableOperation createOperation(String name) {
        return new AbstractEMFOperation(this.domain, name){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                GMFResourceModificationManagerTests.this.ecoreRoot.getEClassifiers().add((Object)EcoreFactory.eINSTANCE.createEClass());
                return Status.OK_STATUS;
            }
        };
    }

    public void test_execute_save_execute_undo() {
        ResourceUndoContext context = new ResourceUndoContext(this.domain, this.testEcoreResource);
        IUndoableOperation op1 = this.createOperation("operation1");
        IUndoableOperation op2 = this.createOperation("operation2");
        GMFResourceModificationManagerTests.assertFalse((String)"Resource should not be modified", (boolean)this.testEcoreResource.isModified());
        try {
            this.history.execute(op1, null, null);
        }
        catch (ExecutionException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertTrue((String)"Resource should be modified", (boolean)this.testEcoreResource.isModified());
        try {
            this.testEcoreResource.save(null);
        }
        catch (IOException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertFalse((String)"Resource should not be modified", (boolean)this.testEcoreResource.isModified());
        try {
            this.history.execute(op2, null, null);
        }
        catch (ExecutionException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertTrue((String)"Resource should be modified", (boolean)this.testEcoreResource.isModified());
        try {
            this.history.undo((IUndoContext)context, null, null);
        }
        catch (ExecutionException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertFalse((String)"Resource should not be modified", (boolean)this.testEcoreResource.isModified());
    }

    public void test_execute_save_undo_redo() {
        ResourceUndoContext context = new ResourceUndoContext(this.domain, this.testEcoreResource);
        IUndoableOperation op = this.createOperation("op");
        GMFResourceModificationManagerTests.assertFalse((String)"Resource should not be modified", (boolean)this.testEcoreResource.isModified());
        try {
            this.history.execute(op, null, null);
        }
        catch (ExecutionException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertTrue((String)"Resource should be modified", (boolean)this.testEcoreResource.isModified());
        try {
            this.testEcoreResource.save(null);
        }
        catch (IOException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertFalse((String)"Resource should not be modified", (boolean)this.testEcoreResource.isModified());
        try {
            this.history.undo((IUndoContext)context, null, null);
        }
        catch (ExecutionException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertTrue((String)"Resource should be modified", (boolean)this.testEcoreResource.isModified());
        try {
            this.history.redo((IUndoContext)context, null, null);
        }
        catch (ExecutionException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertFalse((String)"Resource should not be modified", (boolean)this.testEcoreResource.isModified());
    }

    public void test_execute_save_undo_save_execute_undo() {
        ResourceUndoContext context = new ResourceUndoContext(this.domain, this.testEcoreResource);
        IUndoableOperation op1 = this.createOperation("operation1");
        IUndoableOperation op2 = this.createOperation("operation2");
        GMFResourceModificationManagerTests.assertFalse((String)"Resource should not be modified", (boolean)this.testEcoreResource.isModified());
        try {
            this.history.execute(op1, null, null);
        }
        catch (ExecutionException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertTrue((String)"Resource should be modified", (boolean)this.testEcoreResource.isModified());
        try {
            this.testEcoreResource.save(null);
        }
        catch (IOException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertFalse((String)"Resource should not be modified", (boolean)this.testEcoreResource.isModified());
        try {
            this.history.undo((IUndoContext)context, null, null);
        }
        catch (ExecutionException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertTrue((String)"Resource should be modified", (boolean)this.testEcoreResource.isModified());
        try {
            this.testEcoreResource.save(null);
        }
        catch (IOException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertFalse((String)"Resource should not be modified", (boolean)this.testEcoreResource.isModified());
        try {
            this.history.execute(op2, null, null);
        }
        catch (ExecutionException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertTrue((String)"Resource should be modified", (boolean)this.testEcoreResource.isModified());
        try {
            this.history.undo((IUndoContext)context, null, null);
        }
        catch (ExecutionException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertFalse((String)"Resource should not be modified", (boolean)this.testEcoreResource.isModified());
    }

    public void test_execute_execute_undo_save_redo() {
        ResourceUndoContext context = new ResourceUndoContext(this.domain, this.testEcoreResource);
        IUndoableOperation op1 = this.createOperation("operation1");
        IUndoableOperation op2 = this.createOperation("operation2");
        GMFResourceModificationManagerTests.assertFalse((String)"Resource should not be modified", (boolean)this.testEcoreResource.isModified());
        try {
            this.history.execute(op1, null, null);
        }
        catch (ExecutionException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertTrue((String)"Resource should be modified", (boolean)this.testEcoreResource.isModified());
        try {
            this.history.execute(op2, null, null);
        }
        catch (ExecutionException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertTrue((String)"Resource should be modified", (boolean)this.testEcoreResource.isModified());
        try {
            this.history.undo((IUndoContext)context, null, null);
        }
        catch (ExecutionException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertTrue((String)"Resource should be modified", (boolean)this.testEcoreResource.isModified());
        try {
            this.testEcoreResource.save(null);
        }
        catch (IOException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertFalse((String)"Resource should not be modified", (boolean)this.testEcoreResource.isModified());
        try {
            this.history.undo((IUndoContext)context, null, null);
        }
        catch (ExecutionException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertTrue((String)"Resource should not be modified", (boolean)this.testEcoreResource.isModified());
    }

    public void test_execute_flushLimit_undo() {
        ResourceUndoContext context = new ResourceUndoContext(this.domain, this.testEcoreResource);
        this.history.setLimit((IUndoContext)context, 1);
        IUndoableOperation op1 = this.createOperation("op1");
        IUndoableOperation op2 = this.createOperation("op2");
        try {
            this.history.execute(op1, null, null);
        }
        catch (ExecutionException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertTrue((String)"Resource should be modified", (boolean)this.testEcoreResource.isModified());
        try {
            this.history.execute(op2, null, null);
        }
        catch (ExecutionException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertTrue((String)"Resource should be modified", (boolean)this.testEcoreResource.isModified());
        GMFResourceModificationManagerTests.assertSame((String)"Operation should have been flushed", (Object)this.history.getUndoHistory((IUndoContext)context).length, (Object)1);
        try {
            this.history.undo((IUndoContext)context, null, null);
        }
        catch (ExecutionException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertTrue((String)"Resource should be modified", (boolean)this.testEcoreResource.isModified());
        try {
            this.history.undo((IUndoContext)context, null, null);
        }
        catch (ExecutionException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertTrue((String)"Resource should be modified", (boolean)this.testEcoreResource.isModified());
    }

    public void test_executeModifiedFalse_execute_undo() {
        ResourceUndoContext context = new ResourceUndoContext(this.domain, this.testEcoreResource);
        AbstractEMFOperation notModified = new AbstractEMFOperation(this.domain, "notModified"){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                GMFResourceModificationManagerTests.this.ecoreRoot.getEClassifiers().add((Object)EcoreFactory.eINSTANCE.createEClass());
                GMFResourceModificationManagerTests.this.ecoreRoot.eResource().setModified(false);
                return Status.OK_STATUS;
            }

            public boolean canUndo() {
                return false;
            }

            public boolean canRedo() {
                return false;
            }
        };
        IUndoableOperation op = this.createOperation("operation");
        GMFResourceModificationManagerTests.assertFalse((String)"Resource should not be modified", (boolean)this.testEcoreResource.isModified());
        try {
            this.history.execute((IUndoableOperation)notModified, null, null);
        }
        catch (ExecutionException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertFalse((String)"Resource should not be modified", (boolean)this.testEcoreResource.isModified());
        try {
            this.history.execute(op, null, null);
        }
        catch (ExecutionException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertTrue((String)"Resource should be modified", (boolean)this.testEcoreResource.isModified());
        try {
            this.history.undo((IUndoContext)context, null, null);
        }
        catch (ExecutionException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertFalse((String)"Resource should not be modified", (boolean)this.testEcoreResource.isModified());
    }

    public void test_execute_undoModifiedFalse_execute_undo() {
        ResourceUndoContext context = new ResourceUndoContext(this.domain, this.testEcoreResource);
        AbstractEMFOperation notModified = new AbstractEMFOperation(this.domain, "notModified"){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                GMFResourceModificationManagerTests.this.ecoreRoot.getEClassifiers().add((Object)EcoreFactory.eINSTANCE.createEClass());
                GMFResourceModificationManagerTests.this.ecoreRoot.eResource().setModified(false);
                return Status.OK_STATUS;
            }

            protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                IStatus status = super.doUndo(monitor, info);
                GMFResourceModificationManagerTests.this.ecoreRoot.eResource().setModified(false);
                return status;
            }
        };
        IUndoableOperation op = this.createOperation("operation");
        GMFResourceModificationManagerTests.assertFalse((String)"Resource should not be modified", (boolean)this.testEcoreResource.isModified());
        try {
            this.history.execute((IUndoableOperation)notModified, null, null);
        }
        catch (ExecutionException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertFalse((String)"Resource should not be modified", (boolean)this.testEcoreResource.isModified());
        try {
            this.history.undo((IUndoContext)context, null, null);
        }
        catch (ExecutionException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertFalse((String)"Resource should not be modified", (boolean)this.testEcoreResource.isModified());
        try {
            this.history.execute(op, null, null);
        }
        catch (ExecutionException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertTrue((String)"Resource should be modified", (boolean)this.testEcoreResource.isModified());
        try {
            this.history.undo((IUndoContext)context, null, null);
        }
        catch (ExecutionException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertFalse((String)"Resource should not be modified", (boolean)this.testEcoreResource.isModified());
    }

    public void test_execute_undo_redoModifiedFalse_execute_undo() {
        ResourceUndoContext context = new ResourceUndoContext(this.domain, this.testEcoreResource);
        AbstractEMFOperation notModified = new AbstractEMFOperation(this.domain, "notModified"){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                GMFResourceModificationManagerTests.this.ecoreRoot.getEClassifiers().add((Object)EcoreFactory.eINSTANCE.createEClass());
                GMFResourceModificationManagerTests.this.ecoreRoot.eResource().setModified(false);
                return Status.OK_STATUS;
            }

            protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                IStatus status = super.doUndo(monitor, info);
                GMFResourceModificationManagerTests.this.ecoreRoot.eResource().setModified(false);
                return status;
            }

            protected IStatus doRedo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                IStatus status = super.doRedo(monitor, info);
                GMFResourceModificationManagerTests.this.ecoreRoot.eResource().setModified(false);
                return status;
            }
        };
        IUndoableOperation op = this.createOperation("operation");
        GMFResourceModificationManagerTests.assertFalse((String)"Resource should not be modified", (boolean)this.testEcoreResource.isModified());
        try {
            this.history.execute((IUndoableOperation)notModified, null, null);
        }
        catch (ExecutionException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertFalse((String)"Resource should not be modified", (boolean)this.testEcoreResource.isModified());
        try {
            this.history.undo((IUndoContext)context, null, null);
        }
        catch (ExecutionException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertFalse((String)"Resource should not be modified", (boolean)this.testEcoreResource.isModified());
        try {
            this.history.redo((IUndoContext)context, null, null);
        }
        catch (ExecutionException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertFalse((String)"Resource should not be modified", (boolean)this.testEcoreResource.isModified());
        try {
            this.history.execute(op, null, null);
        }
        catch (ExecutionException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertTrue((String)"Resource should be modified", (boolean)this.testEcoreResource.isModified());
        try {
            this.history.undo((IUndoContext)context, null, null);
        }
        catch (ExecutionException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertFalse((String)"Resource should not be modified", (boolean)this.testEcoreResource.isModified());
    }

    public void test_modifiedTrueFalse_execute_undo() {
        ResourceUndoContext context = new ResourceUndoContext(this.domain, this.testEcoreResource);
        AbstractEMFOperation notModified = new AbstractEMFOperation(this.domain, "notModified"){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                GMFResourceModificationManagerTests.this.ecoreRoot.eResource().setModified(true);
                GMFResourceModificationManagerTests.this.ecoreRoot.eResource().setModified(false);
                return Status.OK_STATUS;
            }

            public boolean canUndo() {
                return false;
            }

            public boolean canRedo() {
                return false;
            }
        };
        IUndoableOperation op = this.createOperation("operation");
        GMFResourceModificationManagerTests.assertFalse((String)"Resource should not be modified", (boolean)this.testEcoreResource.isModified());
        try {
            this.history.execute((IUndoableOperation)notModified, null, null);
        }
        catch (ExecutionException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertFalse((String)"Resource should not be modified", (boolean)this.testEcoreResource.isModified());
        try {
            this.history.execute(op, null, null);
        }
        catch (ExecutionException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertTrue((String)"Resource should be modified", (boolean)this.testEcoreResource.isModified());
        try {
            this.history.undo((IUndoContext)context, null, null);
        }
        catch (ExecutionException e) {
            GMFResourceModificationManagerTests.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        GMFResourceModificationManagerTests.assertFalse((String)"Resource should not be modified", (boolean)this.testEcoreResource.isModified());
    }
}

