/*******************************************************************************
* Copyright (c) 2006, 2007 Eclipse.org
* 
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*******************************************************************************/
package org.eclipse.gmf.internal.xpand.expression.parser;

public interface ExpressionParsersym {
    public final static int
      TK_IDENT = 1,
      TK_STRING = 15,
      TK_INT_CONST = 16,
      TK_REAL_CONST = 17,
      TK_let = 25,
      TK_switch = 24,
      TK_implies = 31,
      TK_new = 18,
      TK_false = 19,
      TK_true = 20,
      TK_null = 21,
      TK_default = 32,
      TK_case = 33,
      TK_Collection = 3,
      TK_List = 4,
      TK_Set = 5,
      TK_typeSelect = 6,
      TK_collect = 7,
      TK_select = 8,
      TK_reject = 9,
      TK_exists = 10,
      TK_notExists = 11,
      TK_forAll = 12,
      TK_QUESTION_MARK = 34,
      TK_DCOLON = 26,
      TK_COLON = 27,
      TK_LPAREN = 2,
      TK_RPAREN = 23,
      TK_LCURLY = 13,
      TK_RCURLY = 28,
      TK_LSQUARE = 35,
      TK_RSQUARE = 36,
      TK_ARROW = 37,
      TK_NOT = 14,
      TK_AND = 38,
      TK_OR = 39,
      TK_ASSIGN = 40,
      TK_EQ = 41,
      TK_NE = 42,
      TK_GE = 43,
      TK_LE = 44,
      TK_GT = 45,
      TK_LT = 46,
      TK_PLUS = 29,
      TK_MINUS = 22,
      TK_MULTI = 47,
      TK_DIV = 48,
      TK_DOT = 30,
      TK_COMMA = 49,
      TK_BAR = 50,
      TK_EOF_TOKEN = 51,
      TK_ERROR_TOKEN = 52;

      public final static String orderedTerminalSymbols[] = {
                 "",
                 "IDENT",
                 "LPAREN",
                 "Collection",
                 "List",
                 "Set",
                 "typeSelect",
                 "collect",
                 "select",
                 "reject",
                 "exists",
                 "notExists",
                 "forAll",
                 "LCURLY",
                 "NOT",
                 "STRING",
                 "INT_CONST",
                 "REAL_CONST",
                 "new",
                 "false",
                 "true",
                 "null",
                 "MINUS",
                 "RPAREN",
                 "switch",
                 "let",
                 "DCOLON",
                 "COLON",
                 "RCURLY",
                 "PLUS",
                 "DOT",
                 "implies",
                 "default",
                 "case",
                 "QUESTION_MARK",
                 "LSQUARE",
                 "RSQUARE",
                 "ARROW",
                 "AND",
                 "OR",
                 "ASSIGN",
                 "EQ",
                 "NE",
                 "GE",
                 "LE",
                 "GT",
                 "LT",
                 "MULTI",
                 "DIV",
                 "COMMA",
                 "BAR",
                 "EOF_TOKEN",
                 "ERROR_TOKEN"
             };

    public final static boolean isValidForParser = true;
}
