/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.wizards.pages;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmf.internal.bridge.resolver.Resolution;
import org.eclipse.gmf.internal.bridge.resolver.ResolvedItem;
import org.eclipse.gmf.internal.bridge.resolver.StructureBuilder;
import org.eclipse.gmf.internal.bridge.ui.Plugin;
import org.eclipse.gmf.internal.bridge.wizards.pages.DiagramElementSelector;
import org.eclipse.gmf.internal.bridge.wizards.pages.DomainModelSource;
import org.eclipse.gmf.internal.bridge.wizards.pages.DomainModelViewerFactory;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class DefinitionPage
extends WizardPage {
    private StructureBuilder structureBuilder;
    private DomainModelSource domainModelSource;
    private DiagramElementSelector diagramElementSelector;
    private Composite innerPlate;
    private StackLayout innerPlateLayout;
    private TreeViewer viewer;
    private Button deselectAllButton;
    private Button recognizeButton;
    private Text errorDetails;

    public DefinitionPage(String pageId, StructureBuilder structureBuilder, DomainModelSource domainModelSource) {
        super(pageId);
        this.structureBuilder = structureBuilder;
        this.domainModelSource = domainModelSource;
        this.diagramElementSelector = new DiagramElementSelector();
    }

    protected GridData createFillBothGridData(int span) {
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = span;
        return data;
    }

    protected GridData createFillHorzGridData(int span) {
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = span;
        return data;
    }

    public void createControl(Composite parent) {
        this.innerPlate = new Composite(parent, 0);
        this.innerPlate.setBackground(new Color((Device)Display.getDefault(), 0, 0, 255));
        this.innerPlate.setLayoutData((Object)this.createFillBothGridData(1));
        this.innerPlateLayout = new StackLayout();
        this.innerPlate.setLayout((Layout)this.innerPlateLayout);
        this.innerPlateLayout.topControl = this.createDomainModelGroup(this.innerPlate);
        this.createErrorGroup(this.innerPlate);
        this.setPageComplete(false);
        this.setControl((Control)this.innerPlate);
    }

    private Composite createDomainModelGroup(Composite parent) {
        Composite plate = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 12;
        plate.setLayout((Layout)layout);
        if (this.diagramElementSelector != null) {
            this.diagramElementSelector.createControl(plate);
            this.diagramElementSelector.control.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    DefinitionPage.this.updateDiagramElement();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        Label domainModelElementsLabel = new Label(plate, 0);
        domainModelElementsLabel.setText("Domain model elements to process:");
        domainModelElementsLabel.setLayoutData((Object)this.createFillHorzGridData(2));
        Composite viewerPlate = this.createViewerGroup(plate);
        viewerPlate.setLayoutData((Object)this.createFillBothGridData(2));
        plate.setLayoutData((Object)this.createFillBothGridData(1));
        return plate;
    }

    private Composite createViewerGroup(Composite parent) {
        Composite plate = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 12;
        plate.setLayout((Layout)layout);
        this.viewer = this.createViewer(plate);
        this.viewer.getControl().setLayoutData((Object)this.createFillBothGridData(1));
        Composite buttonsPlate = this.createDomainModelButtons(plate);
        buttonsPlate.setLayoutData((Object)new GridData(1040));
        return plate;
    }

    private Composite createErrorGroup(Composite parent) {
        Composite plate = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 12;
        plate.setLayout((Layout)layout);
        Label errorDescription = new Label(plate, 0);
        errorDescription.setText("Error loading domain model:");
        errorDescription.setLayoutData((Object)this.createFillHorzGridData(1));
        this.errorDetails = new Text(plate, 2816);
        this.errorDetails.setLayoutData((Object)this.createFillBothGridData(1));
        return plate;
    }

    private Composite createDomainModelButtons(Composite parent) {
        Composite plate = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 12;
        plate.setLayout((Layout)layout);
        this.deselectAllButton = new Button(plate, 8);
        this.deselectAllButton.setLayoutData((Object)this.createFillHorzGridData(1));
        this.deselectAllButton.setText("Deselect All");
        this.deselectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                this.deselectChildren(DefinitionPage.this.getModel());
                DefinitionPage.this.viewer.refresh(true);
            }

            private void deselectChildren(ResolvedItem item) {
                Iterator it = item.getChildren().iterator();
                while (it.hasNext()) {
                    ResolvedItem child = (ResolvedItem)it.next();
                    child.setResolution(null);
                    this.deselectChildren(child);
                }
            }
        });
        this.recognizeButton = new Button(plate, 8);
        this.recognizeButton.setLayoutData((Object)this.createFillHorzGridData(1));
        this.recognizeButton.setText("Defaults");
        this.recognizeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                EPackage contents = DefinitionPage.this.domainModelSource.getContents();
                DefinitionPage.this.viewer.setInput(contents == null ? null : DefinitionPage.this.structureBuilder.process(contents, null));
                DefinitionPage.this.viewer.expandAll();
                if (DefinitionPage.this.diagramElementSelector != null) {
                    DefinitionPage.this.diagramElementSelector.setDomainModel(DefinitionPage.this.getModel());
                }
                if (contents != null) {
                    DefinitionPage.this.setPageComplete(DefinitionPage.this.validatePage());
                } else {
                    DefinitionPage.this.setPageComplete(true);
                }
                DefinitionPage.this.showDomainModelControls();
            }
        });
        return plate;
    }

    protected TreeViewer createViewer(Composite parent) {
        Tree tree = new Tree(parent, 68356);
        TableLayout layout = new TableLayout(){

            public void layout(Composite c, boolean flush) {
                super.layout(c, flush);
                TreeColumn elementColumn = ((Tree)c).getColumn(0);
                int width = elementColumn.getWidth() - 8;
                if (width < 0) {
                    width = 0;
                }
                elementColumn.setWidth(width);
            }
        };
        tree.setLayout((Layout)layout);
        tree.setHeaderVisible(true);
        TreeColumn elementColumn = new TreeColumn(tree, 16384);
        elementColumn.setText("Element");
        elementColumn.setResizable(true);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 32, true));
        this.addResolutionColumn(tree, Resolution.NODE, "/icons/cview16/node.gif");
        this.addResolutionColumn(tree, Resolution.LINK, "/icons/cview16/link.gif");
        this.addResolutionColumn(tree, Resolution.LABEL, "/icons/cview16/label.gif");
        this.viewer = DomainModelViewerFactory.createViewer(tree);
        return this.viewer;
    }

    protected TreeColumn addResolutionColumn(Tree tree, Resolution resolution, String iconId) {
        TreeColumn column = new TreeColumn(tree, 0x1000000);
        column.setImage(Plugin.getDefault().getImageRegistry().get(iconId));
        column.setResizable(false);
        ((TableLayout)tree.getLayout()).addColumnData((ColumnLayoutData)new ColumnPixelData(18, false, true));
        return column;
    }

    protected boolean validatePage() {
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.domainModelSource.update()) {
            EPackage contents = this.domainModelSource.getContents();
            this.viewer.setInput(contents == null ? null : this.structureBuilder.process(contents, null));
            this.viewer.expandAll();
            this.viewer.getControl().pack();
            if (contents != null) {
                if (this.diagramElementSelector != null) {
                    this.diagramElementSelector.setDomainModel(this.getModel());
                }
                this.setPageComplete(this.validatePage());
                this.showDomainModelControls();
            } else if (this.domainModelSource.getErrorStatus() == null) {
                if (this.diagramElementSelector != null) {
                    this.diagramElementSelector.setDomainModel(null);
                }
                this.setPageComplete(true);
                this.showDomainModelControls();
            } else {
                this.setPageComplete(false);
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    PrintStream ps = new PrintStream(baos);
                    this.domainModelSource.getErrorStatus().getException().printStackTrace(ps);
                    ps.flush();
                    baos.flush();
                    this.errorDetails.setText(baos.toString());
                }
                catch (IOException iOException) {}
                this.showErrorDetailsControls();
            }
            this.innerPlate.layout(true, true);
        }
    }

    private void updateDiagramElement() {
        ResolvedItem item = this.getDiagramElement();
        if (item == null) {
            return;
        }
        EPackage contents = this.domainModelSource.getContents();
        this.viewer.setInput(contents == null ? null : this.structureBuilder.process(contents, (EClass)item.getDomainRef()));
        this.viewer.expandAll();
        if (this.diagramElementSelector != null) {
            this.diagramElementSelector.setDomainModel(this.getModel());
        }
    }

    protected void showDomainModelControls() {
        this.innerPlateLayout.topControl = this.innerPlate.getChildren()[0];
    }

    protected void showErrorDetailsControls() {
        this.innerPlateLayout.topControl = this.innerPlate.getChildren()[1];
    }

    public ResolvedItem getModel() {
        return (ResolvedItem)this.viewer.getInput();
    }

    public ResolvedItem getDiagramElement() {
        return this.diagramElementSelector == null ? null : this.diagramElementSelector.getDiagramElement();
    }
}

