/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.emf.ui;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProvider;
import org.eclipse.gmf.runtime.common.core.service.IProviderChangeListener;
import org.eclipse.gmf.runtime.common.core.service.IProviderPolicy;
import org.eclipse.gmf.runtime.common.core.service.ProviderPriority;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.emf.type.core.ElementType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.IEditHelper;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.ModelingAssistantProvider;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.ModelingAssistantService;
import org.eclipse.gmf.tests.runtime.common.core.internal.util.TestingConfigurationElement;

public class ModelingAssistantServiceTests
extends TestCase {
    private static boolean shouldBeContributed = false;
    private MyModelingAssistantService modelingAssistantService = null;

    public static boolean myStaticMethod() {
        return shouldBeContributed;
    }

    public ModelingAssistantServiceTests(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ModelingAssistantServiceTests.suite());
    }

    public static Test suite() {
        return new TestSuite(ModelingAssistantServiceTests.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.setModelingAssistantService(new MyModelingAssistantService());
    }

    public MyModelingAssistantService getModelingAssistantService() {
        return this.modelingAssistantService;
    }

    public void setModelingAssistantService(MyModelingAssistantService service) {
        this.modelingAssistantService = service;
    }

    public void testCapabilityFiltering() throws Exception {
        MyElementType TYPE1 = new MyElementType("TYPE1");
        MyModelingAssistantService.ProviderDescriptor provider1Descriptor = new MyModelingAssistantService.ProviderDescriptor((IProvider)new MyModelingAssistantProvider(Collections.singletonList(TYPE1)));
        this.getModelingAssistantService().addModelingAssistantProvider(ProviderPriority.LOW, provider1Descriptor);
        MyElementType TYPE2 = new MyElementType("TYPE2");
        MyModelingAssistantService.ProviderDescriptor provider2Descriptor = new MyModelingAssistantService.ProviderDescriptor((IProvider)new MyModelingAssistantProvider(Collections.singletonList(TYPE2)));
        this.getModelingAssistantService().addModelingAssistantProvider(ProviderPriority.HIGH, provider2Descriptor);
        List allTypes = this.getModelingAssistantService().getTypesForPopupBar(null);
        ModelingAssistantServiceTests.assertEquals((int)2, (int)allTypes.size());
        provider1Descriptor.setActivitiesEnabled(false);
        ModelingAssistantServiceTests.assertEquals((int)1, (int)this.getModelingAssistantService().getTypesForPopupBar(null).size());
        provider1Descriptor.setActivitiesEnabled(true);
        List allTypesAgain = this.getModelingAssistantService().getTypesForPopupBar(null);
        ModelingAssistantServiceTests.assertEquals((int)2, (int)allTypesAgain.size());
        ModelingAssistantServiceTests.assertTrue((boolean)Arrays.equals(allTypes.toArray(), allTypesAgain.toArray()));
    }

    public static class MyElementType
    extends ElementType {
        public MyElementType(String id) {
            super(id, null, id);
        }

        public IEditHelper getEditHelper() {
            return null;
        }
    }

    public class MyModelingAssistantProvider
    extends ModelingAssistantProvider {
        private List types;

        public MyModelingAssistantProvider(List types) {
            this.types = types;
        }

        public List getTypesForPopupBar(IAdaptable host) {
            return this.types;
        }
    }

    public static class MyModelingAssistantProviderViaXML
    extends ModelingAssistantProvider {
        public List getTypesForPopupBar(IAdaptable host) {
            if (host.getAdapter(MyElementType.class) != null) {
                return Collections.singletonList(new MyElementType("TYPE1"));
            }
            return Collections.EMPTY_LIST;
        }
    }

    protected static class MyModelingAssistantService
    extends ModelingAssistantService {
        protected MyModelingAssistantService() {
        }

        protected void addModelingAssistantProvider(ProviderPriority priority, ProviderDescriptor provider) {
            super.addProvider(priority, (Service.ProviderDescriptor)provider);
        }

        protected void removeModelingAssistantProvider(Service.ProviderDescriptor provider) {
            super.removeProvider(provider);
        }

        protected static class ProviderDescriptor
        extends ModelingAssistantService.ProviderDescriptor {
            public boolean areActivitiesEnabled = true;

            protected ProviderDescriptor(IProvider provider) {
                super((IConfigurationElement)new TestingConfigurationElement());
                this.provider = provider;
                provider.addProviderChangeListener((IProviderChangeListener)this);
            }

            public IProvider getProvider() {
                return this.provider;
            }

            protected IProviderPolicy getPolicy() {
                return null;
            }

            public boolean provides(IOperation operation) {
                return this.areActivitiesEnabled;
            }

            public void setActivitiesEnabled(boolean b) {
                this.areActivitiesEnabled = b;
            }
        }
    }
}

