/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.xtend;

import org.eclipse.gmf.internal.xpand.expression.ast.BooleanLiteral;
import org.eclipse.gmf.internal.xpand.expression.ast.DeclaredParameter;
import org.eclipse.gmf.internal.xpand.xtend.ast.CreateExtensionStatement;
import org.eclipse.gmf.internal.xpand.xtend.ast.ExpressionExtensionStatement;
import org.eclipse.gmf.internal.xpand.xtend.ast.ExtensionFile;
import org.eclipse.gmf.internal.xpand.xtend.ast.ImportStatement;
import org.eclipse.gmf.internal.xpand.xtend.ast.JavaExtensionStatement;
import org.eclipse.gmf.tests.xtend.AbstractXtendTest;

public class ExtensionParserTest
extends AbstractXtendTest {
    public final void testSimple() {
        ExtensionFile file = this.parse("trueFunc() :true;");
        ExtensionParserTest.assertTrue((boolean)file.getNsImports().isEmpty());
        ExtensionParserTest.assertTrue((boolean)file.getExtImports().isEmpty());
        ExtensionParserTest.assertEquals((int)1, (int)file.getExtensions().size());
        ExpressionExtensionStatement fd = (ExpressionExtensionStatement)file.getExtensions().get(0);
        ExtensionParserTest.assertEquals((String)"trueFunc", (String)fd.getName());
        ExtensionParserTest.assertTrue((boolean)fd.getFormalParameters().isEmpty());
        ExtensionParserTest.assertTrue((boolean)(fd.getExpression() instanceof BooleanLiteral));
    }

    public final void testWithImportAndComments() {
        ExtensionFile file = this.parse("// test \nimport \"oaw\"; \n/* \n * Meine Funktion \n */ \ntrueFunc() :true; \n");
        ExtensionParserTest.assertEquals((int)1, (int)file.getNsImports().size());
        ImportStatement imp = (ImportStatement)file.getNsImports().get(0);
        ExtensionParserTest.assertEquals((String)"oaw", (String)imp.getValue());
        ExtensionParserTest.assertTrue((boolean)file.getExtImports().isEmpty());
        ExtensionParserTest.assertEquals((int)1, (int)file.getExtensions().size());
        ExpressionExtensionStatement fd = (ExpressionExtensionStatement)file.getExtensions().get(0);
        ExtensionParserTest.assertEquals((String)"trueFunc", (String)fd.getName());
        ExtensionParserTest.assertTrue((boolean)fd.getFormalParameters().isEmpty());
        ExtensionParserTest.assertTrue((boolean)(fd.getExpression() instanceof BooleanLiteral));
    }

    public final void testWithEverything() {
        ExtensionFile file = this.parse("import \"oaw\"; \nimport \"http://ecore/x\"; \nextension test::TestExtension; \n\nprivate Void dump(Object obj) :JAVA java.util.String.valueOf(char) ; \n\n/* \n * Meine Funktion \n */ \ntrueFunc() :true; \n\nVoid dump(String s) : JAVA de.DefaultImpl.doStuff(java.util.Collection,java.util.Set) ; \n");
        ExtensionParserTest.assertEquals((int)2, (int)file.getNsImports().size());
        ImportStatement imp = (ImportStatement)file.getNsImports().get(1);
        ExtensionParserTest.assertEquals((String)"http://ecore/x", (String)imp.getValue());
        ExtensionParserTest.assertEquals((int)1, (int)file.getExtImports().size());
        ImportStatement extImp = (ImportStatement)file.getExtImports().get(0);
        ExtensionParserTest.assertEquals((String)"test::TestExtension", (String)extImp.getValue());
        ExtensionParserTest.assertEquals((int)3, (int)file.getExtensions().size());
        JavaExtensionStatement ext1 = (JavaExtensionStatement)file.getExtensions().get(0);
        ExtensionParserTest.assertNotNull((Object)ext1.getJavaType());
        ExtensionParserTest.assertEquals((String)"dump", (String)ext1.getName());
        ExtensionParserTest.assertTrue((boolean)ext1.isPrivate());
        DeclaredParameter param = (DeclaredParameter)ext1.getFormalParameters().get(0);
        ExtensionParserTest.assertEquals((String)"obj", (String)param.getName().getValue());
        ExtensionParserTest.assertEquals((String)"Object", (String)param.getType().getValue());
        ExpressionExtensionStatement fd = (ExpressionExtensionStatement)file.getExtensions().get(1);
        ExtensionParserTest.assertEquals((String)"trueFunc", (String)fd.getName());
        ExtensionParserTest.assertTrue((boolean)fd.getFormalParameters().isEmpty());
        ExtensionParserTest.assertTrue((boolean)(fd.getExpression() instanceof BooleanLiteral));
    }

    public final void testDoubleSemi() {
        this.parse("String dump1(String s) :s ;;\nString dump2(String s) :s ; \n");
    }

    public final void testCreateExtension() {
        ExtensionFile file = this.parse("create List[String] l test(String s) : l.add(s) ;");
        CreateExtensionStatement c = (CreateExtensionStatement)file.getExtensions().get(0);
        ExtensionParserTest.assertNotNull((Object)c);
        ExtensionParserTest.assertEquals((String)"List[String]", (String)c.getReturnTypeIdentifier().getValue());
        ExtensionParserTest.assertEquals((String)"test", (String)c.getName());
    }
}

