/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.editor.scan;

import java.util.ArrayList;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;

public class XpandPartitionScanner
extends RuleBasedScanner
implements IPartitionTokenScanner {
    public static final String TAG = "__tag";
    public static final String COMMENT = "__comment";

    public XpandPartitionScanner() {
        Token tag = new Token((Object)TAG);
        Token comment = new Token((Object)COMMENT);
        ArrayList<MultiLineRule> rules = new ArrayList<MultiLineRule>();
        rules.add(new MultiLineRule("\u00abREM", "ENDREM\u00bb", (IToken)comment));
        rules.add(new MultiLineRule("\u00abREM", "ENDREM-\u00bb", (IToken)comment){

            public IToken evaluate(ICharacterScanner scanner) {
                return super.evaluate(scanner);
            }
        });
        rules.add(new MultiLineRule("\u00ab", "\u00bb", (IToken)tag));
        this.setRules((IRule[])rules.toArray(new IPredicateRule[rules.size()]));
    }

    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
        int delta;
        if (partitionOffset > -1 && (delta = offset - partitionOffset) > 0) {
            super.setRange(document, partitionOffset, length + delta);
            return;
        }
        super.setRange(document, offset, length);
    }

    public IToken nextToken() {
        this.fTokenOffset = this.fOffset;
        this.fColumn = -1;
        if (this.fRules != null) {
            int i = 0;
            while (i < this.fRules.length) {
                IToken token = this.fRules[i].evaluate((ICharacterScanner)this);
                if (!token.isUndefined()) {
                    return token;
                }
                this.fOffset = this.fTokenOffset;
                ++i;
            }
        }
        if (this.read() == -1) {
            return Token.EOF;
        }
        return this.fDefaultReturnToken;
    }
}

