/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.expression;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;

public class TypeNameUtil {
    private static final Pattern TYPE_PATTERN = Pattern.compile("\\A((\\w+)\\[)?((\\w+)!)?([\\w:]*\\w+)(\\])?\\z");

    public static String getCollectionTypeName(String name) {
        return TypeNameUtil.getGroup(name, 2);
    }

    public static String getMetaModelName(String name) {
        return TypeNameUtil.getGroup(name, 4);
    }

    public static String getTypeName(String name) {
        return TypeNameUtil.getGroup(name, 5);
    }

    private static String getGroup(String input, int group) {
        Matcher m = TYPE_PATTERN.matcher(input);
        if (m.matches()) {
            return m.group(group);
        }
        return null;
    }

    public static String withoutLastSegment(String fqn) {
        if (fqn.lastIndexOf("::") == -1) {
            return null;
        }
        return fqn.substring(0, fqn.lastIndexOf("::"));
    }

    public static String toCanonicalNameFromAlias(String potentialAlias) {
        if ("String".equals(potentialAlias) || "string".equals(potentialAlias)) {
            return "EString";
        }
        if ("boolean".equals(potentialAlias) || "Boolean".equals(potentialAlias)) {
            return "EBoolean";
        }
        if ("Integer".equals(potentialAlias) || "int".equals(potentialAlias)) {
            return "EInt";
        }
        if ("Object".equals(potentialAlias)) {
            return "EJavaObject";
        }
        return potentialAlias;
    }

    public static boolean isQualifiedName(String name) {
        assert (name != null);
        return name.indexOf("::") != -1;
    }

    public static String getLastSegment(String fqn) {
        if (fqn.lastIndexOf("::") == -1) {
            return fqn;
        }
        return fqn.substring(fqn.lastIndexOf("::") + "::".length());
    }

    public static String getQualifiedName(EClassifier type) {
        if (type.getEPackage() == null) {
            return type.getName();
        }
        return String.valueOf(TypeNameUtil.getFullNamespace(type)) + "::" + type.getName();
    }

    public static String getFullNamespace(EClassifier type) {
        assert (type != null);
        StringBuilder sb = new StringBuilder();
        EPackage p = type.getEPackage();
        while (p != null) {
            if (sb.length() > 0) {
                sb.insert(0, "::");
            }
            sb.insert(0, p.getName());
            p = p.getESuperPackage();
        }
        return sb.toString();
    }

    public static String getSimpleName(String fqn) {
        String ct = TypeNameUtil.getCollectionTypeName(fqn);
        String mm = TypeNameUtil.getMetaModelName(fqn);
        String inner = TypeNameUtil.getLastSegment(TypeNameUtil.getTypeName(fqn));
        StringBuffer sb = new StringBuffer();
        if (ct != null) {
            sb.append(ct).append("[");
        }
        if (mm != null) {
            sb.append(mm).append("!");
        }
        sb.append(inner);
        if (ct != null) {
            sb.append("]");
        }
        return sb.toString();
    }
}

