/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.commands;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Node;

public class ChangeBoundsCommand
extends AbstractCommand {
    private final Node myNode;
    private final ChangeBoundsRequest myRequest;
    private final IFigure myReferenceFigure;
    private Point myMoveDelta;
    private Dimension myResizeDelta;

    public ChangeBoundsCommand(Node node, ChangeBoundsRequest request, IFigure figure) {
        super("Change node position/size");
        this.myNode = node;
        this.myRequest = request;
        this.myReferenceFigure = figure;
    }

    public boolean canUndo() {
        return this.canExecute();
    }

    protected boolean prepare() {
        if (!(this.myNode.getLayoutConstraint() instanceof Bounds)) {
            return false;
        }
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.myNode);
        if (domain != null && domain.isReadOnly(this.myNode.eResource())) {
            return false;
        }
        Bounds bounds = (Bounds)this.myNode.getLayoutConstraint();
        Rectangle original = new Rectangle(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        this.myReferenceFigure.translateToAbsolute((Translatable)original);
        Rectangle transformed = this.myRequest.getTransformedRectangle(original);
        this.myReferenceFigure.translateToRelative((Translatable)transformed);
        this.myReferenceFigure.translateToRelative((Translatable)original);
        this.myResizeDelta = transformed.getSize().expand(original.getSize().negate());
        this.myMoveDelta = transformed.getTopLeft().translate(original.getTopLeft().negate());
        return true;
    }

    public void undo() {
        this.execute(this.myMoveDelta.getNegated(), this.myResizeDelta.getNegated());
    }

    public void execute() {
        this.execute(this.myMoveDelta, this.myResizeDelta);
    }

    public void redo() {
        this.execute();
    }

    private void execute(Point move, Dimension resize) {
        Bounds bounds = (Bounds)this.myNode.getLayoutConstraint();
        bounds.setX(bounds.getX() + move.x);
        bounds.setY(bounds.getY() + move.y);
        bounds.setWidth(bounds.getWidth() + resize.width);
        bounds.setHeight(bounds.getHeight() + resize.height);
    }
}

