/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.lite.multi;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.codegen.gmfgen.FeatureLinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.runtime.lite.commands.CreateNotationalElementCommand;
import org.eclipse.gmf.runtime.lite.shortcuts.IShortcutProvider;
import org.eclipse.gmf.runtime.lite.shortcuts.ShortcutProvidersRegistry;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.rt.AbstractCanvasTest;
import org.eclipse.gmf.tests.rt.AbstractMultiSetupTest;
import org.eclipse.gmf.tests.setup.RTSetup;
import org.eclipse.gmf.tests.setup.SessionSetup;

public class ShortcutCreationTest
extends AbstractMultiSetupTest {
    public ShortcutCreationTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        SessionSetup[] setups = this.getMultiSetup().getAllSetups();
        ShortcutCreationTest.assertEquals((int)2, (int)setups.length);
    }

    public void testShortcutCreationAndDeletion() throws Exception {
        Diagram diagram = this.getDiagram();
        SessionSetup shortcutSetup = this.getMultiSetup().getAllSetups()[1];
        GenDiagram shortcutSource = shortcutSetup.getGenModel().getGenDiagram();
        String modelID = shortcutSource.getEditorGen().getModelID();
        RTSetup secondDiagramSetup = new RTSetup().init(shortcutSetup.getGeneratedPlugin(), shortcutSetup.getGenModel(), TransactionUtil.getEditingDomain((EObject)diagram));
        EObject shortcutObject = secondDiagramSetup.getNodeA().getElement();
        Node createdShortcut = this.createShortcutNode(modelID, (View)diagram, shortcutObject);
        EditPart shortcutEP = this.findEditPart((View)createdShortcut);
        ShortcutCreationTest.assertNotNull((Object)shortcutEP);
        ShortcutCreationTest.assertTrue((boolean)shortcutEP.isActive());
        GroupRequest request = new GroupRequest((Object)"delete_view");
        org.eclipse.gef.commands.Command deleteViewCommand = shortcutEP.getCommand((Request)request);
        ShortcutCreationTest.assertNotNull((Object)deleteViewCommand);
        ShortcutCreationTest.assertTrue((String)"Cannot delete shortcut", (boolean)deleteViewCommand.canExecute());
        this.execute(deleteViewCommand);
        ShortcutCreationTest.assertFalse((boolean)shortcutEP.isActive());
        ShortcutCreationTest.assertNull((Object)createdShortcut.eContainer());
        ShortcutCreationTest.assertNotNull((Object)shortcutObject.eContainer());
    }

    public void testCanonicalChildrenOfShortcuts() throws Exception {
        SessionSetup shortcutSetup = this.getMultiSetup().getAllSetups()[1];
        EList compartments = shortcutSetup.getGenModel().getNodeA().getCompartments();
        ShortcutCreationTest.assertFalse((boolean)compartments.isEmpty());
        GenCompartment shortcutCompartment = (GenCompartment)compartments.get(0);
        ShortcutCreationTest.assertNotNull((Object)shortcutCompartment);
        EList containedNodes = shortcutCompartment.getContainedNodes();
        ShortcutCreationTest.assertFalse((boolean)containedNodes.isEmpty());
        GenNode containedNode = (GenNode)containedNodes.get(0);
        GenFeature containmentMetaFeature = containedNode.getModelFacet().getContainmentMetaFeature();
        Diagram diagram = this.getDiagram();
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)diagram);
        GenDiagram shortcutSource = shortcutSetup.getGenModel().getGenDiagram();
        String modelID = shortcutSource.getEditorGen().getModelID();
        RTSetup secondDiagramSetup = new RTSetup().init(shortcutSetup.getGeneratedPlugin(), shortcutSetup.getGenModel(), TransactionUtil.getEditingDomain((EObject)diagram));
        EObject shortcutObject = secondDiagramSetup.getNodeA().getElement();
        Node createdShortcut = this.createShortcutNode(modelID, (View)diagram, shortcutObject);
        EditPart shortcutEP = this.findEditPart((View)createdShortcut);
        ShortcutCreationTest.assertNotNull((Object)shortcutEP);
        ShortcutCreationTest.assertTrue((boolean)shortcutEP.isActive());
        View compartmentView = ShortcutCreationTest.findChildView((View)createdShortcut, (GenCommonBase)shortcutCompartment);
        ShortcutCreationTest.assertNotNull((Object)compartmentView);
        String featureName = containmentMetaFeature.getEcoreFeature().getName();
        EStructuralFeature feature = shortcutObject.eClass().getEStructuralFeature(featureName);
        ShortcutCreationTest.assertNotNull((String)"Feature not found", (Object)feature);
        ShortcutCreationTest.assertTrue((boolean)(feature.getEType() instanceof EClass));
        ShortcutCreationTest.assertTrue((boolean)feature.isMany());
        EClass newChildClass = (EClass)feature.getEType();
        EObject newChild = newChildClass.getEPackage().getEFactoryInstance().create(newChildClass);
        Command addCommand = AddCommand.create((EditingDomain)domain, (Object)shortcutObject, (Object)feature, (Object)newChild);
        ShortcutCreationTest.assertNotNull((Object)addCommand);
        ShortcutCreationTest.assertTrue((boolean)addCommand.canExecute());
        new EMFCommandOperation(domain, addCommand).execute((IProgressMonitor)new NullProgressMonitor(), null);
        ShortcutCreationTest.assertNotNull((String)"Add command not created", (Object)newChild.eContainer());
        View newChildView = this.findView(compartmentView, newChild);
        ShortcutCreationTest.assertNotNull((String)"Notation model of shortcut not refreshed", (Object)newChildView);
    }

    public void testShortcutLinkNotationRefresh() throws Exception {
        EStructuralFeature refFeature;
        Command deleteLinkCommand;
        SessionSetup shortcutSetup = this.getMultiSetup().getAllSetups()[1];
        GenNode nodeA = shortcutSetup.getGenModel().getNodeA();
        GenNode nodeB = shortcutSetup.getGenModel().getNodeB();
        GenLink typeLink = shortcutSetup.getGenModel().getLinkC();
        GenLink refLink = shortcutSetup.getGenModel().getLinkD();
        boolean shouldSwapRef = false;
        boolean shouldSwapType = false;
        if (nodeA.getDomainMetaClass().equals(typeLink.getModelFacet().getSourceType())) {
            ShortcutCreationTest.assertEquals((Object)nodeB.getDomainMetaClass(), (Object)typeLink.getModelFacet().getTargetType());
        } else {
            ShortcutCreationTest.assertEquals((Object)nodeB.getDomainMetaClass(), (Object)typeLink.getModelFacet().getSourceType());
            ShortcutCreationTest.assertEquals((Object)nodeA.getDomainMetaClass(), (Object)typeLink.getModelFacet().getTargetType());
            shouldSwapType = true;
        }
        if (nodeA.getDomainMetaClass().equals(refLink.getModelFacet().getSourceType())) {
            ShortcutCreationTest.assertEquals((Object)nodeB.getDomainMetaClass(), (Object)refLink.getModelFacet().getTargetType());
        } else {
            ShortcutCreationTest.assertEquals((Object)nodeB.getDomainMetaClass(), (Object)refLink.getModelFacet().getSourceType());
            ShortcutCreationTest.assertEquals((Object)nodeA.getDomainMetaClass(), (Object)refLink.getModelFacet().getTargetType());
            shouldSwapRef = true;
            shouldSwapType = !shouldSwapType;
        }
        String refLinkMetaFeatureName = ((FeatureLinkModelFacet)refLink.getModelFacet()).getMetaFeature().getEcoreFeature().getName();
        Diagram diagram = this.getDiagram();
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)diagram);
        GenDiagram shortcutSource = shortcutSetup.getGenModel().getGenDiagram();
        String modelID = shortcutSource.getEditorGen().getModelID();
        RTSetup secondDiagramSetup = new RTSetup().init(shortcutSetup.getGeneratedPlugin(), shortcutSetup.getGenModel(), TransactionUtil.getEditingDomain((EObject)diagram));
        EObject shortcutA = secondDiagramSetup.getNodeA().getElement();
        EObject shortcutB = secondDiagramSetup.getNodeB().getElement();
        if (shouldSwapRef) {
            EObject swap = shortcutB;
            shortcutB = shortcutA;
            shortcutA = swap;
        }
        ShortcutCreationTest.assertTrue(((deleteLinkCommand = SetCommand.create((EditingDomain)domain, (Object)shortcutA, (Object)(refFeature = shortcutA.eClass().getEStructuralFeature(refLinkMetaFeatureName)), null)) != null && deleteLinkCommand.canExecute() ? 1 : 0) != 0);
        new EMFCommandOperation(domain, deleteLinkCommand).execute((IProgressMonitor)new NullProgressMonitor(), null);
        ShortcutCreationTest.assertNull((String)"Delete command not executed", (Object)shortcutA.eGet(refFeature));
        Node createdShortcutA = this.createShortcutNode(modelID, (View)diagram, shortcutA);
        EditPart shortcutAEP = this.findEditPart((View)createdShortcutA);
        ShortcutCreationTest.assertNotNull((Object)shortcutAEP);
        ShortcutCreationTest.assertTrue((boolean)shortcutAEP.isActive());
        Node createdShortcutB = this.createShortcutNode(modelID, (View)diagram, shortcutB);
        EditPart shortcutBEP = this.findEditPart((View)createdShortcutB);
        ShortcutCreationTest.assertNotNull((Object)shortcutBEP);
        ShortcutCreationTest.assertTrue((boolean)shortcutBEP.isActive());
        ShortcutCreationTest.assertEquals((int)ShortcutCreationTest.getIntForBoolean(shouldSwapType), (int)createdShortcutA.getTargetEdges().size());
        ShortcutCreationTest.assertEquals((int)ShortcutCreationTest.getIntForBoolean(shouldSwapType), (int)createdShortcutB.getSourceEdges().size());
        ShortcutCreationTest.assertEquals((int)ShortcutCreationTest.getIntForBoolean(!shouldSwapType), (int)createdShortcutA.getSourceEdges().size());
        ShortcutCreationTest.assertEquals((int)ShortcutCreationTest.getIntForBoolean(!shouldSwapType), (int)createdShortcutB.getTargetEdges().size());
        Command setCommand = SetCommand.create((EditingDomain)domain, (Object)shortcutA, (Object)refFeature, (Object)shortcutB);
        ShortcutCreationTest.assertTrue((setCommand != null && setCommand.canExecute() ? 1 : 0) != 0);
        new EMFCommandOperation(domain, setCommand).execute((IProgressMonitor)new NullProgressMonitor(), null);
        ShortcutCreationTest.assertEquals((String)"Create link command not executed", (int)(ShortcutCreationTest.getIntForBoolean(shouldSwapType) + ShortcutCreationTest.getIntForBoolean(!shouldSwapRef)), (int)secondDiagramSetup.getNodeA().getTargetEdges().size());
        ShortcutCreationTest.assertEquals((String)"Create link command not executed", (int)(ShortcutCreationTest.getIntForBoolean(shouldSwapType) + ShortcutCreationTest.getIntForBoolean(!shouldSwapRef)), (int)secondDiagramSetup.getNodeB().getSourceEdges().size());
        ShortcutCreationTest.assertEquals((String)"Create link command not executed", (int)(ShortcutCreationTest.getIntForBoolean(!shouldSwapType) + ShortcutCreationTest.getIntForBoolean(shouldSwapRef)), (int)secondDiagramSetup.getNodeA().getSourceEdges().size());
        ShortcutCreationTest.assertEquals((String)"Create link command not executed", (int)(ShortcutCreationTest.getIntForBoolean(!shouldSwapType) + ShortcutCreationTest.getIntForBoolean(shouldSwapRef)), (int)secondDiagramSetup.getNodeB().getTargetEdges().size());
        ShortcutCreationTest.assertEquals((String)"Command that created link did not affect shortcuts", (int)(ShortcutCreationTest.getIntForBoolean(shouldSwapType) + ShortcutCreationTest.getIntForBoolean(!shouldSwapRef)), (int)createdShortcutA.getTargetEdges().size());
        ShortcutCreationTest.assertEquals((String)"Command that created link did not affect shortcuts", (int)(ShortcutCreationTest.getIntForBoolean(shouldSwapType) + ShortcutCreationTest.getIntForBoolean(!shouldSwapRef)), (int)createdShortcutB.getSourceEdges().size());
        ShortcutCreationTest.assertEquals((String)"Command that created link did not affect shortcuts", (int)(ShortcutCreationTest.getIntForBoolean(!shouldSwapType) + ShortcutCreationTest.getIntForBoolean(shouldSwapRef)), (int)createdShortcutA.getSourceEdges().size());
        ShortcutCreationTest.assertEquals((String)"Command that created link did not affect shortcuts", (int)(ShortcutCreationTest.getIntForBoolean(!shouldSwapType) + ShortcutCreationTest.getIntForBoolean(shouldSwapRef)), (int)createdShortcutB.getTargetEdges().size());
    }

    private static int getIntForBoolean(boolean b) {
        return b ? 1 : 0;
    }

    protected Node createShortcutNode(String modelID, View containerView, EObject underlyingModelObject) throws Exception {
        IShortcutProvider provider = ShortcutProvidersRegistry.INSTANCE.getShortcutProvider(modelID);
        ShortcutCreationTest.assertNotNull((String)"Cannot find shortcut provider", (Object)provider);
        CreateNotationalElementCommand createShortcutCommand = provider.getCreateShortcutCommand(containerView, underlyingModelObject);
        ShortcutCreationTest.assertTrue((String)("Cannot create shortcut to element " + underlyingModelObject + " on diagram " + containerView), (createShortcutCommand != null && createShortcutCommand.canExecute() ? 1 : 0) != 0);
        AbstractCanvasTest.CreateListener listener = new AbstractCanvasTest.CreateListener(NotationPackage.eINSTANCE.getNode());
        containerView.eAdapters().add((Object)listener);
        try {
            new EMFCommandOperation(TransactionUtil.getEditingDomain((EObject)containerView), (Command)createShortcutCommand).execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        finally {
            containerView.eAdapters().remove((Object)listener);
        }
        ShortcutCreationTest.assertSame((Object)createShortcutCommand.getCreatedView(), (Object)listener.getCreatedChild());
        Node createdShortcut = (Node)listener.getCreatedChild();
        ShortcutCreationTest.assertEquals((Object)EcoreUtil.getURI((EObject)underlyingModelObject), (Object)EcoreUtil.getURI((EObject)createdShortcut.getElement()));
        ShortcutCreationTest.assertSame((Object)TransactionUtil.getEditingDomain((EObject)containerView.getElement()), (Object)TransactionUtil.getEditingDomain((EObject)createdShortcut.getElement()));
        ShortcutCreationTest.assertNotNull((Object)createdShortcut.getEAnnotation("Shortcut"));
        return createdShortcut;
    }

    private View findView(View container, EObject child) {
        for (View next : container.getChildren()) {
            if (!child.equals(next.getElement())) continue;
            return next;
        }
        return null;
    }
}

