/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.lite.gef;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.codegen.gmfgen.GenColor;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenCustomFont;
import org.eclipse.gmf.codegen.gmfgen.GenDiagramPreferences;
import org.eclipse.gmf.codegen.gmfgen.GenFont;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.GenRGBColor;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class DiagramNodeTest
extends org.eclipse.gmf.tests.gef.DiagramNodeTest {
    public DiagramNodeTest(String name) {
        super(name);
    }

    public void testPreferences() throws Exception {
        GenDiagramPreferences preferences = this.getSetup().getGenModel().getGenDiagram().getPreferences();
        DiagramNodeTest.assertNotNull((String)"Wrong setup: null preferences", (Object)preferences);
        GenNode genNode = this.getSetup().getGenModel().getNodeA();
        DiagramNodeTest.assertTrue((String)"Incorrect Setup: passed node has no labels", (genNode.getLabels().size() > 0 ? 1 : 0) != 0);
        Node nodeA = this.createTopNode((GenCommonBase)genNode);
        DiagramNodeTest.assertNotNull((String)"Notation model Node was not created", (Object)nodeA);
        this.checkStyle(nodeA, NotationPackage.eINSTANCE.getFillStyle_FillColor(), preferences.getFillColor());
        this.checkStyle(nodeA, NotationPackage.eINSTANCE.getLineStyle_LineColor(), preferences.getLineColor());
        Node label = (Node)DiagramNodeTest.findChildView((View)nodeA, (GenCommonBase)((GenCommonBase)genNode.getLabels().get(0)));
        DiagramNodeTest.assertNotNull((String)"Child label not created", (Object)label);
        this.checkStyle(nodeA, NotationPackage.eINSTANCE.getFontStyle_FontColor(), preferences.getFontColor());
        this.checkFontStyle(nodeA, preferences.getDefaultFont());
        GraphicalEditPart editPartA = (GraphicalEditPart)this.findEditPart((View)nodeA);
        DiagramNodeTest.assertNotNull((Object)editPartA);
        this.checkFigureColor(editPartA.getFigure().getBackgroundColor(), NotationPackage.eINSTANCE.getFillStyle_FillColor(), preferences.getFillColor());
        this.checkFigureColor(editPartA.getFigure().getForegroundColor(), NotationPackage.eINSTANCE.getLineStyle_LineColor(), preferences.getLineColor());
        GraphicalEditPart editPartLabel = (GraphicalEditPart)this.findEditPart((View)label);
        DiagramNodeTest.assertNotNull((Object)editPartLabel);
        this.checkFigureColor(editPartLabel.getFigure().getForegroundColor(), NotationPackage.eINSTANCE.getFontStyle_FontColor(), preferences.getFontColor());
        this.checkFigureFont(editPartLabel.getFigure().getFont(), preferences.getDefaultFont());
    }

    private void checkStyle(Node node, EAttribute attribute, GenColor genColor) {
        Style style = node.getStyle(attribute.getEContainingClass());
        DiagramNodeTest.assertNotNull((Object)style);
        int color = (Integer)style.eGet((EStructuralFeature)attribute);
        int red = color & 0xFF;
        int green = (color & 0xFF00) >> 8;
        int blue = (color & 0xFF0000) >> 16;
        DiagramNodeTest.assertTrue((String)"Wrong setup: genColor is expected to be GenRGBColor", (boolean)(genColor instanceof GenRGBColor));
        GenRGBColor rgbColor = (GenRGBColor)genColor;
        DiagramNodeTest.assertEquals((String)("Wrong " + attribute.getName() + " color"), (int)rgbColor.getRed(), (int)red);
        DiagramNodeTest.assertEquals((String)("Wrong " + attribute.getName() + " color"), (int)rgbColor.getGreen(), (int)green);
        DiagramNodeTest.assertEquals((String)("Wrong " + attribute.getName() + " color"), (int)rgbColor.getBlue(), (int)blue);
    }

    private void checkFontStyle(Node label, GenFont defaultFont) {
        DiagramNodeTest.assertTrue((String)"Wrong setup: font is expected to be GenCustomFont", (boolean)(defaultFont instanceof GenCustomFont));
        GenCustomFont font = (GenCustomFont)defaultFont;
        FontStyle fontStyle = (FontStyle)label.getStyle(NotationPackage.eINSTANCE.getFontStyle());
        DiagramNodeTest.assertNotNull((Object)fontStyle);
        DiagramNodeTest.assertEquals((String)font.getName(), (String)fontStyle.getFontName());
        DiagramNodeTest.assertEquals((int)font.getHeight(), (int)fontStyle.getFontHeight());
        switch (font.getStyle()) {
            case BOLD_LITERAL: {
                DiagramNodeTest.assertTrue((boolean)fontStyle.isBold());
                DiagramNodeTest.assertFalse((boolean)fontStyle.isItalic());
                break;
            }
            case NORMAL_LITERAL: {
                DiagramNodeTest.assertFalse((boolean)fontStyle.isBold());
                DiagramNodeTest.assertFalse((boolean)fontStyle.isItalic());
                break;
            }
            case ITALIC_LITERAL: {
                DiagramNodeTest.assertFalse((boolean)fontStyle.isBold());
                DiagramNodeTest.assertTrue((boolean)fontStyle.isItalic());
                break;
            }
            default: {
                DiagramNodeTest.fail();
            }
        }
    }

    private void checkFigureColor(Color figureColor, EAttribute attribute, GenColor genColor) {
        DiagramNodeTest.assertNotNull((Object)figureColor);
        DiagramNodeTest.assertTrue((String)"Wrong setup: genColor is expected to be GenRGBColor", (boolean)(genColor instanceof GenRGBColor));
        GenRGBColor rgbColor = (GenRGBColor)genColor;
        DiagramNodeTest.assertEquals((String)("Wrong " + attribute.getName() + " color"), (int)rgbColor.getRed(), (int)figureColor.getRed());
        DiagramNodeTest.assertEquals((String)("Wrong " + attribute.getName() + " color"), (int)rgbColor.getGreen(), (int)figureColor.getGreen());
        DiagramNodeTest.assertEquals((String)("Wrong " + attribute.getName() + " color"), (int)rgbColor.getBlue(), (int)figureColor.getBlue());
    }

    private void checkFigureFont(Font font, GenFont defaultFont) {
        DiagramNodeTest.assertTrue((String)"Wrong setup: font is expected to be GenRGBColor", (boolean)(defaultFont instanceof GenCustomFont));
        GenCustomFont customFont = (GenCustomFont)defaultFont;
        FontData main = font.getFontData()[0];
        DiagramNodeTest.assertEquals((String)customFont.getName(), (String)main.getName());
        DiagramNodeTest.assertEquals((int)customFont.getHeight(), (int)main.getHeight());
        switch (customFont.getStyle()) {
            case BOLD_LITERAL: {
                DiagramNodeTest.assertEquals((int)1, (int)main.getStyle());
                break;
            }
            case NORMAL_LITERAL: {
                DiagramNodeTest.assertEquals((int)0, (int)main.getStyle());
                break;
            }
            case ITALIC_LITERAL: {
                DiagramNodeTest.assertEquals((int)2, (int)main.getStyle());
                break;
            }
            default: {
                DiagramNodeTest.fail();
            }
        }
    }
}

