/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.xpand;

import junit.framework.TestCase;
import org.eclipse.gmf.internal.xpand.BufferOutput;
import org.eclipse.gmf.internal.xpand.ResourceManager;
import org.eclipse.gmf.internal.xpand.XpandFacade;
import org.eclipse.gmf.internal.xpand.model.AmbiguousDefinitionException;
import org.eclipse.gmf.internal.xpand.model.ExecutionContext;
import org.eclipse.gmf.internal.xpand.model.ExecutionContextImpl;
import org.eclipse.gmf.internal.xpand.model.Output;
import org.eclipse.gmf.internal.xpand.model.Scope;
import org.eclipse.gmf.tests.xpand.TestsResourceManager;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;

public class PolymorphismTest
extends TestCase {
    private static final String TEMPLATE_FILE_PREFIX = "org::eclipse::gmf::tests::xpand::evaluate::Polymorphism::";
    private static final Object[] NO_PARAMS = new Object[0];
    private StringBuilder buffer;
    private XpandFacade xpandFacade;

    protected void setUp() throws Exception {
        super.setUp();
        if (QvtPlugin.getDefault() == null) {
            new QvtPlugin();
        }
        this.buffer = new StringBuilder();
        this.xpandFacade = new XpandFacade((ExecutionContext)new ExecutionContextImpl(new Scope((ResourceManager)new TestsResourceManager(), null, (Output)new BufferOutput(this.buffer))));
    }

    public void testContextualPolymorphysm() throws AmbiguousDefinitionException {
        this.checkDefinition("contextualPolymorphysm", "myString", "StringDefine");
        this.checkDefinition("contextualPolymorphysm", new Object(), "OclAnyDefine");
    }

    public void testParameterPolymorphysm() throws AmbiguousDefinitionException {
        this.checkDefinition("parameterPolymorphysm", "myString", "StringDefine");
        this.checkDefinition("parameterPolymorphysm", new Object(), "OclAnyDefine");
    }

    public void testSecondParameterPolymorphysm() throws AmbiguousDefinitionException {
        this.checkDefinition("secondParameterPolymorphysm", "myString", "StringDefine");
        this.checkDefinition("secondParameterPolymorphysm", new Object(), "OclAnyDefine");
    }

    public void checkDefinition(String definitionName, Object targetObject, String expectedResult) throws AmbiguousDefinitionException {
        this.xpandFacade.evaluate(TEMPLATE_FILE_PREFIX + definitionName, targetObject, NO_PARAMS);
        PolymorphismTest.assertEquals((String)expectedResult, (String)this.buffer.toString());
        this.buffer.delete(0, this.buffer.length());
    }
}

