/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.validate;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;

public class DynamicModelHelper {
    private static int ID = 0;

    private DynamicModelHelper() {
    }

    public static EObject createInstance(EClass eClass) {
        EFactory eFactory = eClass.getEPackage().getEFactoryInstance();
        return eFactory.create(eClass);
    }

    public static EPackage createMetaModel() {
        EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
        String suffix = DynamicModelHelper.genID();
        ePackage.setName("model_" + suffix);
        ePackage.setNsURI("http://model_" + suffix);
        ePackage.setNsPrefix("ns_" + suffix);
        return ePackage;
    }

    public static EClass createMetaClass(EPackage owningModel) {
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        owningModel.getEClassifiers().add((Object)eClass);
        String suffix = DynamicModelHelper.genID();
        eClass.setName("class_" + suffix);
        return eClass;
    }

    public static EStructuralFeature createFeature(EClass owningClass, EClassifier eType) {
        EReference eStructuralFeature = eType instanceof EClass ? EcoreFactory.eINSTANCE.createEReference() : EcoreFactory.eINSTANCE.createEAttribute();
        owningClass.getEStructuralFeatures().add((Object)eStructuralFeature);
        String suffix = DynamicModelHelper.genID();
        eStructuralFeature.setName("feature_" + suffix);
        eStructuralFeature.setEType(eType);
        return eStructuralFeature;
    }

    private static String genID() {
        return Integer.toString(ID++);
    }
}

