/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.rt;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DecorationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.DefaultNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.decorator.DecoratorService;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.EditPartService;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.ModelingAssistantService;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.ConfiguredTestCase;
import org.eclipse.gmf.tests.gen.GenDiagramMutator;
import org.eclipse.gmf.tests.setup.GenProjectSetup;
import org.eclipse.gmf.tests.setup.RuntimeBasedGeneratorConfiguration;
import org.eclipse.gmf.tests.setup.SessionSetup;
import org.osgi.framework.BundleException;

public class BundleActivationTest
extends ConfiguredTestCase {
    private final PreferencesHint prefHint = new PreferencesHint("a.b.c");
    public static final SessionSetup setup = new SessionSetup(new RuntimeBasedGeneratorConfiguration()){

        protected GenProjectSetup createGenProject() throws BundleException {
            return new GenProjectSetup(this.getGeneratorConfiguration()){

                public GenProjectSetup init(GenEditorGenerator genEditor) throws BundleException {
                    try {
                        int vid = 65536;
                        LinkedList<GenDiagram> vidHolders = new LinkedList<GenDiagram>();
                        vidHolders.add(genEditor.getDiagram());
                        vidHolders.addAll((Collection<GenDiagram>)genEditor.getDiagram().getTopLevelNodes());
                        vidHolders.addAll((Collection<GenDiagram>)genEditor.getDiagram().getChildNodes());
                        vidHolders.addAll((Collection<GenDiagram>)genEditor.getDiagram().getCompartments());
                        vidHolders.addAll((Collection<GenDiagram>)genEditor.getDiagram().getLinks());
                        for (GenNode genNode : genEditor.getDiagram().getAllNodes()) {
                            vidHolders.addAll((Collection<GenDiagram>)genNode.getLabels());
                        }
                        for (GenLink genLink : genEditor.getDiagram().getLinks()) {
                            vidHolders.addAll((Collection<GenDiagram>)genLink.getLabels());
                        }
                        for (GenCommonBase genCommonBase : vidHolders) {
                            genCommonBase.setVisualID(vid++);
                        }
                        genEditor.getDiagram().getShortcutsProvidedFor().add((Object)genEditor.getModelID());
                        this.generateAndCompile(genEditor, new GenDiagramMutator[0]);
                        this.getBundle().start(3);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                    return this;
                }
            }.init(this.getGenModel());
        }
    };

    public BundleActivationTest(String name) {
        super(name);
        this.configure(setup);
    }

    private void assertBundleNotStarted(String msg) throws Exception {
        BundleActivationTest.assertNotSame((String)msg, (Object)32, (Object)this.getSetup().getGeneratedPlugin().getState());
    }

    public void testViewService() throws Exception {
        this.assertBundleNotStarted("[sanity]");
        Diagram d = NotationFactory.eINSTANCE.createDiagram();
        ViewService.createNode((View)d, (String)"a-hint", (PreferencesHint)this.prefHint);
        this.assertBundleNotStarted("View creation should not trigger generated ViewProvider and plugin activation");
        Node n = NotationFactory.eINSTANCE.createNode();
        EList children = d.getTransientChildren();
        children.add((Object)n);
        ViewService.createEdge((View)d, (View)n, (String)"b-hint", (PreferencesHint)this.prefHint);
        this.assertBundleNotStarted("View creation should not trigger generated ViewProvider and plugin activation");
    }

    public void testEditPartService() throws Exception {
        this.assertBundleNotStarted("[sanity]");
        Diagram d = NotationFactory.eINSTANCE.createDiagram();
        RootEditPart p = EditPartService.getInstance().createRootEditPart(d);
        BundleActivationTest.assertNotNull((Object)p);
        this.assertBundleNotStarted("RootEditPart");
        Node n = NotationFactory.eINSTANCE.createNode();
        IGraphicalEditPart ep = EditPartService.getInstance().createGraphicEditPart((View)n);
        BundleActivationTest.assertNotNull((Object)ep);
        this.assertBundleNotStarted("Regular EditPart");
    }

    public void testDecoratorService() throws Exception {
        BundleActivationTest.assertTrue((String)"[sanity]", (boolean)this.getSetup().getGenModel().getGenDiagram().generateShortcutIcon());
        this.assertBundleNotStarted("[sanity]");
        DecorationEditPolicy.DecoratorTarget dt = new DecorationEditPolicy.DecoratorTarget(new DecorationEditPolicy());
        DecoratorService dp = DecoratorService.getInstance();
        dp.createDecorators((IDecoratorTarget)dt);
        this.assertBundleNotStarted("DecoratorService");
    }

    public void testModelAssistantService() throws Exception {
        this.assertBundleNotStarted("[sanity]");
        DefaultNodeEditPart ep = new DefaultNodeEditPart((View)NotationFactory.eINSTANCE.createNode());
        ModelingAssistantService.getInstance().getTypesForPopupBar((IAdaptable)ep);
        this.assertBundleNotStarted("ModelAssistantService#getTypesForPopupBar(EditPart)");
    }
}

