/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.codeassist;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.gmf.internal.xpand.editor.EditorImages;
import org.eclipse.gmf.internal.xpand.expression.codeassist.ProposalFactory;
import org.eclipse.gmf.internal.xpand.xtend.ast.GenericExtension;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.internal.OCLFactoryImpl;
import org.eclipse.ocl.ecore.internal.UMLReflectionImpl;
import org.eclipse.ocl.lpg.AbstractFormattingHelper;
import org.eclipse.ocl.util.ObjectUtil;
import org.eclipse.swt.graphics.Image;

public class ProposalFactoryImpl
implements ProposalFactory {
    protected final int offset;
    private final EditorImages editorImages;
    private final int selectionLen;

    public ProposalFactoryImpl(int offset, int selectionLen, EditorImages images) {
        this.offset = offset;
        assert (selectionLen >= 0);
        this.selectionLen = selectionLen;
        this.editorImages = images;
    }

    public ICompletionProposal createCollectionSpecificOperationProposal(String insertString, String displayString, String prefix, int cursor, int marked) {
        return new CompletionProposal(insertString, this.offset - prefix.length(), prefix.length() + this.selectionLen, cursor, this.editorImages.getOperation(), displayString, null, null);
    }

    public ICompletionProposal createPropertyProposal(EStructuralFeature p, String prefix, boolean onCollection) {
        String returnType = this.computeReturnType((ETypedElement)p, onCollection);
        String displayStr = String.valueOf(p.getName()) + " " + returnType + " - " + p.getEContainingClass().getName();
        String insertStr = p.getName();
        return new CompletionProposal(insertStr, this.offset - prefix.length(), prefix.length() + this.selectionLen, insertStr.length(), this.editorImages.getProperty(), displayStr, null, null);
    }

    private String computeReturnType(ETypedElement returnType, boolean onCollection) {
        EClassifier t = UMLReflectionImpl.INSTANCE.getOCLType((Object)returnType);
        if (onCollection) {
            if (t instanceof CollectionType) {
                EClassifier temp = t;
                t = (EClassifier)((CollectionType)t).getElementType();
                ObjectUtil.dispose((Object)temp);
            }
            t = (EClassifier)OCLFactoryImpl.INSTANCE.createSequenceType((Object)t);
        }
        return ProposalFactoryImpl.getTypeName(t);
    }

    public ICompletionProposal createOperationProposal(EOperation p, String prefix, boolean onCollection) {
        StringBuilder displayStr = new StringBuilder();
        displayStr.append(p.getName());
        displayStr.append(ProposalFactoryImpl.toParamString(p));
        displayStr.append(" ");
        displayStr.append(this.computeReturnType((ETypedElement)p, onCollection));
        if (p.getEContainingClass() != null) {
            displayStr.append(" - ");
            displayStr.append(ProposalFactoryImpl.getTypeName((EClassifier)p.getEContainingClass()));
        }
        String insertStr = String.valueOf(p.getName()) + "()";
        int x = insertStr.length();
        if (p.getEParameters().size() > 0) {
            --x;
        }
        Image img = this.editorImages.getOperation();
        return new CompletionProposal(insertStr, this.offset - prefix.length(), prefix.length() + this.selectionLen, x, img, displayStr.toString(), null, null);
    }

    public ICompletionProposal createExtensionProposal(GenericExtension p, String prefix) {
        String displayStr = String.valueOf(p.getName()) + ProposalFactoryImpl.toParamString(p, false) + " - " + p.getFileName();
        String insertStr = String.valueOf(p.getName()) + "()";
        int x = insertStr.length();
        if (p.getParameterNames().size() > 0) {
            --x;
        }
        return new CompletionProposal(insertStr, this.offset - prefix.length(), prefix.length() + this.selectionLen, x, this.editorImages.getExtension(), displayStr, null, null);
    }

    public ICompletionProposal createExtensionOnMemberPositionProposal(GenericExtension p, String prefix, boolean onOperation) {
        String displayStr = String.valueOf(p.getName()) + ProposalFactoryImpl.toParamString(p, true) + " - " + ProposalFactoryImpl.getTypeName((EClassifier)p.getParameterTypes().get(0));
        String insertStr = String.valueOf(p.getName()) + "()";
        int x = insertStr.length();
        if (p.getParameterNames().size() > 1) {
            --x;
        }
        Image img = this.editorImages.getExtension();
        return new CompletionProposal(insertStr, this.offset - prefix.length(), prefix.length() + this.selectionLen, x, img, displayStr, null, null);
    }

    private static String toParamString(EOperation op) {
        StringBuilder b = new StringBuilder("(");
        EList params = op.getEParameters();
        int i = 0;
        int x = params.size();
        while (i < x) {
            b.append(ProposalFactoryImpl.getTypeName(((EParameter)params.get(i)).getEType()));
            if (i + 1 < x) {
                b.append(",");
            }
            ++i;
        }
        b.append(")");
        return b.toString();
    }

    private static String toParamString(GenericExtension p, boolean member) {
        StringBuilder b = new StringBuilder("(");
        int i = member ? 1 : 0;
        List parameterNames = p.getParameterNames();
        List parameterTypes = p.getParameterTypes();
        int x = parameterNames.size();
        while (i < x) {
            b.append(parameterTypes.size() < x ? ProposalFactoryImpl.getTypeName((EClassifier)parameterTypes.get(x)) : "?");
            b.append(" ");
            b.append((String)parameterNames.get(x));
            if (i + 1 < x) {
                b.append(",");
            }
            ++i;
        }
        b.append(")");
        return b.toString();
    }

    private static String getTypeName(EClassifier classifier) {
        return AbstractFormattingHelper.INSTANCE.formatType((Object)classifier);
    }

    public ICompletionProposal createVariableProposal(String varName, String typeName, String prefix) {
        String displayStr = String.valueOf(varName) + " " + typeName;
        String insertStr = varName;
        return new CompletionProposal(insertStr, this.offset - prefix.length(), prefix.length() + this.selectionLen, insertStr.length(), this.editorImages.getVariable(), displayStr, null, null);
    }

    public ICompletionProposal createTypeProposal(String insertStr, String displayStr, String prefix) {
        return new CompletionProposal(insertStr, this.offset - prefix.length(), prefix.length() + this.selectionLen, insertStr.length(), this.editorImages.getType(), displayStr, null, null);
    }

    public ICompletionProposal createStatementProposal(String insertString, String displayString, int cursor, int marked) {
        return new CompletionProposal(insertString, this.offset, this.selectionLen, cursor, this.editorImages.getStatement(), displayString, null, null);
    }

    public ICompletionProposal createStatementProposal(String insertString, String displayString) {
        return this.createStatementProposal(insertString, displayString, insertString.length(), 0);
    }

    public ICompletionProposal createKeywordProposal(String insertString, String displayString, String prefix) {
        return new CompletionProposal(insertString, this.offset - prefix.length(), prefix.length() + this.selectionLen, insertString.length());
    }
}

