/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editpolicies;

import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IInsertableEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.SemanticListCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.diagram.ui.requests.GroupRequestViaKeyboard;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ComponentEditPolicy
extends org.eclipse.gef.editpolicies.ComponentEditPolicy {
    private static final String DELETE_FROM_DIAGRAM_DLG_TITLE = DiagramUIMessages.PromptingDeleteAction_DeleteFromDiagramDialog_Title;
    private static final String DELETE_FROM_DIAGRAM_DLG_MESSAGE = DiagramUIMessages.PromptingDeleteAction_DeleteFromDiagramDialog_Message;
    private static final String DELETE_FROM_MODEL_DLG_TOGGLE_LABEL = DiagramUIMessages.MessageDialogWithToggle_DoNotPromptAgainToggle_label;

    protected final Command createDeleteCommand(GroupRequest deleteRequest) {
        boolean shouldShowPrompt;
        if (this.shouldDeleteSemantic()) {
            return this.createDeleteSemanticCommand(deleteRequest);
        }
        if (deleteRequest instanceof GroupRequestViaKeyboard && (shouldShowPrompt = ((GroupRequestViaKeyboard)deleteRequest).isShowInformationDialog())) {
            ((GroupRequestViaKeyboard)deleteRequest).setShowInformationDialog(false);
            if (!this.showPrompt()) {
                return UnexecutableCommand.INSTANCE;
            }
        }
        return this.createDeleteViewCommand(deleteRequest);
    }

    protected boolean shouldDeleteSemantic() {
        CanonicalEditPolicy cep;
        EditPart parent = this.getHost().getParent();
        if (parent instanceof SemanticListCompartmentEditPart) {
            SemanticListCompartmentEditPart semListCompartment = (SemanticListCompartmentEditPart)parent;
            return semListCompartment.isCanonicalOn();
        }
        if (parent instanceof IGraphicalEditPart && (cep = (CanonicalEditPolicy)parent.getEditPolicy((Object)"Canonical")) != null) {
            return cep.isEnabled();
        }
        return false;
    }

    protected Command createDeleteViewCommand(GroupRequest deleteRequest) {
        CompositeCommand cc = new CompositeCommand(null);
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        if (editingDomain == null) {
            return null;
        }
        List toDel = deleteRequest.getEditParts();
        if (toDel == null || toDel.isEmpty()) {
            cc.compose((IUndoableOperation)new DeleteCommand(editingDomain, (View)this.getHost().getModel()));
        } else {
            int i = 0;
            while (i < toDel.size()) {
                IGraphicalEditPart gep = (IGraphicalEditPart)toDel.get(i);
                cc.compose((IUndoableOperation)new DeleteCommand(editingDomain, (View)gep.getModel()));
                ++i;
            }
        }
        return new ICommandProxy(cc.reduce());
    }

    protected Command createDeleteSemanticCommand(GroupRequest deleteRequest) {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        boolean shouldShowPrompt = deleteRequest instanceof GroupRequestViaKeyboard ? ((GroupRequestViaKeyboard)deleteRequest).isShowInformationDialog() : false;
        EditCommandRequestWrapper editCommandRequest = new EditCommandRequestWrapper((IEditCommandRequest)new DestroyElementRequest(editingDomain, shouldShowPrompt), deleteRequest.getExtendedData());
        Command semanticCmd = this.getHost().getCommand((Request)editCommandRequest);
        if (semanticCmd != null && semanticCmd.canExecute()) {
            CompoundCommand cc = new CompoundCommand();
            cc.add(semanticCmd);
            return cc;
        }
        return this.createDeleteViewCommand(deleteRequest);
    }

    protected View getView() {
        if (this.getHost().getModel() instanceof View && this.getHost() instanceof GraphicalEditPart) {
            GraphicalEditPart ePart = (GraphicalEditPart)this.getHost();
            return ePart.getPrimaryView();
        }
        return null;
    }

    private boolean showPrompt() {
        boolean prompt = ((IPreferenceStore)((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint().getPreferenceStore()).getBoolean("Global.promptOnDelFromDiagram");
        if (prompt) {
            return this.showMessageDialog();
        }
        return true;
    }

    private boolean showMessageDialog() {
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)Display.getCurrent().getActiveShell(), (String)DELETE_FROM_DIAGRAM_DLG_TITLE, (String)DELETE_FROM_DIAGRAM_DLG_MESSAGE, (String)DELETE_FROM_MODEL_DLG_TOGGLE_LABEL, (boolean)false, (IPreferenceStore)((IPreferenceStore)((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint().getPreferenceStore()), (String)"Global.promptOnDelFromDiagram");
        return dialog.getReturnCode() == 2;
    }

    protected IInsertableEditPart getInsertableEditPart() {
        if (this.getHost() instanceof IInsertableEditPart) {
            return (IInsertableEditPart)this.getHost();
        }
        return null;
    }

    protected Command getInsertCommand(GroupRequest insertRequest) {
        IInsertableEditPart insertEP = this.getInsertableEditPart();
        if (insertEP == null) {
            return null;
        }
        EObject hostElement = ViewUtil.resolveSemanticElement((View)((View)insertEP.getModel()));
        if (hostElement != null) {
            TransactionalEditingDomain editingDomain = this.getEditingDomain();
            if (editingDomain == null) {
                return null;
            }
            CreateElementRequest theReq = new CreateElementRequest(editingDomain, hostElement, insertEP.getElementType());
            EditCommandRequestWrapper editCommandRequest = new EditCommandRequestWrapper((IEditCommandRequest)theReq, insertRequest.getExtendedData());
            Command cmd = ((IGraphicalEditPart)this.getHost()).getCommand(editCommandRequest);
            return cmd;
        }
        return null;
    }

    public Command getCommand(Request request) {
        if (!(request instanceof GroupRequest)) {
            return null;
        }
        GroupRequest grpRequest = (GroupRequest)request;
        if (grpRequest instanceof GroupRequestViaKeyboard) {
            return this.getDeleteCommand(grpRequest);
        }
        if (grpRequest.getType().equals("insert_semantic")) {
            return this.getInsertCommand(grpRequest);
        }
        return super.getCommand(request);
    }

    private TransactionalEditingDomain getEditingDomain() {
        EditingDomain domain;
        if (this.getHost() instanceof IGraphicalEditPart) {
            return ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        }
        if (this.getHost() instanceof IEditingDomainProvider && (domain = ((IEditingDomainProvider)this.getHost()).getEditingDomain()) instanceof TransactionalEditingDomain) {
            return (TransactionalEditingDomain)domain;
        }
        return null;
    }
}

