/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gen;

import java.util.Iterator;
import org.eclipse.gmf.gmfgraph.BasicFont;
import org.eclipse.gmf.gmfgraph.Border;
import org.eclipse.gmf.gmfgraph.Color;
import org.eclipse.gmf.gmfgraph.ColorConstants;
import org.eclipse.gmf.gmfgraph.CompoundBorder;
import org.eclipse.gmf.gmfgraph.Dimension;
import org.eclipse.gmf.gmfgraph.Ellipse;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.Font;
import org.eclipse.gmf.gmfgraph.FontStyle;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.Insets;
import org.eclipse.gmf.gmfgraph.LineBorder;
import org.eclipse.gmf.gmfgraph.LineKind;
import org.eclipse.gmf.gmfgraph.MarginBorder;
import org.eclipse.gmf.gmfgraph.Rectangle;
import org.eclipse.gmf.gmfgraph.RoundedRectangle;
import org.eclipse.gmf.tests.gen.FigureCodegenTestBase;

public class ShapePropertiesTest
extends FigureCodegenTestBase {
    public ShapePropertiesTest(String name) {
        super(name);
    }

    public void testShapeLineStyle() {
        Rectangle container = GMFGraphFactory.eINSTANCE.createRectangle();
        container.setName("Container");
        Iterator kinds = LineKind.VALUES.iterator();
        while (kinds.hasNext()) {
            LineKind next = (LineKind)kinds.next();
            Ellipse shape = GMFGraphFactory.eINSTANCE.createEllipse();
            shape.setName("Ellipse_" + next.getLiteral());
            shape.setLineKind(next);
            container.getChildren().add((Object)shape);
        }
        this.performTests((Figure)container);
    }

    public void testShapeLineWidth() {
        RoundedRectangle shape = GMFGraphFactory.eINSTANCE.createRoundedRectangle();
        shape.setLineWidth(23);
        shape.setName("Bold");
        this.performTests((Figure)shape);
    }

    public void testShapeFont() {
        RoundedRectangle shape = GMFGraphFactory.eINSTANCE.createRoundedRectangle();
        shape.setName("WithArialFont");
        shape.setFont(ShapePropertiesTest.createBasicFont("Arial", 10, FontStyle.NORMAL_LITERAL));
        this.performTests((Figure)shape);
    }

    public void testShapeInsets() {
        Rectangle withInsets = GMFGraphFactory.eINSTANCE.createRectangle();
        withInsets.setName("WithInsets");
        Insets insets = GMFGraphFactory.eINSTANCE.createInsets();
        insets.setBottom(23);
        insets.setTop(34);
        insets.setRight(45);
        insets.setLeft(56);
        withInsets.setInsets(insets);
        this.performTests((Figure)withInsets);
    }

    public void testLineBorder() {
        Rectangle container = GMFGraphFactory.eINSTANCE.createRectangle();
        container.setName("Root");
        Rectangle colorAndWidth = GMFGraphFactory.eINSTANCE.createRectangle();
        colorAndWidth.setName("ColorAndWidth");
        LineBorder colorAndWidthBorder = GMFGraphFactory.eINSTANCE.createLineBorder();
        colorAndWidthBorder.setColor((Color)ShapePropertiesTest.createConstantColor(ColorConstants.CYAN_LITERAL));
        colorAndWidthBorder.setWidth(23);
        colorAndWidth.setBorder((Border)colorAndWidthBorder);
        Rectangle onlyColor = GMFGraphFactory.eINSTANCE.createRectangle();
        onlyColor.setName("OnlyColor");
        LineBorder onlyColorBorder = GMFGraphFactory.eINSTANCE.createLineBorder();
        onlyColorBorder.setColor((Color)ShapePropertiesTest.createConstantColor(ColorConstants.CYAN_LITERAL));
        onlyColor.setBorder((Border)onlyColorBorder);
        Rectangle onlyWidth = GMFGraphFactory.eINSTANCE.createRectangle();
        onlyWidth.setName("OnlyWidth");
        LineBorder onlyWidthBorder = GMFGraphFactory.eINSTANCE.createLineBorder();
        onlyWidthBorder.setWidth(34);
        onlyWidth.setBorder((Border)onlyWidthBorder);
        Rectangle empty = GMFGraphFactory.eINSTANCE.createRectangle();
        empty.setName("Empty");
        LineBorder emptyBorder = GMFGraphFactory.eINSTANCE.createLineBorder();
        empty.setBorder((Border)emptyBorder);
        container.getChildren().add((Object)colorAndWidth);
        container.getChildren().add((Object)onlyColor);
        container.getChildren().add((Object)onlyWidth);
        container.getChildren().add((Object)empty);
        this.performTests((Figure)container);
    }

    public void testCompoundBorder() {
        LineBorder outerOuter = GMFGraphFactory.eINSTANCE.createLineBorder();
        outerOuter.setColor((Color)ShapePropertiesTest.createConstantColor(ColorConstants.BLUE_LITERAL));
        outerOuter.setWidth(22);
        MarginBorder outerInner = GMFGraphFactory.eINSTANCE.createMarginBorder();
        outerInner.setInsets(GMFGraphFactory.eINSTANCE.createInsets());
        outerInner.getInsets().setBottom(23);
        outerInner.getInsets().setTop(34);
        CompoundBorder outer = GMFGraphFactory.eINSTANCE.createCompoundBorder();
        outer.setOuter((Border)outerOuter);
        outer.setInner((Border)outerInner);
        CompoundBorder innerEmpty = GMFGraphFactory.eINSTANCE.createCompoundBorder();
        innerEmpty.setInner(null);
        innerEmpty.setOuter(null);
        CompoundBorder result = GMFGraphFactory.eINSTANCE.createCompoundBorder();
        result.setOuter((Border)outer);
        result.setInner((Border)innerEmpty);
        Rectangle tester = GMFGraphFactory.eINSTANCE.createRectangle();
        tester.setBorder((Border)result);
        tester.setName("Tester");
        this.performTests((Figure)tester);
    }

    public void testMarginBorder() {
        MarginBorder border = GMFGraphFactory.eINSTANCE.createMarginBorder();
        border.setInsets(GMFGraphFactory.eINSTANCE.createInsets());
        border.getInsets().setBottom(23);
        border.getInsets().setTop(34);
        border.getInsets().setRight(45);
        border.getInsets().setLeft(56);
        Ellipse marginTester = GMFGraphFactory.eINSTANCE.createEllipse();
        marginTester.setBorder((Border)border);
        marginTester.setName("MarginTester");
        this.performTests((Figure)marginTester);
    }

    public void testConstantColors() {
        Rectangle rainbow = GMFGraphFactory.eINSTANCE.createRectangle();
        rainbow.setName("Rainbow");
        Iterator colors = ColorConstants.VALUES.iterator();
        while (colors.hasNext()) {
            ColorConstants next = (ColorConstants)colors.next();
            Rectangle nextColored = GMFGraphFactory.eINSTANCE.createRectangle();
            nextColored.setName(next.getLiteral());
            nextColored.setBackgroundColor((Color)ShapePropertiesTest.createConstantColor(next));
            rainbow.getChildren().add((Object)nextColored);
        }
        this.performTests((Figure)rainbow);
    }

    public void testMaxAndMinSize() {
        RoundedRectangle withMinAndMaxSize = GMFGraphFactory.eINSTANCE.createRoundedRectangle();
        withMinAndMaxSize.setName("WithMinAndMaxSize");
        withMinAndMaxSize.setMaximumSize(this.createDimension(1000, 2000));
        withMinAndMaxSize.setMinimumSize(this.createDimension(234, 123));
        this.performTests((Figure)withMinAndMaxSize);
    }

    public void testDefaultFontName() {
        Rectangle noFontName = GMFGraphFactory.eINSTANCE.createRectangle();
        noFontName.setName("NoFontName");
        BasicFont noName = GMFGraphFactory.eINSTANCE.createBasicFont();
        noFontName.setFont((Font)noName);
        Rectangle emptyFontName = GMFGraphFactory.eINSTANCE.createRectangle();
        emptyFontName.setName("EmptyFontName");
        BasicFont emptyName = GMFGraphFactory.eINSTANCE.createBasicFont();
        emptyName.setFaceName("");
        emptyFontName.setFont((Font)emptyName);
        Rectangle root = GMFGraphFactory.eINSTANCE.createRectangle();
        root.setName("Root");
        root.getChildren().add((Object)emptyFontName);
        root.getChildren().add((Object)noFontName);
        this.performTests((Figure)root);
    }

    private Dimension createDimension(int x, int y) {
        Dimension result = GMFGraphFactory.eINSTANCE.createDimension();
        result.setDx(x);
        result.setDy(y);
        return result;
    }
}

