/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.setup;

import java.net.MalformedURLException;
import junit.framework.Assert;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.gmf.tests.Plugin;
import org.eclipse.gmf.tests.setup.DiaGenSource;
import org.eclipse.gmf.tests.setup.GenProjectBaseSetup;
import org.eclipse.gmf.tests.setup.GeneratorConfiguration;
import org.eclipse.gmf.tests.setup.RuntimeWorkspaceSetup;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.util.tracker.ServiceTracker;

public class GenProjectSetup
extends GenProjectBaseSetup {
    private Bundle myBundle;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.tests.setup.GenProjectSetup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public GenProjectSetup(GeneratorConfiguration generatorFactory) {
        super(generatorFactory);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GenProjectSetup init(RuntimeWorkspaceSetup rtWorkspace, DiaGenSource diaGenSource) throws BundleException {
        final boolean[] extensionChangeNotification = new boolean[]{true};
        IRegistryChangeListener listener = new IRegistryChangeListener(){

            public void registryChanged(IRegistryChangeEvent event) {
                extensionChangeNotification[0] = false;
            }
        };
        try {
            try {
                RegistryFactory.getRegistry().addRegistryChangeListener(listener, "org.eclipse.gmf.runtime.emf.type.core");
                this.myBundle = null;
                super.generateAndCompile(rtWorkspace, diaGenSource);
                this.myBundle.start();
                this.monitorExtensionLoad(extensionChangeNotification, 60);
                this.disabledNoExprImplDebugOption();
            }
            catch (BundleException ex) {
                throw ex;
            }
            catch (Exception ex) {
                Assert.fail((String)ex.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            RegistryFactory.getRegistry().removeRegistryChangeListener(listener);
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        RegistryFactory.getRegistry().removeRegistryChangeListener(listener);
        return this;
    }

    private void monitorExtensionLoad(boolean[] flag, int timeoutSeconds) {
        if (Display.getCurrent() != null) {
            long start = System.currentTimeMillis();
            long deltaMillis = timeoutSeconds * 1000;
            while (Display.getCurrent().readAndDispatch() || flag[0] && System.currentTimeMillis() - start < deltaMillis) {
            }
            if (flag[0]) {
                Plugin.logError("Timeout while waiting for extension point registry to refresh !!!");
            }
        }
    }

    protected void hookProjectBuild(IProject p) throws Exception {
        super.hookProjectBuild(p);
        try {
            String url = p.getLocation().toFile().toURL().toExternalForm();
            this.myBundle = Plugin.getBundleContext().installBundle(url);
        }
        catch (MalformedURLException ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    public final Bundle getBundle() {
        if (!$assertionsDisabled && this.myBundle == null) {
            throw new AssertionError((Object)"GenProjectSetup was not initialized");
        }
        return this.myBundle;
    }

    public void uninstall() throws Exception {
        this.myBundle.uninstall();
    }

    private void disabledNoExprImplDebugOption() {
        String disabledNoExprImplDebugOpt = Platform.getDebugOption((String)(String.valueOf(Plugin.getInstance().getBundle().getSymbolicName()) + "/disableNoExprImplExceptionLog"));
        if (disabledNoExprImplDebugOpt != null) {
            BundleContext bundleContext = Plugin.getBundleContext();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.osgi.service.debug.DebugOptions");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ServiceTracker debugTracker = new ServiceTracker(bundleContext, clazz.getName(), null);
            debugTracker.open();
            DebugOptions debugOptions = (DebugOptions)debugTracker.getService();
            if (debugOptions != null) {
                debugOptions.setOption(String.valueOf(this.getBundle().getSymbolicName()) + "/debug/disableNoExprImplExceptionLog", disabledNoExprImplDebugOpt);
            }
            debugTracker.close();
        }
    }
}

