/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.editor.edit.policies;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.gmfgraph.Canvas;
import org.eclipse.gmf.gmfgraph.DiagramElement;
import org.eclipse.gmf.gmfgraph.FigureHandle;
import org.eclipse.gmf.gmfgraph.GMFGraphPackage;
import org.eclipse.gmf.graphdef.editor.part.GMFGraphVisualIDRegistry;
import org.eclipse.gmf.graphdef.editor.providers.GMFGraphElementTypes;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetViewMutabilityCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalConnectionEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;

public class CanvasCanonicalEditPolicy
extends CanonicalConnectionEditPolicy {
    private Collection myLinkDescriptors = new LinkedList();
    private Map myEObject2ViewMap = new HashMap();

    protected List getSemanticChildrenList() {
        int nodeVID;
        EObject nextValue;
        LinkedList<EObject> result = new LinkedList<EObject>();
        EObject modelObject = ((View)this.getHost().getModel()).getElement();
        View viewObject = (View)this.getHost().getModel();
        Iterator values = ((Canvas)modelObject).getCompartments().iterator();
        while (values.hasNext()) {
            nextValue = (EObject)values.next();
            nodeVID = GMFGraphVisualIDRegistry.getNodeVisualID(viewObject, nextValue);
            if (2001 != nodeVID) continue;
            result.add(nextValue);
        }
        values = ((Canvas)modelObject).getNodes().iterator();
        while (values.hasNext()) {
            nextValue = (EObject)values.next();
            nodeVID = GMFGraphVisualIDRegistry.getNodeVisualID(viewObject, nextValue);
            if (2002 != nodeVID) continue;
            result.add(nextValue);
        }
        values = ((Canvas)modelObject).getConnections().iterator();
        while (values.hasNext()) {
            nextValue = (EObject)values.next();
            nodeVID = GMFGraphVisualIDRegistry.getNodeVisualID(viewObject, nextValue);
            if (2003 != nodeVID) continue;
            result.add(nextValue);
        }
        values = ((Canvas)modelObject).getFigures().iterator();
        while (values.hasNext()) {
            nextValue = (EObject)values.next();
            nodeVID = GMFGraphVisualIDRegistry.getNodeVisualID(viewObject, nextValue);
            if (2004 != nodeVID) continue;
            result.add(nextValue);
        }
        return result;
    }

    protected boolean shouldDeleteView(View view) {
        return view.isSetElement() && view.getElement() != null && view.getElement().eIsProxy();
    }

    protected String getDefaultFactoryHint() {
        return null;
    }

    protected List getSemanticConnectionsList() {
        return Collections.EMPTY_LIST;
    }

    protected EObject getSourceElement(EObject relationship) {
        return null;
    }

    protected EObject getTargetElement(EObject relationship) {
        return null;
    }

    protected boolean shouldIncludeConnection(Edge connector, Collection children) {
        return false;
    }

    protected void refreshSemantic() {
        super.refreshSemantic();
        this.refreshConnections();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void refreshConnections() {
        try {
            this.collectAllLinks((View)this.getDiagram());
            LinkedList existingLinks = new LinkedList(this.getDiagram().getEdges());
            Iterator diagramLinks = existingLinks.iterator();
            block3: while (true) {
                block5: {
                    if (diagramLinks.hasNext()) break block5;
                    this.deleteViews(existingLinks.iterator());
                    this.createConnections(this.myLinkDescriptors);
                    break;
                }
                Edge nextDiagramLink = (Edge)diagramLinks.next();
                EObject diagramLinkObject = nextDiagramLink.getElement();
                EObject diagramLinkSrc = nextDiagramLink.getSource().getElement();
                EObject diagramLinkDst = nextDiagramLink.getTarget().getElement();
                int diagramLinkVisualID = GMFGraphVisualIDRegistry.getVisualID((View)nextDiagramLink);
                Iterator modelLinkDescriptors = this.myLinkDescriptors.iterator();
                while (true) {
                    if (!modelLinkDescriptors.hasNext()) continue block3;
                    LinkDescriptor nextLinkDescriptor = (LinkDescriptor)modelLinkDescriptors.next();
                    if (diagramLinkObject != nextLinkDescriptor.getLinkElement() || diagramLinkSrc != nextLinkDescriptor.getSource() || diagramLinkDst != nextLinkDescriptor.getDestination() || diagramLinkVisualID != nextLinkDescriptor.getVisualID()) continue;
                    diagramLinks.remove();
                    modelLinkDescriptors.remove();
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.myLinkDescriptors.clear();
            this.myEObject2ViewMap.clear();
            throw throwable;
        }
        {
            Object var10_12 = null;
            this.myLinkDescriptors.clear();
            this.myEObject2ViewMap.clear();
            return;
        }
    }

    private void collectAllLinks(View view) {
        EObject modelElement = view.getElement();
        int diagramElementVisualID = GMFGraphVisualIDRegistry.getVisualID(view);
        switch (diagramElementVisualID) {
            case 1000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 3001: 
            case 3002: 
            case 3003: 
            case 3004: 
            case 3005: 
            case 3006: 
            case 3007: 
            case 3008: {
                this.myEObject2ViewMap.put(modelElement, view);
                this.storeLinks(modelElement, this.getDiagram());
            }
        }
        Iterator children = view.getChildren().iterator();
        while (children.hasNext()) {
            View childView = (View)children.next();
            this.collectAllLinks(childView);
        }
    }

    private void createConnections(Collection linkDescriptors) {
        if (linkDescriptors.isEmpty()) {
            return;
        }
        Iterator linkDescriptorsIterator = linkDescriptors.iterator();
        while (linkDescriptorsIterator.hasNext()) {
            LinkDescriptor nextLinkDescriptor = (LinkDescriptor)linkDescriptorsIterator.next();
            EditPart sourceEditPart = this.getEditPartFor(nextLinkDescriptor.getSource());
            EditPart targetEditPart = this.getEditPartFor(nextLinkDescriptor.getDestination());
            if (sourceEditPart == null || targetEditPart == null) continue;
            CreateConnectionViewRequest.ConnectionViewDescriptor descriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor(nextLinkDescriptor.getSemanticAdapter(), null, -1, false, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
            CreateConnectionViewRequest ccr = new CreateConnectionViewRequest(descriptor);
            ccr.setType((Object)"connection start");
            ccr.setSourceEditPart(sourceEditPart);
            sourceEditPart.getCommand((Request)ccr);
            ccr.setTargetEditPart(targetEditPart);
            ccr.setType((Object)"connection end");
            Command cmd = targetEditPart.getCommand((Request)ccr);
            if (cmd == null || !cmd.canExecute()) continue;
            this.executeCommand(cmd);
            IAdaptable viewAdapter = (IAdaptable)ccr.getNewObject();
            SetViewMutabilityCommand.makeImmutable((IAdaptable)viewAdapter).execute();
        }
    }

    private EditPart getEditPartFor(EObject modelElement) {
        View view = (View)this.myEObject2ViewMap.get(modelElement);
        if (view != null) {
            return (EditPart)this.getHost().getViewer().getEditPartRegistry().get(view);
        }
        return null;
    }

    private void storeLinks(EObject container, Diagram diagram) {
        EClass containerMetaclass = container.eClass();
        this.storeFeatureModelFacetLinks(container, containerMetaclass, diagram);
        this.storeTypeModelFacetLinks(container, containerMetaclass);
    }

    private void storeTypeModelFacetLinks(EObject container, EClass containerMetaclass) {
    }

    private void storeFeatureModelFacetLinks(EObject container, EClass containerMetaclass, Diagram diagram) {
        if (GMFGraphPackage.eINSTANCE.getDiagramElement().isSuperTypeOf(containerMetaclass)) {
            FigureHandle nextDestination = ((DiagramElement)container).getFigure();
            this.myLinkDescriptors.add(new LinkDescriptor(container, (EObject)nextDestination, GMFGraphElementTypes.DiagramElementFigure_4001, 4001));
        }
    }

    private Diagram getDiagram() {
        return ((View)this.getHost().getModel()).getDiagram();
    }

    private class LinkDescriptor {
        private EObject mySource;
        private EObject myDestination;
        private EObject myLinkElement;
        private int myVisualID;
        private IAdaptable mySemanticAdapter;
        static /* synthetic */ Class class$0;

        protected LinkDescriptor(EObject source, EObject destination, EObject linkElement, int linkVID) {
            this(source, destination, linkVID);
            this.myLinkElement = linkElement;
            this.mySemanticAdapter = new EObjectAdapter(linkElement);
        }

        protected LinkDescriptor(EObject source, EObject destination, IElementType elementType, int linkVID) {
            this(source, destination, linkVID);
            this.myLinkElement = null;
            IElementType elementTypeCopy = elementType;
            this.mySemanticAdapter = new IAdaptable(this, elementTypeCopy){
                final /* synthetic */ LinkDescriptor this$1;
                private final /* synthetic */ IElementType val$elementTypeCopy;
                {
                    this.this$1 = linkDescriptor;
                    this.val$elementTypeCopy = iElementType;
                }

                public Object getAdapter(Class adapter) {
                    Class<?> clazz = LinkDescriptor.class$0;
                    if (clazz == null) {
                        try {
                            clazz = LinkDescriptor.class$0 = Class.forName("org.eclipse.gmf.runtime.emf.type.core.IElementType");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz.equals(adapter)) {
                        return this.val$elementTypeCopy;
                    }
                    return null;
                }
            };
        }

        private LinkDescriptor(EObject source, EObject destination, int linkVID) {
            this.mySource = source;
            this.myDestination = destination;
            this.myVisualID = linkVID;
        }

        protected EObject getSource() {
            return this.mySource;
        }

        protected EObject getDestination() {
            return this.myDestination;
        }

        protected EObject getLinkElement() {
            return this.myLinkElement;
        }

        protected int getVisualID() {
            return this.myVisualID;
        }

        protected IAdaptable getSemanticAdapter() {
            return this.mySemanticAdapter;
        }
    }
}

