/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.wizards.pages.simple;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gmf.internal.bridge.resolver.TypePattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolvedItem {
    public static final Resolution[] NO_RESOLUTIONS = new Resolution[1];
    public static final Resolution[] ALL_RESOLUTIONS;
    public static final Resolution[] NODE_LINK_RESOLUTIONS;
    public static final Resolution[] LINK_RESOLUTIONS;
    public static final Resolution[] LABEL_RESOLUTIONS;
    private Resolution resolution;
    private Object domainRef;
    private TypePattern pattern;
    private Resolution[] possibleResolutions;
    private boolean disabled;
    private ResolvedItem parent;
    private List<ResolvedItem> children = new ArrayList<ResolvedItem>();

    static {
        Resolution[] resolutionArray = new Resolution[4];
        resolutionArray[1] = Resolution.NODE;
        resolutionArray[2] = Resolution.LINK;
        resolutionArray[3] = Resolution.LABEL;
        ALL_RESOLUTIONS = resolutionArray;
        Resolution[] resolutionArray2 = new Resolution[3];
        resolutionArray2[1] = Resolution.NODE;
        resolutionArray2[2] = Resolution.LINK;
        NODE_LINK_RESOLUTIONS = resolutionArray2;
        Resolution[] resolutionArray3 = new Resolution[2];
        resolutionArray3[1] = Resolution.LINK;
        LINK_RESOLUTIONS = resolutionArray3;
        Resolution[] resolutionArray4 = new Resolution[2];
        resolutionArray4[1] = Resolution.LABEL;
        LABEL_RESOLUTIONS = resolutionArray4;
    }

    public ResolvedItem(Resolution resolution, Object domainRef, TypePattern pattern, Resolution[] possibleResolutions, boolean disabled) {
        this.resolution = resolution;
        this.domainRef = domainRef;
        this.pattern = pattern;
        this.possibleResolutions = possibleResolutions;
        this.disabled = disabled;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public Resolution[] getPossibleResolutions() {
        return this.possibleResolutions;
    }

    public boolean isPossibleResolution(Resolution possibleResolution) {
        int i = 0;
        while (i < this.possibleResolutions.length) {
            if (this.possibleResolutions[i] == possibleResolution) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Resolution getResolution() {
        return this.resolution;
    }

    public void setResolution(Resolution resolution) {
        this.resolution = resolution;
    }

    public Object getDomainRef() {
        return this.domainRef;
    }

    public TypePattern getPattern() {
        return this.pattern;
    }

    public ResolvedItem getParent() {
        return this.parent;
    }

    public void addChild(ResolvedItem child) {
        this.children.add(child);
        child.parent = this;
    }

    public void removeChild(ResolvedItem child) {
        if (this.children.remove(child)) {
            child.parent = null;
        }
    }

    public List<ResolvedItem> getChildren() {
        return this.children;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Resolution {
        NODE,
        LINK,
        LABEL;

    }
}

