/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.properties.sections.grid;

import com.ibm.icu.text.NumberFormat;
import java.text.ParseException;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.properties.internal.l10n.DiagramUIPropertiesImages;
import org.eclipse.gmf.runtime.diagram.ui.properties.internal.l10n.DiagramUIPropertiesMessages;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.appearance.ColorPalettePopup;
import org.eclipse.gmf.runtime.diagram.ui.properties.views.TextChangeHelper;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class RulerGridPropertySection
extends AbstractPropertySection {
    private Group displayGroup;
    private Group measurementGroup;
    private Group gridlineGroup;
    private Button gridVisibilityButton;
    private Button gridOrderButton;
    private Button snapToGridButton;
    private Button restoreButton;
    private Button rulerVisibilityButton;
    private Button lineColorButton;
    private static final String GRID_ON_LABEL = DiagramUIPropertiesMessages.Grid_On_Label_Text;
    private static final String GRID_LEVEL_LABEL = DiagramUIPropertiesMessages.Grid_Level_Label_Text;
    private static final String SNAP_TO_GRID_LABEL = DiagramUIPropertiesMessages.Snap_To_Grid_Label_Text;
    private static final String RULER_ON_LABEL = DiagramUIPropertiesMessages.Ruler_On_Label_Text;
    private static final String RULER_UNITS_LABEL = DiagramUIPropertiesMessages.Ruler_Units_Label_Text;
    private static final String GRID_SPACING_LABEL = DiagramUIPropertiesMessages.Grid_Spacing_Label_Text;
    private static final String VISIBILITY_LABEL = DiagramUIPropertiesMessages.Display_Group_Label_Text;
    private static final String MEASUREMENT_LABEL = DiagramUIPropertiesMessages.Measurement_Group_Label_Text;
    private static final String GRIDLINE_LABEL = DiagramUIPropertiesMessages.Gridline_Group_Label_Text;
    private static final String LINE_COLOR_LABEL = DiagramUIPropertiesMessages.Line_Color_Label_Text;
    private static final String LINE_STYLE_LABEL = DiagramUIPropertiesMessages.Line_Style_Label_Text;
    private static final String RESTORE_LABEL = DiagramUIPropertiesMessages.Restore_Defaults_Label_Text;
    private static final String INCHES_LABEL = DiagramUIPropertiesMessages.Inches_Label_Text;
    private static final String CENTIMETERS_LABEL = DiagramUIPropertiesMessages.Centimeters_Label_Text;
    private static final String PIXEL_LABEL = DiagramUIPropertiesMessages.Pixel_Label_Text;
    private static final String SOLID_LABEL = DiagramUIPropertiesMessages.Solid_Label_Text;
    private static final String DASH_LABEL = DiagramUIPropertiesMessages.Dash_Label_Text;
    private static final String DOT_LABEL = DiagramUIPropertiesMessages.Dot_Label_Text;
    private static final String DASH_DOT_LABEL = DiagramUIPropertiesMessages.Dash_Dot_Label_Text;
    private static final String DASH_DOT_DOT_LABEL = DiagramUIPropertiesMessages.Dash_Dot_Dot_Label_Text;
    private static final String SPACED_DOT_LABEL = DiagramUIPropertiesMessages.Spaced_Dot_Label_Text;
    private static final int LIGHT_GRAY_RGB = 0xC0C0C0;
    private CCombo rulerUnitCombo;
    private CCombo lineStyleCombo;
    private Text textWidget;
    private RGB lineColor = null;
    private static final int INCHES = 0;
    private static final int CENTIMETERS = 1;
    private static final int PIXELS = 2;
    private static final double INCH2CM = 2.54;
    private double minValidValue = 0.009;
    private double maxValidValue = 99.999;
    private PropertyStoreListener propertyListener = new PropertyStoreListener();
    private IPreferenceStore workspaceViewerProperties = null;
    private TextChangeHelper textListener = new TextChangeHelper(){
        boolean textModified = false;

        public void handleEvent(Event event) {
            switch (event.type) {
                case 1: {
                    this.textModified = true;
                    if (event.character != '\r') break;
                    this.textChanged((Control)event.widget);
                    break;
                }
                case 16: {
                    this.textChanged((Control)event.widget);
                }
            }
        }

        public void textChanged(Control control) {
            if (this.textModified) {
                String currentText = ((Text)control).getText();
                try {
                    double value = RulerGridPropertySection.this.convertStringToDouble(currentText);
                    double pixels = RulerGridPropertySection.this.convertToBase(value);
                    if (pixels >= RulerGridPropertySection.this.minValidValue && pixels <= RulerGridPropertySection.this.maxValidValue) {
                        RulerGridPropertySection.this.setWorkspaceProperty("rulergrid.gridspacing", value);
                        RulerGridPropertySection.this.setGridSpacing(value);
                    } else {
                        this.resetGridSpacing();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.resetGridSpacing();
                }
                this.textModified = false;
            }
        }

        private void resetGridSpacing() {
            double value = RulerGridPropertySection.this.getWorkspacePropertyDouble("rulergrid.gridspacing");
            RulerGridPropertySection.this.setGridSpacing(value);
        }
    };

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.initializeControls(parent);
    }

    private void initializeControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite topComposite = this.getWidgetFactory().createComposite(parent);
        topComposite.setLayout((Layout)new GridLayout(2, false));
        this.createDisplayGroup(topComposite);
        this.createMeasurementGroup(topComposite);
        Composite bottomComposite = this.getWidgetFactory().createComposite(parent);
        bottomComposite.setLayout((Layout)new GridLayout(2, false));
        this.createGridlineGroup(bottomComposite);
        Composite extraComposite = this.getWidgetFactory().createComposite(bottomComposite);
        extraComposite.setLayout((Layout)new GridLayout(1, false));
        this.snapToGridButton = this.getWidgetFactory().createButton(extraComposite, SNAP_TO_GRID_LABEL, 32);
        this.snapToGridButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RulerGridPropertySection.this.setWorkspaceProperty("rulergrid.snaptogrid", RulerGridPropertySection.this.snapToGridButton.getSelection());
            }
        });
        this.restoreButton = this.getWidgetFactory().createButton(extraComposite, RESTORE_LABEL, 8);
        this.restoreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                this.restorePreferenceValues();
            }

            private void restorePreferenceValues() {
                IPreferenceStore preferenceStore = RulerGridPropertySection.this.getPreferenceStore();
                IPreferenceStore wsPrefStore = RulerGridPropertySection.this.getWorkspaceViewerProperties();
                if (!wsPrefStore.getBoolean("rulergrid.gridlevel")) {
                    wsPrefStore.setValue("rulergrid.gridlevel", true);
                }
                if (wsPrefStore.getInt("rulergrid.gridlinecolor") != 0xC0C0C0) {
                    wsPrefStore.setValue("rulergrid.gridlinecolor", 0xC0C0C0);
                }
                if (wsPrefStore.getInt("rulergrid.gridlinestyle") != 6) {
                    wsPrefStore.setValue("rulergrid.gridlinestyle", 6);
                }
                if (wsPrefStore.getBoolean("rulergrid.viewrulers") != preferenceStore.getBoolean("GridRuler.showRulers")) {
                    wsPrefStore.setValue("rulergrid.viewrulers", preferenceStore.getBoolean("GridRuler.showRulers"));
                }
                if (wsPrefStore.getBoolean("rulergrid.viewgrid") != preferenceStore.getBoolean("GridRuler.showGrid")) {
                    wsPrefStore.setValue("rulergrid.viewgrid", preferenceStore.getBoolean("GridRuler.showGrid"));
                }
                if (wsPrefStore.getBoolean("rulergrid.snaptogrid") != preferenceStore.getBoolean("GridRuler.snapToGrid")) {
                    wsPrefStore.setValue("rulergrid.snaptogrid", preferenceStore.getBoolean("GridRuler.snapToGrid"));
                }
                if (wsPrefStore.getInt("rulergrid.rulerunit") != preferenceStore.getInt("GridRuler.rulerUnits") || wsPrefStore.getDouble("rulergrid.gridspacing") != preferenceStore.getDouble("GridRuler.gridSpacing")) {
                    wsPrefStore.setValue("rulergrid.rulerunit", preferenceStore.getInt("GridRuler.rulerUnits"));
                    wsPrefStore.setValue("rulergrid.gridspacing", preferenceStore.getDouble("GridRuler.gridSpacing"));
                }
                RulerGridPropertySection.this.setInput(RulerGridPropertySection.this.getPart(), null);
            }
        });
    }

    private IPreferenceStore getPreferenceStore() {
        IPreferenceStore preferenceStore = (IPreferenceStore)((DiagramEditor)this.getPart()).getDiagramEditPart().getDiagramPreferencesHint().getPreferenceStore();
        return preferenceStore;
    }

    private void createLineColorControl(Composite composite) {
        this.getWidgetFactory().createLabel(composite, LINE_COLOR_LABEL);
        this.lineColorButton = new Button(composite, 8);
        this.lineColorButton.setImage(DiagramUIPropertiesImages.get("icons/line_color.gif"));
        this.lineColorButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = DiagramUIMessages.PropertyDescriptorFactory_LineColor;
            }
        });
        this.lineColorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                this.changeLineColor(event);
            }

            private void changeLineColor(SelectionEvent event) {
                RulerGridPropertySection.this.lineColor = RulerGridPropertySection.this.changeColor(event, RulerGridPropertySection.this.lineColorButton, DiagramUIPropertiesImages.DESC_LINE_COLOR, RulerGridPropertySection.this.getWorkspacePropertyInt("rulergrid.gridlinecolor"));
                if (RulerGridPropertySection.this.lineColor != null) {
                    RulerGridPropertySection.this.setWorkspaceProperty("rulergrid.gridlinecolor", FigureUtilities.RGBToInteger((RGB)RulerGridPropertySection.this.lineColor));
                }
            }
        });
        this.lineColorButton.setEnabled(true);
    }

    private void createLineStyleControl(Composite composite) {
        this.getWidgetFactory().createLabel(composite, LINE_STYLE_LABEL);
        this.lineStyleCombo = this.getWidgetFactory().createCCombo(composite, 2060);
        this.lineStyleCombo.setItems(this.getStyles());
        this.lineStyleCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                this.updateLineStyle();
            }

            private void updateLineStyle() {
                int style = RulerGridPropertySection.this.lineStyleCombo.getSelectionIndex();
                RulerGridPropertySection.this.setWorkspaceProperty("rulergrid.gridlinestyle", style + 1);
            }
        });
    }

    private RGB changeColor(SelectionEvent event, Button button, ImageDescriptor imageDescriptor, int previousColor) {
        ColorPalettePopup popup = new ColorPalettePopup(button.getParent().getShell(), 25);
        popup.setPreviousColor(previousColor);
        Rectangle r = button.getBounds();
        Point location = button.getParent().toDisplay(r.x, r.y);
        popup.open(new Point(location.x, location.y + r.height));
        if (popup.useDefaultColor()) {
            Image overlyedImage = new ColorOverlayImageDescriptor(imageDescriptor.getImageData(), FigureUtilities.integerToRGB((Integer)new Integer(0xC0C0C0))).createImage();
            this.disposeImage(button.getImage());
            button.setImage(overlyedImage);
            return FigureUtilities.integerToRGB((Integer)new Integer(0xC0C0C0));
        }
        if (popup.getSelectedColor() != null) {
            Image overlyedImage = new ColorOverlayImageDescriptor(imageDescriptor.getImageData(), popup.getSelectedColor()).createImage();
            this.disposeImage(button.getImage());
            button.setImage(overlyedImage);
        }
        return popup.getSelectedColor();
    }

    private void disposeImage(Image image) {
        if (image == null) {
            return;
        }
        if (image.equals((Object)DiagramUIPropertiesImages.get("icons/line_color.gif"))) {
            return;
        }
        if (!image.isDisposed()) {
            image.dispose();
        }
    }

    private Double convertStringToDouble(String strValue) {
        Double value;
        NumberFormat numberFormatter = NumberFormat.getInstance();
        try {
            value = this.forceDouble(numberFormatter.parse(strValue));
        }
        catch (ParseException parseException) {
            value = new Double(this.getWorkspacePropertyDouble("rulergrid.gridspacing"));
            this.setGridSpacing(value);
        }
        return value;
    }

    private void setGridSpacing(double value) {
        NumberFormat numberFormater = NumberFormat.getInstance();
        this.textWidget.setText(numberFormater.format(value));
        this.textWidget.selectAll();
    }

    private void createMeasurementGroup(Composite composite) {
        this.measurementGroup = this.getWidgetFactory().createGroup(composite, MEASUREMENT_LABEL);
        this.measurementGroup.setLayout((Layout)new GridLayout(2, false));
        this.getWidgetFactory().createLabel((Composite)this.measurementGroup, RULER_UNITS_LABEL);
        this.rulerUnitCombo = this.getWidgetFactory().createCCombo((Composite)this.measurementGroup, 2060);
        this.rulerUnitCombo.setItems(this.getUnits());
        this.rulerUnitCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int newUnits;
                int oldUnits = RulerGridPropertySection.this.getWorkspacePropertyInt("rulergrid.rulerunit");
                if (oldUnits < (newUnits = RulerGridPropertySection.this.rulerUnitCombo.getSelectionIndex())) {
                    this.updateSpacing(oldUnits, newUnits);
                    this.updateRulerUnits();
                } else {
                    this.updateRulerUnits();
                    this.updateSpacing(oldUnits, newUnits);
                }
            }

            private void updateSpacing(int fromUnits, int toUnits) {
                String currentUnits = RulerGridPropertySection.this.convertUnits(fromUnits, toUnits);
                RulerGridPropertySection.this.setWorkspaceProperty("rulergrid.gridspacing", RulerGridPropertySection.this.convertStringToDouble(currentUnits));
            }

            private void updateRulerUnits() {
                int units = RulerGridPropertySection.this.getCurrentRulerUnit();
                RulerGridPropertySection.this.setWorkspaceProperty("rulergrid.rulerunit", units);
            }
        });
        this.getWidgetFactory().createLabel((Composite)this.measurementGroup, GRID_SPACING_LABEL);
        this.textWidget = this.getWidgetFactory().createText((Composite)this.measurementGroup, "", 2048);
        GridData data = new GridData(4, 4, true, false);
        this.textWidget.setLayoutData((Object)data);
        this.startTextWidgetEventListener();
    }

    private String convertUnits(int fromUnits, int toUnits) {
        String valueStr = this.textWidget.getText();
        if (fromUnits == toUnits) {
            return valueStr;
        }
        Double value = this.convertStringToDouble(valueStr);
        double pixelValue = 0.0;
        switch (fromUnits) {
            case 0: {
                pixelValue = value * (double)Display.getDefault().getDPI().x;
                break;
            }
            case 1: {
                pixelValue = value * (double)Display.getDefault().getDPI().x / 2.54;
                break;
            }
            case 2: {
                pixelValue = value.intValue();
            }
        }
        double returnValue = 0.0;
        switch (toUnits) {
            case 0: {
                returnValue = pixelValue / (double)Display.getDefault().getDPI().x;
                break;
            }
            case 1: {
                returnValue = pixelValue * 2.54 / (double)Display.getDefault().getDPI().x;
                break;
            }
            case 2: {
                returnValue = Math.round(pixelValue);
            }
        }
        NumberFormat numberFormatter = NumberFormat.getInstance();
        return numberFormatter.format(returnValue);
    }

    private double convertToBase(double number) {
        double returnValue = 0.0;
        switch (this.getCurrentRulerUnit()) {
            case 0: {
                returnValue = number;
                break;
            }
            case 1: {
                returnValue = number / 2.54;
                break;
            }
            case 2: {
                returnValue = number / (double)Display.getDefault().getDPI().x;
            }
        }
        return returnValue;
    }

    private int getCurrentRulerUnit() {
        return this.rulerUnitCombo.getSelectionIndex();
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.initWorkspacePropertyListener();
        double value = this.getWorkspacePropertyDouble("rulergrid.gridspacing");
        NumberFormat numberFormatter = NumberFormat.getNumberInstance();
        this.textWidget.setText(numberFormatter.format(value));
        this.rulerVisibilityButton.setSelection(this.getBooleanWorkspaceProperty("rulergrid.viewrulers"));
        this.gridVisibilityButton.setSelection(this.getBooleanWorkspaceProperty("rulergrid.viewgrid"));
        this.gridOrderButton.setSelection(this.getBooleanWorkspaceProperty("rulergrid.gridlevel"));
        this.snapToGridButton.setSelection(this.getBooleanWorkspaceProperty("rulergrid.snaptogrid"));
        int rulerValue = this.getValue("rulergrid.rulerunit");
        int styleValue = this.getValue("rulergrid.gridlinestyle") - 1;
        this.rulerUnitCombo.setText(this.getUnits()[rulerValue]);
        this.lineStyleCombo.setText(this.getStyles()[styleValue]);
        Image overlyedImage = new ColorOverlayImageDescriptor(DiagramUIPropertiesImages.DESC_LINE_COLOR.getImageData(), FigureUtilities.integerToRGB((Integer)this.getWorkspacePropertyInt("rulergrid.gridlinecolor"))).createImage();
        this.disposeImage(this.lineColorButton.getImage());
        this.lineColorButton.setImage(overlyedImage);
    }

    private int getValue(String property) {
        String valueString = this.getWorkspaceProperty(property);
        int value = valueString.equals("") ? 0 : new Integer(this.getWorkspaceProperty(property));
        return value;
    }

    private String[] getUnits() {
        return new String[]{INCHES_LABEL, CENTIMETERS_LABEL, PIXEL_LABEL};
    }

    private String[] getStyles() {
        return new String[]{SOLID_LABEL, DASH_LABEL, DOT_LABEL, DASH_DOT_LABEL, DASH_DOT_DOT_LABEL, SPACED_DOT_LABEL};
    }

    public void dispose() {
        this.stopTextWidgetEventListener();
        this.removeWorkspacePropertyListener();
        super.dispose();
    }

    private void startTextWidgetEventListener() {
        this.getListener().startListeningTo((Control)this.getTextWidget());
        this.getListener().startListeningForEnter((Control)this.getTextWidget());
    }

    private void stopTextWidgetEventListener() {
        this.getListener().stopListeningTo((Control)this.getTextWidget());
    }

    private Text getTextWidget() {
        return this.textWidget;
    }

    private TextChangeHelper getListener() {
        return this.textListener;
    }

    private void createDisplayGroup(Composite composite) {
        this.displayGroup = this.getWidgetFactory().createGroup(composite, VISIBILITY_LABEL);
        this.displayGroup.setLayout((Layout)new GridLayout(1, true));
        this.rulerVisibilityButton = this.getWidgetFactory().createButton((Composite)this.displayGroup, RULER_ON_LABEL, 32);
        this.rulerVisibilityButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RulerGridPropertySection.this.setWorkspaceProperty("rulergrid.viewrulers", RulerGridPropertySection.this.rulerVisibilityButton.getSelection());
            }
        });
        this.gridVisibilityButton = this.getWidgetFactory().createButton((Composite)this.displayGroup, GRID_ON_LABEL, 32);
        this.gridVisibilityButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RulerGridPropertySection.this.setWorkspaceProperty("rulergrid.viewgrid", RulerGridPropertySection.this.gridVisibilityButton.getSelection());
            }
        });
        this.gridOrderButton = this.getWidgetFactory().createButton((Composite)this.displayGroup, GRID_LEVEL_LABEL, 32);
        this.gridOrderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RulerGridPropertySection.this.setWorkspaceProperty("rulergrid.gridlevel", RulerGridPropertySection.this.gridOrderButton.getSelection());
            }
        });
    }

    private void createGridlineGroup(Composite composite) {
        this.gridlineGroup = this.getWidgetFactory().createGroup(composite, GRIDLINE_LABEL);
        GridLayout gridLayout = new GridLayout(2, false);
        this.gridlineGroup.setLayout((Layout)gridLayout);
        this.createLineColorControl((Composite)this.gridlineGroup);
        this.createLineStyleControl((Composite)this.gridlineGroup);
    }

    private void setWorkspaceProperty(String property, boolean setting) {
        this.getWorkspaceViewerProperties().setValue(property, setting);
    }

    private void setWorkspaceProperty(String property, int setting) {
        this.getWorkspaceViewerProperties().setValue(property, setting);
    }

    private void setWorkspaceProperty(String property, double setting) {
        this.getWorkspaceViewerProperties().setValue(property, setting);
    }

    private String getWorkspaceProperty(String property) {
        return this.getWorkspaceViewerProperties().getString(property);
    }

    private int getWorkspacePropertyInt(String property) {
        return this.getWorkspaceViewerProperties().getInt(property);
    }

    private double getWorkspacePropertyDouble(String property) {
        return this.getWorkspaceViewerProperties().getDouble(property);
    }

    private boolean getBooleanWorkspaceProperty(String property) {
        return this.getWorkspaceViewerProperties().getBoolean(property);
    }

    private IPreferenceStore getWorkspaceViewerProperties() {
        return this.workspaceViewerProperties;
    }

    private void handleWorkspacePropertyChanged(PropertyChangeEvent event) {
        if ("rulergrid.viewgrid".equals(event.getProperty())) {
            if (!this.gridVisibilityButton.isDisposed()) {
                this.gridVisibilityButton.setSelection(this.getEventBoolean(event));
            }
        } else if ("rulergrid.viewrulers".equals(event.getProperty())) {
            if (!this.rulerVisibilityButton.isDisposed()) {
                this.rulerVisibilityButton.setSelection(this.getEventBoolean(event));
            }
        } else if ("rulergrid.snaptogrid".equals(event.getProperty())) {
            if (!this.snapToGridButton.isDisposed()) {
                this.snapToGridButton.setSelection(this.getEventBoolean(event));
            }
        } else if ("rulergrid.gridlevel".equals(event.getProperty())) {
            if (!this.gridOrderButton.isDisposed()) {
                this.gridOrderButton.setSelection(this.getEventBoolean(event));
            }
        } else if ("rulergrid.gridspacing".equals(event.getProperty())) {
            if (!this.textWidget.isDisposed()) {
                Double value = new Double(this.getEventString(event));
                this.textWidget.setText(NumberFormat.getInstance().format((Object)value));
            }
        } else if ("rulergrid.rulerunit".equals(event.getProperty())) {
            if (!this.rulerUnitCombo.isDisposed()) {
                this.rulerUnitCombo.select(Integer.parseInt(this.getEventString(event)));
            }
        } else if ("rulergrid.gridlinestyle".equals(event.getProperty()) && !this.lineStyleCombo.isDisposed()) {
            this.lineStyleCombo.select(Integer.parseInt(this.getEventString(event)) - 1);
        }
    }

    private boolean getEventBoolean(PropertyChangeEvent event) {
        Boolean newValue = (Boolean)event.getNewValue();
        return newValue;
    }

    private String getEventString(PropertyChangeEvent event) {
        return event.getNewValue().toString();
    }

    private void initWorkspacePropertyListener() {
        IDiagramWorkbenchPart editor = (IDiagramWorkbenchPart)this.getPart();
        if (editor == null) {
            return;
        }
        DiagramGraphicalViewer viewer = (DiagramGraphicalViewer)editor.getDiagramGraphicalViewer();
        this.workspaceViewerProperties = viewer.getWorkspaceViewerPreferenceStore();
        this.workspaceViewerProperties.addPropertyChangeListener((IPropertyChangeListener)this.propertyListener);
    }

    private void removeWorkspacePropertyListener() {
        if (this.getWorkspaceViewerProperties() != null) {
            this.getWorkspaceViewerProperties().removePropertyChangeListener((IPropertyChangeListener)this.propertyListener);
            this.workspaceViewerProperties = null;
        }
        this.propertyListener = null;
    }

    private Double forceDouble(Number number) {
        if (!(number instanceof Double)) {
            return new Double(number.doubleValue());
        }
        return (Double)number;
    }

    private static class ColorOverlayImageDescriptor
    extends CompositeImageDescriptor {
        private static final Point ICON_SIZE = new Point(16, 16);
        private ImageData basicImgData;
        private RGB rgb;

        public ColorOverlayImageDescriptor(ImageData basicImgData, RGB rgb) {
            this.basicImgData = basicImgData;
            this.rgb = rgb;
        }

        protected void drawCompositeImage(int width, int height) {
            if (this.rgb != null) {
                ImageData colorBar = new ImageData(width, height / 5, 1, new PaletteData(new RGB[]{this.rgb}));
                this.drawImage(colorBar, 0, height - height / 5);
            }
            this.drawImage(this.basicImgData, 0, 0);
        }

        protected Point getSize() {
            return ICON_SIZE;
        }
    }

    private class PropertyStoreListener
    implements IPropertyChangeListener {
        private PropertyStoreListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            RulerGridPropertySection.this.handleWorkspacePropertyChanged(event);
        }
    }
}

