/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.validate;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.internal.validate.StatusCodes;
import org.eclipse.gmf.tests.validate.AnnotationUtil;
import org.eclipse.gmf.tests.validate.DynamicModelHelper;
import org.eclipse.gmf.tests.validate.MetaExpressionDefTestBase;
import org.eclipse.gmf.validate.GMFValidator;

public class ValueSpecDefTest
extends MetaExpressionDefTestBase {
    EStructuralFeature restrictTypeFeature;

    public ValueSpecDefTest(String name) {
        super(name, "ValueSpec");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.restrictTypeFeature = DynamicModelHelper.createFeature(this.containerClass, (EClassifier)EcorePackage.eINSTANCE.getEDataType());
    }

    public void testBodyTypeRestriction() throws Exception {
        this.setTypeRestrictionExpression();
        EObject constraintInstance = EcoreUtil.create((EClass)this.constraintMetaClass);
        constraintInstance.eSet(this.languageAttr, (Object)"ocl");
        constraintInstance.eSet(this.bodyAttr, (Object)"2006");
        EObject owner = this.bindToNewContextInstance(constraintInstance);
        owner.eSet(this.restrictTypeFeature, (Object)EcorePackage.eINSTANCE.getEDouble());
        Diagnostic status = GMFValidator.validate((EObject)owner);
        ValueSpecDefTest.assertEquals((int)0, (int)status.getSeverity());
    }

    public void testBodyTypeRestrictionViolation() throws Exception {
        this.setTypeRestrictionExpression();
        EObject constraintInstance = EcoreUtil.create((EClass)this.constraintMetaClass);
        constraintInstance.eSet(this.languageAttr, (Object)"ocl");
        constraintInstance.eSet(this.bodyAttr, (Object)"self.name");
        EObject owner = this.bindToNewContextInstance(constraintInstance);
        owner.eSet(this.restrictTypeFeature, (Object)EcorePackage.eINSTANCE.getEDouble());
        Diagnostic status = GMFValidator.validate((EObject)owner);
        ValueSpecDefTest.assertEquals((int)4, (int)status.getSeverity());
        ValueSpecDefTest.assertEquals((int)StatusCodes.INVALID_EXPRESSION_TYPE, (int)AnnotationUtil.getChildDiagnostic(status).getCode());
    }

    private void setTypeRestrictionExpression() {
        EAnnotation eAnnotation = AnnotationUtil.createAnnotation((EModelElement)this.constraintRefFeatureCtx, "http://www.eclipse.org/gmf/2005/constraints/meta");
        eAnnotation.getDetails().put((Object)"def", (Object)"type");
        eAnnotation.getDetails().put((Object)"ocl", (Object)this.restrictTypeFeature.getName());
    }
}

