/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.core.ui.launch;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.m2m.atl.common.ATLExecutionException;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.core.ATLCoreException;
import org.eclipse.m2m.atl.core.launch.ILauncher;
import org.eclipse.m2m.atl.core.service.CoreService;
import org.eclipse.m2m.atl.core.service.LauncherService;
import org.eclipse.m2m.atl.core.ui.ATLCoreUIPlugin;
import org.eclipse.m2m.atl.core.ui.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtlLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    private static Map<String, IFile> moduleFilesByModuleName;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        moduleFilesByModuleName = new HashMap<String, IFile>();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String launcherName = configuration.getAttribute("ATL VM", "");
        String atlCompiler = configuration.getAttribute("ATL_COMPILER", "");
        boolean isRefining = configuration.getAttribute("IS_REFINING", false);
        HashMap<String, Object> options = new HashMap<String, Object>();
        boolean isRefiningTraceMode = "atl2006".equals(atlCompiler) && isRefining;
        options.put("isRefiningTraceMode", new Boolean(isRefiningTraceMode).toString());
        options.put("launch", launch);
        options.put("monitor", monitor);
        String fileName = configuration.getAttribute("ATL File Name", "<null>");
        Map sourceModels = configuration.getAttribute("Input", Collections.EMPTY_MAP);
        Map targetModels = configuration.getAttribute("Output", Collections.EMPTY_MAP);
        Map launchConfigModelPaths = configuration.getAttribute("Path", Collections.EMPTY_MAP);
        Map<String, String> modelPaths = AtlLaunchConfigurationDelegate.convertPaths(launchConfigModelPaths);
        Map libs = configuration.getAttribute("Libs", Collections.EMPTY_MAP);
        List superimps = configuration.getAttribute("Superimpose", Collections.EMPTY_LIST);
        options.putAll(configuration.getAttribute("Options", Collections.EMPTY_MAP));
        Map modelHandlers = configuration.getAttribute("Model Handler", Collections.EMPTY_MAP);
        options.put("modelHandlers", modelHandlers);
        Object clearConsole = options.get("OPTION_CLEAR");
        if (clearConsole != null && "true".equals(clearConsole)) {
            ATLCoreUIPlugin.clearConsole();
        }
        ILauncher launcher = null;
        try {
            launcher = CoreService.getLauncher((String)launcherName);
        }
        catch (ATLCoreException e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getMessage(), (Throwable)e);
        }
        if (launcher == null) {
            String[] registeredLaunchers = CoreService.getLaunchersNames();
            ATLLogger.severe((String)Messages.getString("AtlLaunchConfigurationDelegate.LAUNCHER_NOT_FOUND", launcherName, Arrays.asList(registeredLaunchers)));
            return;
        }
        IFile currentAtlFile = ResourcesPlugin.getWorkspace().getRoot().getFile(Path.fromOSString((String)fileName));
        String currentExtension = currentAtlFile.getFileExtension().toLowerCase();
        if (currentExtension.equals("atl")) {
            String currentAsmPath = String.valueOf(currentAtlFile.getFullPath().toString().substring(0, currentAtlFile.getFullPath().toString().length() - currentExtension.length())) + "asm";
            currentAtlFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(currentAsmPath));
        }
        if (!AtlLaunchConfigurationDelegate.addLaunchedModule(currentAtlFile)) {
            return;
        }
        InputStream asmInputStream = currentAtlFile.getContents();
        InputStream[] modules = new InputStream[superimps.size() + 1];
        modules[0] = asmInputStream;
        int i = 1;
        while (i < modules.length) {
            String moduleFileName = (String)superimps.get(i - 1);
            IFile moduleFile = ResourcesPlugin.getWorkspace().getRoot().getFile(Path.fromOSString((String)moduleFileName));
            if (!AtlLaunchConfigurationDelegate.addLaunchedModule(moduleFile)) {
                return;
            }
            modules[i] = moduleFile.getContents();
            ++i;
        }
        HashMap<String, InputStream> libraries = new HashMap<String, InputStream>();
        for (String libName : libs.keySet()) {
            IFile libFile = ResourcesPlugin.getWorkspace().getRoot().getFile(Path.fromOSString((String)((String)libs.get(libName))));
            if (!AtlLaunchConfigurationDelegate.addLaunchedModule(libFile)) {
                return;
            }
            libraries.put(libName, libFile.getContents());
        }
        if (monitor.isCanceled()) {
            return;
        }
        try {
            try {
                if (isRefiningTraceMode) {
                    List orderedOutput;
                    Iterator<Object> sourceIterator = sourceModels.keySet().iterator();
                    Iterator<Object> targetIterator = targetModels.keySet().iterator();
                    List orderedInput = configuration.getAttribute("OrderedInput", Collections.EMPTY_LIST);
                    if (!orderedInput.isEmpty()) {
                        sourceIterator = orderedInput.iterator();
                    }
                    if (!(orderedOutput = configuration.getAttribute("OrderedOutput", Collections.EMPTY_LIST)).isEmpty()) {
                        targetIterator = orderedOutput.iterator();
                    }
                    HashMap newTargetModels = new HashMap();
                    newTargetModels.putAll(targetModels);
                    ArrayList<String> targetToRemove = new ArrayList<String>();
                    block11: while (sourceIterator.hasNext()) {
                        String sourceModelName = (String)sourceIterator.next();
                        String sourceMetamodelName = (String)sourceModels.get(sourceModelName);
                        while (targetIterator.hasNext()) {
                            String targetModelName = (String)targetIterator.next();
                            String targetMetamodelName = (String)targetModels.get(targetModelName);
                            if (!targetMetamodelName.equals(sourceMetamodelName) || targetToRemove.contains(targetModelName)) continue;
                            String targetModelPath = modelPaths.get(targetModelName);
                            String refinedModelPathName = LauncherService.getRefinedModelName((String)sourceModelName);
                            modelPaths.put(refinedModelPathName, targetModelPath);
                            targetToRemove.add(targetModelName);
                            continue block11;
                        }
                    }
                    for (String key : targetToRemove) {
                        newTargetModels.remove(key);
                    }
                    LauncherService.launch((String)mode, (IProgressMonitor)monitor, (ILauncher)launcher, (Map)Collections.EMPTY_MAP, (Map)sourceModels, newTargetModels, modelPaths, options, libraries, (InputStream[])modules);
                } else {
                    LauncherService.launch((String)mode, (IProgressMonitor)monitor, (ILauncher)launcher, (Map)sourceModels, (Map)Collections.EMPTY_MAP, (Map)targetModels, modelPaths, options, libraries, (InputStream[])modules);
                }
                if ("true".equals(options.get("OPTION_DERIVED".toString()))) {
                    for (String targetModel : targetModels.keySet()) {
                        String path = (String)launchConfigModelPaths.get(targetModel);
                        this.setDerived(path);
                    }
                }
            }
            catch (ATLCoreException e) {
                ATLLogger.severe((String)e.getMessage());
                monitor.done();
                return;
            }
            catch (ATLExecutionException e) {
                ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private static boolean addLaunchedModule(IFile file) {
        if (!file.exists()) {
            ATLLogger.severe((String)Messages.getString("AtlLaunchConfigurationDelegate.FILE_NOT_EXIST", file.getFullPath()));
            return false;
        }
        IFile atlFile = file;
        if (atlFile != null) {
            String ext = atlFile.getFileExtension().toLowerCase();
            if (ext.equals("asm")) {
                String path = String.valueOf(atlFile.getFullPath().toString().substring(0, atlFile.getFullPath().toString().length() - ext.length())) + "atl";
                atlFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
            }
            if (atlFile.isAccessible()) {
                moduleFilesByModuleName.put(AtlLaunchConfigurationDelegate.computeModuleName(file), atlFile);
            }
        }
        return true;
    }

    public static IFile getFileFromModuleName(String moduleName) {
        if (moduleFilesByModuleName != null) {
            return moduleFilesByModuleName.get(moduleName);
        }
        return null;
    }

    private static String computeModuleName(IFile file) {
        String res = file.getName();
        try {
            InputStreamReader streamReader = new InputStreamReader(file.getContents());
            BufferedReader buffer = new BufferedReader(streamReader);
            String line = "";
            while ((line = buffer.readLine()) != null) {
                if (!line.contains("<constant value=")) continue;
                res = line.split("\\\"")[1];
                buffer.close();
                streamReader.close();
                break;
            }
        }
        catch (Throwable throwable) {}
        return res;
    }

    public static Map<String, String> convertPaths(Map<String, String> modelPaths) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String modelName : modelPaths.keySet()) {
            String modelPath = modelPaths.get(modelName);
            result.put(modelName, AtlLaunchConfigurationDelegate.convertPath(modelPath));
        }
        return result;
    }

    public static String convertPath(String path) {
        if (path.startsWith("ext:")) {
            return path.replaceFirst("ext:", "file:/");
        }
        if (path.startsWith("uri:")) {
            return path.substring(4);
        }
        if (path.startsWith("#") || path.startsWith("platform:") || path.startsWith("pathmap")) {
            return path;
        }
        return "platform:/resource" + path;
    }

    private void setDerived(String filePath) {
        if (Platform.isRunning()) {
            try {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath));
                if (file.exists()) {
                    file.setDerived(true);
                }
            }
            catch (IllegalStateException e) {
                ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (CoreException e) {
                ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }
}

