/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm.nativelib;

import java.io.FileInputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.engine.injectors.Injector;
import org.eclipse.m2m.atl.engine.injectors.xml.XMLInjector;
import org.eclipse.m2m.atl.engine.vm.ModelLoader;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMHashModelElement;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModelElement;

public class ASMHashModel
extends ASMModel {
    private Map contents = new HashMap();
    private static Map injectors = new HashMap();

    static {
        injectors.put("xml", XMLInjector.class);
    }

    private Set getContentsSetForType(ASMModelElement type) {
        HashSet ret = (HashSet)this.contents.get(type);
        if (ret == null) {
            ret = new HashSet();
            this.contents.put(type, ret);
        }
        return ret;
    }

    private ASMHashModel(String name, ASMModel metamodel, boolean isTarget, ModelLoader ml) {
        super(name, metamodel, isTarget, ml);
    }

    public ASMModelElement findModelElement(String name) {
        ATLLogger.severe((String)"ERROR: can't use ASMHashModel as a meta-model so far.");
        return null;
    }

    public ASMModelElement newModelElement(ASMModelElement type) {
        ASMHashModelElement ret = new ASMHashModelElement(this, type);
        this.getContentsSetForType(type).add(ret);
        return ret;
    }

    public static ASMHashModel newASMHashModel(String name, ASMModel metamodel, ModelLoader ml) throws Exception {
        return new ASMHashModel(name, metamodel, true, ml);
    }

    public Set getElementsByType(ASMModelElement ame) {
        HashSet ret = new HashSet();
        this.realGetElementsByType(ame, ret);
        return ret;
    }

    private void realGetElementsByType(ASMModelElement ame, Set ret) {
        Iterator i = this.getContentsSetForType(ame).iterator();
        while (i.hasNext()) {
            ret.add(i.next());
        }
    }

    public static ASMHashModel loadASMHashModel(String name, ASMModel metamodel, String url, ModelLoader ml) throws Exception {
        ASMHashModel ret = ASMHashModel.newASMHashModel(name, metamodel, ml);
        String[] ss = url.split(":");
        if (ss.length == 1) {
            ss = new String[]{"xmi", ss[0]};
        }
        String other = null;
        if (ss.length == 3) {
            other = ss[1];
        }
        Class injectorClass = (Class)injectors.get(ss[0]);
        FileInputStream in = new FileInputStream(ss[ss.length - 1]);
        Injector im = (Injector)injectorClass.newInstance();
        im.performImportation(metamodel, ret, in, other);
        ret.setIsTarget(false);
        return ret;
    }
}

