/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.completion;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.Map;
import lpg.lpgjavaruntime.IToken;
import lpg.lpgjavaruntime.LexStream;
import lpg.lpgjavaruntime.PrsStream;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnvFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalFileEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalVisitorCS;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFile;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFileUtil;
import org.eclipse.m2m.internal.qvt.oml.compiler.IImportResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.ParsedModuleCS;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompiler;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.cst.CSTFactory;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingModuleCS;
import org.eclipse.m2m.internal.qvt.oml.cst.parser.AbstractQVTParser;
import org.eclipse.m2m.internal.qvt.oml.cst.parser.QvtOpLPGParser;
import org.eclipse.m2m.internal.qvt.oml.cst.parser.QvtOpLexer;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.Activator;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.CFileData;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.LightweightParserUtil;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.QvtCompletionData;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.QvtCompletionVisitorCS;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.keywordhandler.IKeywordHandler;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.keywordhandler.KeywordHandlerRegistry;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.OCLInput;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.lpg.BasicEnvironment;
import org.eclipse.ocl.parser.OCLLexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtCompletionCompiler
extends QvtCompiler {
    private final QvtCompletionData myData;
    private final Map<CFile, CFileData> myCFileDataMap = new LinkedHashMap<CFile, CFileData>();
    private QvtOperationalEnv myEnvironment;

    public QvtCompletionCompiler(IImportResolver importResolver, QvtCompletionData data) {
        super(importResolver);
        this.myData = data;
    }

    public Map<CFile, CFileData> getCFileDataMap() {
        return this.myCFileDataMap;
    }

    public QvtOpLexer createLexer(CFile cFile) throws IOException, ParserException, BadLocationException {
        CFileData cFileData = this.getCFileData(cFile);
        if (cFileData.getLexer() != null) {
            return cFileData.getLexer();
        }
        Reader reader = this.getCFileReader(cFile);
        QvtOpLexer lexer = new QvtOpLexer((BasicEnvironment)new QvtOperationalEnvFactory().createEnvironment(null, cFile, this.getKernel()));
        cFileData.setLexer(lexer);
        try {
            lexer.initialize(new OCLInput(reader).getContent(), cFile.getName());
            lexer.lexer(new PrsStream((LexStream)lexer));
        }
        finally {
            reader.close();
        }
        return lexer;
    }

    private Reader getCFileReader(CFile cFile) throws IOException, BadLocationException {
        if (cFile == this.myData.getCFile()) {
            String documentText = this.myData.getDocument().get(0, this.myData.getDocument().getLength());
            return new StringReader(documentText);
        }
        return CFileUtil.getReader((CFile)cFile);
    }

    public QvtOperationalEnv compileAll() {
        if (this.myEnvironment == null) {
            this.myEnvironment = new QvtOperationalEnvFactory().createEnvironment(null, (CFile)this.myData.getCFile(), this.getKernel());
            QvtCompilerOptions options = new QvtCompilerOptions();
            options.setReportErrors(false);
            options.setShowAnnotations(false);
            options.setSourceLineNumbersEnabled(false);
            OCLLexer oclLexer = new OCLLexer((Environment)this.myEnvironment);
            try {
                oclLexer.initialize(new OCLInput("").getContent(), this.myData.getCFile().getName());
                QvtCompletionVisitorCS visitorCS = new QvtCompletionVisitorCS(oclLexer, (QvtOperationalFileEnv)this.myEnvironment, options, this.myData);
                options.setQvtOperationalVisitorCS((QvtOperationalVisitorCS)visitorCS);
                try {
                    this.compile((CFile)this.myData.getCFile(), options, null);
                    this.myEnvironment = visitorCS.getEnv();
                }
                catch (MdaException ex) {
                    Activator.log(ex);
                }
            }
            catch (ParserException ex) {
                Activator.log(ex);
            }
        }
        return this.myEnvironment;
    }

    protected ParsedModuleCS parseInternal(CFile source) throws IOException {
        CFileData cFileData = this.compile(source);
        QvtOpLPGParser qvtParser = new QvtOpLPGParser(cFileData.getLexer());
        MappingModuleCS mappingModuleCS = cFileData.getMappingModuleCS();
        if (mappingModuleCS == null) {
            mappingModuleCS = CSTFactory.eINSTANCE.createMappingModuleCS();
        }
        return new ParsedModuleCS(mappingModuleCS, source, (AbstractQVTParser)qvtParser);
    }

    private CFileData compile(CFile cFile) {
        CFileData cFileData = this.getCFileData(cFile);
        try {
            QvtOpLexer lexer = this.createLexer(cFile);
            PrsStream prsStream = lexer.getPrsStream();
            IKeywordHandler[] keywordHandlers = KeywordHandlerRegistry.getInstance().getKeywordHandlers();
            StringBuilder lightweightScriptBuilder = new StringBuilder(lexer.getStreamLength());
            int i = 0;
            int n = prsStream.getSize();
            while (i < n) {
                IToken token = prsStream.getTokenAt(i);
                IKeywordHandler[] iKeywordHandlerArray = keywordHandlers;
                int n2 = keywordHandlers.length;
                int n3 = 0;
                while (n3 < n2) {
                    IKeywordHandler keywordHandler = iKeywordHandlerArray[n3];
                    String contribution = keywordHandler.handle(token, prsStream, this.myData, cFileData);
                    if (contribution != null) {
                        int offsetDelta = token.getStartOffset() - lightweightScriptBuilder.length();
                        int j = 0;
                        while (j < offsetDelta - 1) {
                            lightweightScriptBuilder.append(' ');
                            ++j;
                        }
                        lightweightScriptBuilder.append(contribution);
                        break;
                    }
                    ++n3;
                }
                ++i;
            }
            String lightweightScript = lightweightScriptBuilder.toString();
            cFileData.setLightweightScript(lightweightScript);
            CSTNode cstNode = LightweightParserUtil.parse(lightweightScript, cFile, LightweightParserUtil.ParserTypeEnum.LIGHTWEIGHT_PARSER);
            if (cstNode instanceof MappingModuleCS) {
                cFileData.setMappingModuleCS((MappingModuleCS)cstNode);
            }
        }
        catch (Exception ex) {
            Activator.log(ex);
        }
        return cFileData;
    }

    public CFileData getCFileData(CFile cFile) {
        CFileData cFileData = this.myCFileDataMap.get(cFile);
        if (cFileData == null) {
            cFileData = new CFileData(cFile, this.myData);
            this.myCFileDataMap.put(cFile, cFileData);
        }
        return cFileData;
    }

    public CFileData getCFileData(MappingModuleCS mappingModuleCS) {
        for (CFileData cFileData : this.myCFileDataMap.values()) {
            if (cFileData.getMappingModuleCS() != mappingModuleCS) continue;
            return cFileData;
        }
        return null;
    }
}

