/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks;

import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTBindingHelper;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFile;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingDeclarationCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingRuleCS;
import org.eclipse.m2m.internal.qvt.oml.cst.ResolveInExpCS;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.CSTHelper;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.HyperlinkUtil;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.IHyperlinkDetectorHelper;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.QvtFileHyperlink;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.ResolveInExp;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.SimpleNameCS;
import org.eclipse.ocl.cst.TypeCS;
import org.eclipse.ocl.utilities.ASTNode;

public class ResolveInHyperlinkDetector
implements IHyperlinkDetectorHelper {
    public IHyperlink detectHyperlink(IHyperlinkDetectorHelper.IDetectionContext context) {
        CSTNode element = context.getSyntaxElement();
        if (element instanceof ResolveInExpCS) {
            ResolveInExpCS resolveInExpCS = (ResolveInExpCS)element;
            TypeCS type = resolveInExpCS.getInMappingType();
            SimpleNameCS inMappingNameCS = resolveInExpCS.getInMappingName();
            if (type != null && inMappingNameCS != null) {
                MappingDeclarationCS mappingDeclCS;
                String mappingName = inMappingNameCS.getValue();
                int mappingNameStartOffset = inMappingNameCS.getStartOffset();
                int length = inMappingNameCS.getEndOffset() - inMappingNameCS.getStartOffset() + 1;
                if (HyperlinkUtil.isOffsetInRange(context.getRegion().getOffset(), mappingNameStartOffset, mappingNameStartOffset + mappingName.length()) && (mappingDeclCS = ResolveInHyperlinkDetector.findReferencedDefinitionCS(resolveInExpCS)) != null) {
                    CFile sourceFile = CSTHelper.getSourceFile((CSTNode)mappingDeclCS);
                    if (sourceFile == null) {
                        return null;
                    }
                    IRegion destReg = HyperlinkUtil.createRegion(ResolveInHyperlinkDetector.getLinkDestinationNode(mappingDeclCS));
                    return new QvtFileHyperlink((IRegion)new Region(mappingNameStartOffset, length), sourceFile, destReg, destReg);
                }
            }
        }
        return null;
    }

    public static MappingOperation findReferencedDefinition(ResolveInExpCS resolveInExpCS) {
        ResolveInExp resolveInAST = (ResolveInExp)ASTBindingHelper.resolveASTNode((CSTNode)resolveInExpCS, ResolveInExp.class);
        if (resolveInAST != null && !resolveInAST.getInMappings().isEmpty()) {
            return (MappingOperation)resolveInAST.getInMappings().get(0);
        }
        return null;
    }

    private static MappingDeclarationCS findReferencedDefinitionCS(ResolveInExpCS resolveInExpCS) {
        MappingRuleCS mappingRuleCS;
        MappingOperation mappingOperation = ResolveInHyperlinkDetector.findReferencedDefinition(resolveInExpCS);
        if (mappingOperation != null && (mappingRuleCS = (MappingRuleCS)ASTBindingHelper.resolveCSTNode((ASTNode)mappingOperation, MappingRuleCS.class)) != null) {
            return mappingRuleCS.getMappingDeclarationCS();
        }
        return null;
    }

    private static CSTNode getLinkDestinationNode(MappingDeclarationCS mappingDeclCS) {
        SimpleNameCS linkDestCS = mappingDeclCS.getSimpleNameCS();
        if (linkDestCS == null) {
            linkDestCS = mappingDeclCS;
        }
        return linkDestCS;
    }
}

