/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.stdlib;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtLibraryOperation;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnvFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalUtil;
import org.eclipse.m2m.internal.qvt.oml.expressions.ExpressionsFactory;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.library.IContext;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.Library;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.LibraryCreationException;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.LibraryOperation;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandler;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandlerAdapter;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.util.TypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyNativeLibSupport {
    public static final LegacyNativeLibSupport INSTANCE = LegacyNativeLibSupport.createInstance();

    private LegacyNativeLibSupport() {
    }

    public Module defineLibrary(QvtOperationalEnv targetEnv, Library lib, ResourceSet rs) throws LibraryCreationException {
        Module libModule = ExpressionsFactory.eINSTANCE.createModule();
        libModule.setName(lib.getId());
        QvtOperationalEnv libEnv = QvtOperationalEnvFactory.INSTANCE.createModuleEnvironment(libModule);
        for (LibraryOperation libOp : lib.getLibraryOperations()) {
            QvtLibraryOperation qvtLibOp = new QvtLibraryOperation(libEnv, libOp, rs);
            Object ctxType = qvtLibOp.getContextType();
            if (ctxType == targetEnv.getOCLStandardLibrary().getOclVoid()) {
                ctxType = libModule;
            }
            LegacyNativeLibSupport.defineOperation(targetEnv, libOp, ctxType, qvtLibOp.getReturnType(), libOp.getName(), qvtLibOp.getParamTypes());
        }
        return libModule;
    }

    private static Object callOperation(QvtOperationalEvaluationEnv evalEnv, IContext context, LibraryOperation libOp, Object source, Object[] args, Class<?> returnClass) {
        Object result;
        if (source == null || source == evalEnv.getInvalid()) {
            return evalEnv.getInvalid();
        }
        Object[] callArgs = null;
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                if (evalEnv.isOclInvalid(args[i])) {
                    if (callArgs == null) {
                        callArgs = new Object[args.length];
                        System.arraycopy(args, 0, callArgs, 0, args.length);
                    }
                    callArgs[i] = null;
                }
                ++i;
            }
            Object[] objectArray = callArgs = callArgs == null ? args : callArgs;
        }
        if ((result = libOp.run(source, callArgs, new Object[0], returnClass)) == null) {
            return QvtOperationalUtil.getOclInvalid();
        }
        return result;
    }

    private static EOperation defineOperation(QvtOperationalEnv env, LibraryOperation libOperation, EClassifier contextType, EClassifier returnType, String opName, EClassifier ... paramTypes) {
        ArrayList<Variable> stringArgList = new ArrayList<Variable>();
        EClassifier[] eClassifierArray = paramTypes;
        int n = paramTypes.length;
        int n2 = 0;
        while (n2 < n) {
            EClassifier cls = eClassifierArray[n2];
            Variable stringVariable = org.eclipse.ocl.expressions.ExpressionsFactory.eINSTANCE.createVariable();
            stringVariable.setName(cls.getName());
            stringVariable.setType((Object)cls);
            stringArgList.add(stringVariable);
            ++n2;
        }
        EOperation operation = (EOperation)TypeUtil.findOperationMatching((Environment)env, (Object)contextType, (String)opName, stringArgList);
        if (operation == null) {
            operation = env.defineOperation(contextType, opName, returnType, stringArgList, EcoreFactory.eINSTANCE.createConstraint());
            Class returnClass = returnType != null ? returnType.getInstanceClass() : null;
            CallHandlerAdapter.attach(operation, new Handler(libOperation, returnClass));
        }
        return operation;
    }

    private static LegacyNativeLibSupport createInstance() {
        LegacyNativeLibSupport lib = new LegacyNativeLibSupport();
        return lib;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Handler
    implements CallHandler {
        private LibraryOperation fOperation;
        private Class<?> fReturnClass;

        private Handler(LibraryOperation operation, Class<?> returnClass) {
            assert (operation != null);
            this.fOperation = operation;
            this.fReturnClass = returnClass;
        }

        @Override
        public Object invoke(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv, IContext context) {
            return LegacyNativeLibSupport.callOperation(evalEnv, context, this.fOperation, source, args, this.fReturnClass);
        }
    }
}

