/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.stdlib;

import java.util.HashSet;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.env.ModelParameterExtent;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstance;
import org.eclipse.m2m.internal.qvt.oml.stdlib.AbstractContextualOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.AbstractQVTStdlib;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandler;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandlerAdapter;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.util.TypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementOperations
extends AbstractContextualOperations {
    static final String DEEP_CLONE_NAME = "deepclone";
    static final String CLONE_NAME = "clone";
    static final int FILTER_ALL = 0;
    static final int FILTER_OF_TYPE = 1;
    static final int FILTER_OF_KIND = 2;
    private static final CallHandler DEEP_CLONE = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof EObject) {
                EObject eObject = (EObject)source;
                EObject result = EcoreUtil.copy((EObject)eObject);
                ModelParameterExtent extent = evalEnv.getDefaultInstantiationExtent((EClassifier)eObject.eClass());
                if (extent != null) {
                    extent.addObject(result);
                }
                return result;
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static final CallHandler CLONE = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof EObject) {
                EObject eObject = (EObject)source;
                EcoreUtil.Copier copier = new EcoreUtil.Copier(){

                    protected void copyContainment(EReference arg0, EObject arg1, EObject arg2) {
                    }
                };
                EObject result = copier.copy(eObject);
                copier.copyReferences();
                ModelParameterExtent extent = evalEnv.getDefaultInstantiationExtent((EClassifier)eObject.eClass());
                if (extent != null) {
                    TreeIterator contentIter = EcoreUtil.getAllProperContents((EObject)result, (boolean)false);
                    while (contentIter.hasNext()) {
                        extent.addObject((EObject)contentIter.next());
                    }
                    extent.addObject(result);
                }
                return result;
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static final String CONTAINER_NAME = "container";
    private static final CallHandler CONTAINER = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof EObject) {
                EObject eObject = (EObject)source;
                return eObject.eContainer();
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static final String METACLASS_NAME = "metaClassName";
    private static final CallHandler METACLASS = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof EObject) {
                EObject eObject = (EObject)source;
                return eObject.eClass().getName();
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static final String SUBOBJECTS_NAME = "subobjects";
    private static final CallHandler SUBOBJECTS = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof EObject) {
                EObject eObject = (EObject)source;
                return ElementOperations.getSubObjects(eObject, null, 0, evalEnv);
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static final String SUBOBJECTS_OF_TYPE_NAME = "subobjectsOfType";
    private static final CallHandler SUBOBJECTS_OF_TYPE = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof EObject) {
                EObject eObject = (EObject)source;
                return ElementOperations.getSubObjects(eObject, ElementOperations.getTypeFilterArg(args), 1, evalEnv);
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static final String SUBOBJECTS_OF_KIND_NAME = "subobjectsOfKind";
    private static final CallHandler SUBOBJECTS_OF_KIND = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof EObject) {
                EObject eObject = (EObject)source;
                return ElementOperations.getSubObjects(eObject, ElementOperations.getTypeFilterArg(args), 2, evalEnv);
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static final String ALL_SUBOBJECTS_NAME = "allSubobjects";
    private static final CallHandler ALL_SUBOBJECTS = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof EObject) {
                EObject eObject = (EObject)source;
                return ElementOperations.getAllSubObjects(eObject, null, 0, evalEnv);
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static final String ALL_SUBOBJECTS_OF_TYPE_NAME = "allSubobjectsOfType";
    private static final CallHandler ALL_SUBOBJECTS_OF_TYPE = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof EObject) {
                EObject eObject = (EObject)source;
                EClassifier type = ElementOperations.getTypeFilterArg(args);
                return ElementOperations.getAllSubObjects(eObject, type, 1, evalEnv);
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static final String ALL_SUBOBJECTS_OF_KIND_NAME = "allSubobjectsOfKind";
    private static final CallHandler ALL_SUBOBJECTS_OF_KIND = new CallHandler(){

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof EObject) {
                EObject eObject = (EObject)source;
                EClassifier type = ElementOperations.getTypeFilterArg(args);
                return ElementOperations.getAllSubObjects(eObject, type, 2, evalEnv);
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };

    public ElementOperations(AbstractQVTStdlib library) {
        super(library, library.getElementType());
    }

    @Override
    protected AbstractContextualOperations.OperationProvider[] getOperations() {
        EClassifier elementSet = (EClassifier)TypeUtil.resolveSetType((Environment)this.getStdlib().getEnvironment(), (Object)this.getStdlib().getElementType());
        EClassifier oclType = (EClassifier)this.getStdlib().getOCLStdLib().getOclType();
        return new AbstractContextualOperations.OwnedOperationProvider[]{(AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(UNSUPPORTED_OPER, "_localId", (EClassifier)this.getOclStdlib().getString(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(UNSUPPORTED_OPER, "_globalId", (EClassifier)this.getOclStdlib().getString(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(ALL_SUBOBJECTS, ALL_SUBOBJECTS_NAME, elementSet, new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(ALL_SUBOBJECTS_OF_TYPE, ALL_SUBOBJECTS_OF_TYPE_NAME, new String[]{"type"}, elementSet, oclType), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(ALL_SUBOBJECTS_OF_KIND, ALL_SUBOBJECTS_OF_KIND_NAME, new String[]{"type"}, elementSet, oclType), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(CLONE, CLONE_NAME, this.getStdlib().getElementType(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(CONTAINER, CONTAINER_NAME, this.getStdlib().getElementType(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(DEEP_CLONE, DEEP_CLONE_NAME, this.getStdlib().getElementType(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(UNSUPPORTED_OPER, "markedAs", new String[]{"value"}, (EClassifier)this.getOclStdlib().getBoolean(), (EClassifier)this.getOclStdlib().getString()), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(UNSUPPORTED_OPER, "markValue", this.getStdlib().getObject(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(METACLASS, METACLASS_NAME, (EClassifier)this.getOclStdlib().getString(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(UNSUPPORTED_OPER, "stereotypedBy", new String[]{"value"}, (EClassifier)this.getOclStdlib().getBoolean(), (EClassifier)this.getOclStdlib().getString()), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(UNSUPPORTED_OPER, "stereotypedStrictBy", new String[]{"value"}, (EClassifier)this.getOclStdlib().getBoolean(), (EClassifier)this.getOclStdlib().getString()), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(SUBOBJECTS, SUBOBJECTS_NAME, elementSet, new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(SUBOBJECTS_OF_TYPE, SUBOBJECTS_OF_TYPE_NAME, new String[]{"type"}, elementSet, oclType), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(SUBOBJECTS_OF_KIND, SUBOBJECTS_OF_KIND_NAME, new String[]{"type"}, elementSet, oclType)};
    }

    private OCLStandardLibrary<EClassifier> getOclStdlib() {
        return this.getStdlib().getEnvironment().getOCLStandardLibrary();
    }

    private static EClassifier getTypeFilterArg(Object[] args) {
        if (args.length != 1) {
            throw new IllegalArgumentException();
        }
        Object typeObj = args[0];
        if (!(typeObj instanceof EClassifier)) {
            throw new IllegalArgumentException();
        }
        return (EClassifier)typeObj;
    }

    private static Object getAllSubObjects(EObject eObject, EClassifier type, int filterFlag, QvtOperationalEvaluationEnv evalEnv) {
        HashSet<EObject> result = new HashSet<EObject>();
        TreeIterator iter = EcoreUtil.getAllContents((EObject)eObject, (boolean)false);
        while (iter.hasNext()) {
            boolean accept;
            EObject subObject = (EObject)iter.next();
            boolean bl = accept = filterFlag == 0;
            if (2 == filterFlag) {
                accept = evalEnv.isKindOf(subObject, type);
            } else if (1 == filterFlag) {
                boolean bl2 = accept = subObject.eClass() == type;
            }
            if (!accept) continue;
            result.add(subObject);
        }
        return result;
    }

    private static Object getSubObjects(EObject eObject, EClassifier type, int filterFlag, QvtOperationalEvaluationEnv evalEnv) {
        HashSet<EObject> result = new HashSet<EObject>();
        for (EObject subObject : eObject.eContents()) {
            boolean accept;
            boolean bl = accept = filterFlag == 0;
            if (2 == filterFlag) {
                accept = evalEnv.isKindOf(subObject, type);
            } else if (1 == filterFlag) {
                boolean bl2 = accept = subObject.eClass() == type;
            }
            if (!accept) continue;
            result.add(subObject);
        }
        return result;
    }
}

