/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.internal.utils.compatibility;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.acceleo.common.AcceleoCommonPlugin;
import org.eclipse.acceleo.common.internal.utils.compatibility.AcceleoCompatibilityHelper;
import org.eclipse.acceleo.common.internal.utils.compatibility.OCLVersion;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.types.OCLStandardLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoOCLReflection {
    private EcoreEnvironment environment;
    private Object invalid;
    private EClassifier oclInvalid;
    private Set<String> reservedKeywords;

    public AcceleoOCLReflection(EcoreEnvironment env) {
        this.environment = env;
    }

    public Object getInvalid() {
        if (this.invalid == null) {
            OCLStandardLibrary stdLib = this.environment.getOCLStandardLibrary();
            String methodName = "getInvalid";
            if (AcceleoCompatibilityHelper.getCurrentVersion() == OCLVersion.GANYMEDE || AcceleoCompatibilityHelper.getCurrentVersion() == OCLVersion.GALILEO) {
                methodName = "getOclInvalid";
            }
            try {
                Method method = stdLib.getClass().getMethod(methodName, new Class[0]);
                this.invalid = method.invoke((Object)stdLib, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                AcceleoCommonPlugin.log(e, true);
            }
            catch (InvocationTargetException e) {
                AcceleoCommonPlugin.log(e, true);
            }
            catch (IllegalAccessException e) {
                AcceleoCommonPlugin.log(e, true);
            }
        }
        return this.invalid;
    }

    public EClassifier getOCLInvalid() {
        if (this.oclInvalid == null) {
            OCLStandardLibrary stdLib = this.environment.getOCLStandardLibrary();
            String methodName = "getOclInvalid";
            if (AcceleoCompatibilityHelper.getCurrentVersion() == OCLVersion.GANYMEDE || AcceleoCompatibilityHelper.getCurrentVersion() == OCLVersion.GALILEO) {
                methodName = "getInvalid";
            }
            try {
                Method method = stdLib.getClass().getMethod(methodName, new Class[0]);
                this.oclInvalid = (EClassifier)method.invoke((Object)stdLib, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                AcceleoCommonPlugin.log(e, true);
            }
            catch (InvocationTargetException e) {
                AcceleoCommonPlugin.log(e, true);
            }
            catch (IllegalAccessException e) {
                AcceleoCommonPlugin.log(e, true);
            }
        }
        return this.oclInvalid;
    }

    public Set<String> getReservedKeywords() {
        if (this.reservedKeywords != null) {
            return this.reservedKeywords;
        }
        this.reservedKeywords = new HashSet<String>();
        this.reservedKeywords.add("and");
        this.reservedKeywords.add("context");
        this.reservedKeywords.add("def");
        this.reservedKeywords.add("else");
        this.reservedKeywords.add("endif");
        this.reservedKeywords.add("endpackage");
        this.reservedKeywords.add("if");
        this.reservedKeywords.add("implies");
        this.reservedKeywords.add("in");
        this.reservedKeywords.add("inv");
        this.reservedKeywords.add("let");
        this.reservedKeywords.add("not");
        this.reservedKeywords.add("or");
        this.reservedKeywords.add("package");
        this.reservedKeywords.add("post");
        this.reservedKeywords.add("pre");
        this.reservedKeywords.add("then");
        this.reservedKeywords.add("xor");
        if (AcceleoCompatibilityHelper.getCurrentVersion() == OCLVersion.GANYMEDE || AcceleoCompatibilityHelper.getCurrentVersion() == OCLVersion.GALILEO) {
            this.reservedKeywords.add("attr");
            this.reservedKeywords.add("oper");
        } else {
            this.reservedKeywords.add("body");
            this.reservedKeywords.add("derive");
            this.reservedKeywords.add("init");
            this.reservedKeywords.add("static");
        }
        return this.reservedKeywords;
    }
}

