/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.service;

import java.io.File;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.engine.AcceleoEvaluationException;
import org.eclipse.acceleo.engine.event.AcceleoTextGenerationListener;
import org.eclipse.acceleo.engine.generation.AcceleoGenericEngine;
import org.eclipse.acceleo.engine.generation.IAcceleoEngine;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.acceleo.model.mtl.VisibilityKind;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.ecore.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcceleoService {
    private static final IAcceleoEngine GENERATION_ENGINE = new AcceleoGenericEngine();
    private static final String TEMPLATE_CALL_NPE = AcceleoEngineMessages.getString("AcceleoService.NullArguments");

    private AcceleoService() {
    }

    public static void addListener(AcceleoTextGenerationListener listener) {
        GENERATION_ENGINE.addListener(listener);
    }

    public static Map<String, Writer> doGenerate(Map<Module, Set<String>> templates, EObject model, File generationRoot, boolean preview) {
        if (templates == null || model == null || !preview && generationRoot == null) {
            throw new NullPointerException(TEMPLATE_CALL_NPE);
        }
        HashMap templateTypes = new HashMap();
        for (Map.Entry<Module, Set<String>> entry : templates.entrySet()) {
            for (String string : entry.getValue()) {
                Template template = AcceleoService.findTemplate(entry.getKey(), string, 1);
                EClassifier templateType = (EClassifier)((Variable)template.getParameter().get(0)).getType();
                if (templateTypes.containsKey(templateType)) {
                    ((Set)templateTypes.get(templateType)).add(template);
                    continue;
                }
                HashSet<Template> temp = new HashSet<Template>();
                temp.add(template);
                templateTypes.put(templateType, temp);
            }
        }
        HashMap<String, Writer> previewResult = new HashMap<String, Writer>();
        ArrayList<EObject> arguments = new ArrayList<EObject>();
        arguments.add(model);
        for (Map.Entry entry : templateTypes.entrySet()) {
            if (!((EClassifier)entry.getKey()).isInstance((Object)model)) continue;
            for (Template template : (Set)entry.getValue()) {
                previewResult.putAll(AcceleoService.doGenerateTemplate(template, arguments, generationRoot, preview));
            }
        }
        TreeIterator treeIterator = model.eAllContents();
        while (treeIterator.hasNext()) {
            EObject potentialTarget = (EObject)treeIterator.next();
            for (Map.Entry entry : templateTypes.entrySet()) {
                if (!((EClassifier)entry.getKey()).isInstance((Object)potentialTarget)) continue;
                arguments.clear();
                arguments.add(potentialTarget);
                for (Template template : (Set)entry.getValue()) {
                    previewResult.putAll(AcceleoService.doGenerateTemplate(template, arguments, generationRoot, preview));
                }
            }
        }
        return previewResult;
    }

    public static Map<String, Writer> doGenerate(Module module, String templateName, EObject model, File generationRoot, boolean preview) {
        return AcceleoService.doGenerate(AcceleoService.findTemplate(module, templateName, 1), model, generationRoot, preview);
    }

    public static Map<String, Writer> doGenerate(Module module, String templateName, EObject model, List<? extends Object> arguments, File generationRoot, boolean preview) {
        if (model == null || arguments == null || !preview && generationRoot == null) {
            throw new NullPointerException(TEMPLATE_CALL_NPE);
        }
        Template template = AcceleoService.findTemplate(module, templateName, arguments.size() + 1);
        if (template.getVisibility() != VisibilityKind.PUBLIC) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEngine.IllegalTemplateInvocation"));
        }
        HashMap<String, Writer> previewResult = new HashMap<String, Writer>();
        EClassifier argumentType = (EClassifier)((Variable)template.getParameter().get(0)).getType();
        if (argumentType.isInstance((Object)model)) {
            ArrayList<? extends Object> actualArguments = new ArrayList<Object>();
            actualArguments.add(model);
            actualArguments.addAll(arguments);
            previewResult.putAll(AcceleoService.doGenerateTemplate(template, actualArguments, generationRoot, preview));
        }
        TreeIterator targetElements = model.eAllContents();
        while (targetElements.hasNext()) {
            EObject potentialTarget = (EObject)targetElements.next();
            if (!argumentType.isInstance((Object)potentialTarget)) continue;
            ArrayList<? extends Object> actualArguments = new ArrayList<Object>();
            actualArguments.add(potentialTarget);
            actualArguments.addAll(arguments);
            previewResult.putAll(AcceleoService.doGenerateTemplate(template, actualArguments, generationRoot, preview));
        }
        return previewResult;
    }

    public static Map<String, Writer> doGenerate(Template template, EObject model, File generationRoot, boolean preview) {
        if (template == null || model == null || !preview && generationRoot == null) {
            throw new NullPointerException(TEMPLATE_CALL_NPE);
        }
        if (template.getVisibility() != VisibilityKind.PUBLIC) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEngine.IllegalTemplateInvocation"));
        }
        if (template.getParameter().size() != 1) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEngine.VoidArguments"));
        }
        HashMap<String, Writer> previewResult = new HashMap<String, Writer>();
        EClassifier argumentType = (EClassifier)((Variable)template.getParameter().get(0)).getType();
        ArrayList<EObject> arguments = new ArrayList<EObject>();
        if (argumentType.isInstance((Object)model)) {
            arguments.add(model);
            previewResult.putAll(AcceleoService.doGenerateTemplate(template, arguments, generationRoot, preview));
        }
        TreeIterator targetElements = model.eAllContents();
        while (targetElements.hasNext()) {
            EObject potentialTarget = (EObject)targetElements.next();
            if (!argumentType.isInstance((Object)potentialTarget)) continue;
            arguments.clear();
            arguments.add(potentialTarget);
            previewResult.putAll(AcceleoService.doGenerateTemplate(template, arguments, generationRoot, preview));
        }
        return previewResult;
    }

    public static Map<String, Writer> doGenerateTemplate(Module module, String templateName, List<? extends Object> arguments, File generationRoot, boolean preview) {
        return AcceleoService.doGenerateTemplate(AcceleoService.findTemplate(module, templateName, arguments), arguments, generationRoot, preview);
    }

    public static Map<String, Writer> doGenerateTemplate(Template template, List<? extends Object> arguments, File generationRoot, boolean preview) {
        return GENERATION_ENGINE.evaluate(template, arguments, generationRoot, preview);
    }

    public static void removeListener(AcceleoTextGenerationListener listener) {
        GENERATION_ENGINE.removeListener(listener);
    }

    private static Template findTemplate(Module module, String templateName, int argumentCount) {
        for (ModuleElement element : module.getOwnedModuleElement()) {
            Template template;
            if (!(element instanceof Template) || (template = (Template)element).getVisibility() != VisibilityKind.PUBLIC || !templateName.equals(template.getName()) || template.getParameter().size() != argumentCount) continue;
            return template;
        }
        throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoService.UndefinedTemplate", templateName, module.getName()));
    }

    private static Template findTemplate(Module module, String templateName, List<? extends Object> arguments) {
        for (ModuleElement element : module.getOwnedModuleElement()) {
            Template template;
            if (!(element instanceof Template) || (template = (Template)element).getVisibility() != VisibilityKind.PUBLIC || !templateName.equals(template.getName()) || template.getParameter().size() != arguments.size()) continue;
            boolean parameterMatch = true;
            int i = 0;
            while (i < template.getParameter().size()) {
                if (!((EClassifier)((Variable)template.getParameter().get(i)).getType()).isInstance(arguments.get(i))) {
                    parameterMatch = false;
                }
                ++i;
            }
            if (!parameterMatch) continue;
            return template;
        }
        throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoService.UndefinedTemplate", templateName, module.getName()));
    }
}

